/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.io.cml.ICMLModule;

public class CMLModuleStack {
    ICMLModule[] stack = new ICMLModule[64];
    int sp = 0;

    public void push(ICMLModule item) {
        if (this.sp == this.stack.length) {
            ICMLModule[] temp = new ICMLModule[2 * this.sp];
            System.arraycopy(this.stack, 0, temp, 0, this.sp);
            this.stack = temp;
        }
        this.stack[this.sp++] = item;
    }

    public int length() {
        return this.sp;
    }

    public ICMLModule pop() {
        return this.stack[--this.sp];
    }

    public ICMLModule current() {
        if (this.sp > 0) {
            return this.stack[this.sp - 1];
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        for (int i = 0; i < this.sp; ++i) {
            sb.append(this.stack[i].getClass().getSimpleName());
            sb.append('/');
        }
        return sb.toString();
    }

    public boolean endsWith(ICMLModule lastElement) {
        return this.stack[this.sp - 1].equals(lastElement);
    }

    public boolean endsWith(ICMLModule oneButLast, ICMLModule lastElement) {
        return this.endsWith(lastElement) && this.stack[this.sp - 2].equals(oneButLast);
    }

    public boolean endsWith(ICMLModule twoButLast, ICMLModule oneButLast, ICMLModule lastElement) {
        return this.endsWith(oneButLast, lastElement) && this.stack[this.sp - 3].equals(twoButLast);
    }
}

