/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.surface;

import javax.vecmath.Point3d;
import org.openscience.cdk.geometry.surface.Triangle;

public class Tessellate {
    Triangle[] oldtess;
    final int maxlevel;

    public Tessellate() {
        this.oldtess = this.repIco();
        this.maxlevel = 4;
    }

    public Tessellate(String type, int level) {
        if (type.equals("tet")) {
            this.oldtess = this.repTet();
        } else if (type.equals("oct")) {
            this.oldtess = this.repOct();
        } else if (type.equals("ico")) {
            this.oldtess = this.repIco();
        }
        this.maxlevel = level;
    }

    private Point3d midpoint(Point3d p1, Point3d p2) {
        double x = 0.5 * (p1.x + p2.x);
        double y = 0.5 * (p1.y + p2.y);
        double z = 0.5 * (p1.z + p2.z);
        return new Point3d(x, y, z);
    }

    private void normalize(Point3d p) {
        double mag = p.x * p.x + p.y * p.y + p.z * p.z;
        if (mag != 0.0) {
            mag = 1.0 / Math.sqrt(mag);
            p.x *= mag;
            p.y *= mag;
            p.z *= mag;
        }
    }

    public void doTessellate() {
        for (int j = 1; j < this.maxlevel; ++j) {
            int i;
            int oldN = this.oldtess.length;
            int newN = oldN * 4;
            Triangle[] newtess = new Triangle[newN];
            for (i = 0; i < oldN; ++i) {
                Triangle old = this.oldtess[i];
                Point3d p1 = this.midpoint(old.p1, old.p3);
                Point3d p2 = this.midpoint(old.p1, old.p2);
                Point3d p3 = this.midpoint(old.p2, old.p3);
                this.normalize(p1);
                this.normalize(p2);
                this.normalize(p3);
                newtess[i * 4] = new Triangle(old.p1, p2, p1);
                newtess[i * 4 + 1] = new Triangle(p2, old.p2, p3);
                newtess[i * 4 + 2] = new Triangle(p1, p2, p3);
                newtess[i * 4 + 3] = new Triangle(p1, p3, old.p3);
            }
            this.oldtess = new Triangle[newN];
            for (i = 0; i < newN; ++i) {
                this.oldtess[i] = newtess[i];
            }
        }
    }

    public int getNumberOfTriangles() {
        return this.oldtess.length;
    }

    public Triangle[] getTessAsTriangles() {
        return this.oldtess;
    }

    public Point3d[] getTessAsPoint3ds() {
        Point3d[] ret = new Point3d[this.getNumberOfTriangles() * 3];
        for (int i = 0; i < this.getNumberOfTriangles(); ++i) {
            ret[i * 3] = this.oldtess[i].p1;
            ret[i * 3 + 1] = this.oldtess[i].p2;
            ret[i * 3 + 2] = this.oldtess[i].p3;
        }
        return ret;
    }

    private Triangle[] repTet() {
        double sqrt3 = 0.5773502692;
        Point3d[] v = new Point3d[]{new Point3d(sqrt3, sqrt3, sqrt3), new Point3d(-sqrt3, -sqrt3, sqrt3), new Point3d(-sqrt3, sqrt3, -sqrt3), new Point3d(sqrt3, -sqrt3, -sqrt3)};
        Triangle[] rep = new Triangle[]{new Triangle(v[0], v[1], v[2]), new Triangle(v[0], v[3], v[1]), new Triangle(v[2], v[1], v[3]), new Triangle(v[3], v[0], v[2])};
        return rep;
    }

    private Triangle[] repOct() {
        Point3d[] v = new Point3d[]{new Point3d(1.0, 0.0, 0.0), new Point3d(-1.0, 0.0, 0.0), new Point3d(0.0, 1.0, 0.0), new Point3d(0.0, -1.0, 0.0), new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, -1.0)};
        Triangle[] rep = new Triangle[]{new Triangle(v[0], v[4], v[2]), new Triangle(v[2], v[4], v[1]), new Triangle(v[1], v[4], v[3]), new Triangle(v[3], v[4], v[0]), new Triangle(v[0], v[2], v[5]), new Triangle(v[2], v[1], v[5]), new Triangle(v[1], v[3], v[5]), new Triangle(v[3], v[0], v[5])};
        return rep;
    }

    private Triangle[] repIco() {
        double tau = 0.8506508084;
        double one = 0.5257311121;
        Point3d[] v = new Point3d[]{new Point3d(tau, one, 0.0), new Point3d(-tau, one, 0.0), new Point3d(-tau, -one, 0.0), new Point3d(tau, -one, 0.0), new Point3d(one, 0.0, tau), new Point3d(one, 0.0, -tau), new Point3d(-one, 0.0, -tau), new Point3d(-one, 0.0, tau), new Point3d(0.0, tau, one), new Point3d(0.0, -tau, one), new Point3d(0.0, -tau, -one), new Point3d(0.0, tau, -one)};
        Triangle[] rep = new Triangle[]{new Triangle(v[4], v[8], v[7]), new Triangle(v[4], v[7], v[9]), new Triangle(v[5], v[6], v[11]), new Triangle(v[5], v[10], v[6]), new Triangle(v[0], v[4], v[3]), new Triangle(v[0], v[3], v[5]), new Triangle(v[2], v[7], v[1]), new Triangle(v[2], v[1], v[6]), new Triangle(v[8], v[0], v[11]), new Triangle(v[8], v[11], v[1]), new Triangle(v[9], v[10], v[3]), new Triangle(v[9], v[2], v[10]), new Triangle(v[8], v[4], v[0]), new Triangle(v[11], v[0], v[5]), new Triangle(v[4], v[9], v[3]), new Triangle(v[5], v[3], v[10]), new Triangle(v[7], v[8], v[1]), new Triangle(v[6], v[1], v[11]), new Triangle(v[7], v[2], v[9]), new Triangle(v[6], v[10], v[2])};
        return rep;
    }
}

