/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class GeneralizedMinDomVarSelector<V extends Variable>
implements VariableSelector<V> {
    private final boolean least;

    public GeneralizedMinDomVarSelector() {
        this(true);
    }

    public GeneralizedMinDomVarSelector(boolean leastFree) {
        this.least = leastFree;
    }

    @Override
    public V getVariable(V[] variables) {
        int small_dsize = Integer.MAX_VALUE;
        V nextVar = null;
        for (V v : variables) {
            int dsize;
            if (v.isInstantiated()) continue;
            int kind = v.getTypeAndKind() & 0x3F8;
            if (kind == 8 || kind == 24) {
                dsize = v.getDomainSize();
            } else if (kind == 64) {
                RealVar rv = (RealVar)v;
                dsize = 2 + (int)((rv.getUB() - rv.getLB()) / rv.getPrecision());
            } else if (kind == 32) {
                SetVar sv = (SetVar)v;
                dsize = 1 + (sv.getUB().size() - sv.getLB().size());
            } else {
                throw new UnsupportedOperationException("unrocognised variable kind");
            }
            if (nextVar == null) {
                nextVar = v;
                small_dsize = dsize;
                continue;
            }
            if (dsize <= 1 || dsize >= Integer.MAX_VALUE || dsize < small_dsize != this.least) continue;
            small_dsize = dsize;
            nextVar = v;
        }
        return nextVar;
    }
}

