/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.r;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Iterables;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.modelling.OutlierDescriptor;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.interpolation.AverageInterpolator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.AdditiveOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.LevelShiftFactory;
import jdplus.toolkit.base.core.modelling.regression.PeriodicOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.TransitoryChangeFactory;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaToolkit;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regarima.outlier.FastOutlierDetector;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.regsarima.ami.FastOutliersDetector;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.toolkit.base.protobuf.outliers.OutliersProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import jdplus.tramoseats.base.core.tramo.internal.TramoUtility;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TramoOutliersDetection {
    public static Results process(TsData ts, int[] order, int[] seasonal, boolean mean, Matrix x, boolean bao, boolean bls, boolean btc, boolean bso, double cv, boolean ml, boolean clean) {
        TsData y = ts;
        if (clean) {
            y = ts.cleanExtremities();
            if (x != null && ts.length() != y.length()) {
                int start = ts.getStart().until(y.getStart());
                x = x.extract(start, y.length(), 0, x.getColumnsCount());
            }
        }
        SarimaOrders spec = new SarimaOrders(y.getAnnualFrequency());
        spec.setP(order[0]);
        spec.setD(order[1]);
        spec.setQ(order[2]);
        if (seasonal != null) {
            spec.setBp(seasonal[0]);
            spec.setBd(seasonal[1]);
            spec.setBq(seasonal[2]);
        }
        double[] yc = y.getValues().toArray();
        IntList missings = new IntList();
        AverageInterpolator.cleanMissings((double[])yc, (IntList)missings);
        int[] m = missings.toArray();
        SarimaModel arima = SarimaModel.builder((SarimaOrders)spec).setDefault().build();
        RegArimaModel regarima = RegArimaModel.builder().arima((IArimaModel)arima).meanCorrection(mean).y(DoubleSeq.of((double[])yc)).addX(FastMatrix.of((Matrix)x)).missing(m).build();
        RegArimaEstimation estimation0 = RegSarimaComputer.builder().build().process(regarima, null);
        FastOutlierDetector detector = new FastOutlierDetector(null);
        ArrayList<Object> factories = new ArrayList<Object>();
        if (bao) {
            factories.add(AdditiveOutlierFactory.FACTORY);
        }
        if (bls) {
            factories.add(LevelShiftFactory.FACTORY_ZEROENDED);
        }
        if (btc) {
            factories.add(new TransitoryChangeFactory(0.7));
        }
        if (bso) {
            factories.add(new PeriodicOutlierFactory(y.getAnnualFrequency(), true));
        }
        detector.setOutlierFactories((IOutlierFactory[])factories.toArray(IOutlierFactory[]::new));
        FastOutliersDetector od = FastOutliersDetector.builder().singleOutlierDetector((SingleOutlierDetector)detector).criticalValue(cv <= 0.0 ? TramoUtility.calcCv((int)y.length()) : cv).maximumLikelihood(ml).processor(RegArimaUtility.processor((boolean)true, (double)1.0E-7)).build();
        od.prepare(yc.length);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < factories.size(); ++j) {
                od.exclude(m[i], j);
            }
        }
        if (!od.process(regarima, (IArimaMapping)SarimaMapping.of((SarimaOrders)spec))) {
            return null;
        }
        int[][] o = od.getOutliers();
        String[] ids = od.outlierTypes();
        OutlierDescriptor[] outliers = new OutlierDescriptor[o.length];
        for (int i = 0; i < o.length; ++i) {
            outliers[i] = new OutlierDescriptor(ids[o[i][1]], o[i][0]);
        }
        int np = spec.getParametersCount();
        RegArimaModel regarima1 = od.getRegArima();
        RegArimaEstimation estimation1 = RegArimaToolkit.concentratedLikelihood((RegArimaModel)regarima1);
        return Results.builder().initialArima((SarimaModel)estimation0.getModel().arima()).finalArima((SarimaModel)regarima1.arima()).initialLikelihood(estimation0.statistics()).finalLikelihood(estimation1.statistics()).regressors((Matrix)estimation1.getModel().variables()).outliers(outliers).coefficients(estimation1.getConcentratedLikelihood().coefficients().toArray()).coefficientsCovariance((Matrix)estimation1.getConcentratedLikelihood().covariance(np, true)).x(x).y(y).linearized(RegArimaUtility.linearizedData((RegArimaModel)estimation1.getModel(), (ConcentratedLikelihoodWithMissing)estimation1.getConcentratedLikelihood())).residuals(estimation1.getConcentratedLikelihood().e()).build();
    }

    @Generated
    private TramoOutliersDetection() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Results
    implements GenericExplorable {
        private final SarimaModel initialArima;
        private final SarimaModel finalArima;
        private final TsData y;
        private final Matrix x;
        private final OutlierDescriptor[] outliers;
        private final double[] coefficients;
        private final Matrix coefficientsCovariance;
        private final Matrix regressors;
        private final DoubleSeq linearized;
        private final DoubleSeq residuals;
        private final LikelihoodStatistics initialLikelihood;
        private final LikelihoodStatistics finalLikelihood;
        static final String Y = "y";
        static final String ARIMA0 = "initialarima";
        static final String ARIMA1 = "finalarima";
        static final String LL0 = "initiallikelihood";
        static final String LL1 = "finallikelihood";
        static final String B = "b";
        static final String T = "t";
        static final String BVAR = "bvar";
        static final String OUTLIERS = "outliers";
        static final String REGRESSORS = "regressors";
        static final String BNAMES = "variables";
        static final String CMPS = "cmps";
        static final String LIN = "linearized";
        private static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(){

            public Class<Results> getSourceClass() {
                return Results.class;
            }
        };

        public byte[] buffer() {
            SarimaOrders orders = this.initialArima.orders();
            int nx = this.x == null ? 0 : this.x.getColumnsCount();
            OutliersProtos.RegArimaSolution.Builder builder = OutliersProtos.RegArimaSolution.newBuilder().addAllArimaInitial(Iterables.of((DoubleSeq)this.initialArima.parameters())).addAllArimaFinal(Iterables.of((DoubleSeq)this.finalArima.parameters())).addAllCoefficients(Iterables.of((double[])this.coefficients)).setCovariance(ToolkitProtosUtility.convert((Matrix)this.coefficientsCovariance)).setRegressors(ToolkitProtosUtility.convert((Matrix)this.regressors)).setLikelihoodInitial(ToolkitProtosUtility.convert((LikelihoodStatistics)this.initialLikelihood)).setLikelihoodFinal(ToolkitProtosUtility.convert((LikelihoodStatistics)this.finalLikelihood)).addAllResiduals(Iterables.of((DoubleSeq)this.residuals));
            DoubleSeq diag = this.coefficientsCovariance.diagonal();
            int i = 0;
            int j = nx;
            while (i < this.outliers.length) {
                builder.addOutliers(OutliersProtos.Outlier.newBuilder().setCode(this.outliers[i].getCode()).setPosition(this.outliers[i].getPosition()).setCoefficient(this.coefficients[j]).setStde(Math.sqrt(diag.get(j))).build());
                ++i;
                ++j;
            }
            return builder.build().toByteArray();
        }

        public double[] tstats() {
            double[] t = (double[])this.coefficients.clone();
            if (t == null) {
                return null;
            }
            DoubleSeqCursor v = this.coefficientsCovariance.diagonal().cursor();
            int i = 0;
            while (i < t.length) {
                int n = i++;
                t[n] = t[n] / Math.sqrt(v.getAndNext());
            }
            return t;
        }

        public int getNx() {
            return this.coefficients == null ? 0 : this.coefficients.length;
        }

        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        public <T> T getData(String id, Class<T> tclass) {
            return (T)MAPPING.getData((Object)this, id, tclass);
        }

        @Generated
        Results(SarimaModel initialArima, SarimaModel finalArima, TsData y, Matrix x, OutlierDescriptor[] outliers, double[] coefficients, Matrix coefficientsCovariance, Matrix regressors, DoubleSeq linearized, DoubleSeq residuals, LikelihoodStatistics initialLikelihood, LikelihoodStatistics finalLikelihood) {
            this.initialArima = initialArima;
            this.finalArima = finalArima;
            this.y = y;
            this.x = x;
            this.outliers = outliers;
            this.coefficients = coefficients;
            this.coefficientsCovariance = coefficientsCovariance;
            this.regressors = regressors;
            this.linearized = linearized;
            this.residuals = residuals;
            this.initialLikelihood = initialLikelihood;
            this.finalLikelihood = finalLikelihood;
        }

        @Generated
        public static @NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public SarimaModel getInitialArima() {
            return this.initialArima;
        }

        @Generated
        public SarimaModel getFinalArima() {
            return this.finalArima;
        }

        @Generated
        public TsData getY() {
            return this.y;
        }

        @Generated
        public Matrix getX() {
            return this.x;
        }

        @Generated
        public OutlierDescriptor[] getOutliers() {
            return this.outliers;
        }

        @Generated
        public double[] getCoefficients() {
            return this.coefficients;
        }

        @Generated
        public Matrix getCoefficientsCovariance() {
            return this.coefficientsCovariance;
        }

        @Generated
        public Matrix getRegressors() {
            return this.regressors;
        }

        @Generated
        public DoubleSeq getLinearized() {
            return this.linearized;
        }

        @Generated
        public DoubleSeq getResiduals() {
            return this.residuals;
        }

        @Generated
        public LikelihoodStatistics getInitialLikelihood() {
            return this.initialLikelihood;
        }

        @Generated
        public LikelihoodStatistics getFinalLikelihood() {
            return this.finalLikelihood;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            SarimaModel this$initialArima = this.getInitialArima();
            SarimaModel other$initialArima = other.getInitialArima();
            if (this$initialArima == null ? other$initialArima != null : !this$initialArima.equals(other$initialArima)) {
                return false;
            }
            SarimaModel this$finalArima = this.getFinalArima();
            SarimaModel other$finalArima = other.getFinalArima();
            if (this$finalArima == null ? other$finalArima != null : !this$finalArima.equals(other$finalArima)) {
                return false;
            }
            TsData this$y = this.getY();
            TsData other$y = other.getY();
            if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
                return false;
            }
            Matrix this$x = this.getX();
            Matrix other$x = other.getX();
            if (this$x == null ? other$x != null : !this$x.equals(other$x)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getOutliers(), other.getOutliers())) {
                return false;
            }
            if (!Arrays.equals(this.getCoefficients(), other.getCoefficients())) {
                return false;
            }
            Matrix this$coefficientsCovariance = this.getCoefficientsCovariance();
            Matrix other$coefficientsCovariance = other.getCoefficientsCovariance();
            if (this$coefficientsCovariance == null ? other$coefficientsCovariance != null : !this$coefficientsCovariance.equals(other$coefficientsCovariance)) {
                return false;
            }
            Matrix this$regressors = this.getRegressors();
            Matrix other$regressors = other.getRegressors();
            if (this$regressors == null ? other$regressors != null : !this$regressors.equals(other$regressors)) {
                return false;
            }
            DoubleSeq this$linearized = this.getLinearized();
            DoubleSeq other$linearized = other.getLinearized();
            if (this$linearized == null ? other$linearized != null : !this$linearized.equals(other$linearized)) {
                return false;
            }
            DoubleSeq this$residuals = this.getResiduals();
            DoubleSeq other$residuals = other.getResiduals();
            if (this$residuals == null ? other$residuals != null : !this$residuals.equals(other$residuals)) {
                return false;
            }
            LikelihoodStatistics this$initialLikelihood = this.getInitialLikelihood();
            LikelihoodStatistics other$initialLikelihood = other.getInitialLikelihood();
            if (this$initialLikelihood == null ? other$initialLikelihood != null : !this$initialLikelihood.equals(other$initialLikelihood)) {
                return false;
            }
            LikelihoodStatistics this$finalLikelihood = this.getFinalLikelihood();
            LikelihoodStatistics other$finalLikelihood = other.getFinalLikelihood();
            return !(this$finalLikelihood == null ? other$finalLikelihood != null : !this$finalLikelihood.equals(other$finalLikelihood));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SarimaModel $initialArima = this.getInitialArima();
            result = result * 59 + ($initialArima == null ? 43 : $initialArima.hashCode());
            SarimaModel $finalArima = this.getFinalArima();
            result = result * 59 + ($finalArima == null ? 43 : $finalArima.hashCode());
            TsData $y = this.getY();
            result = result * 59 + ($y == null ? 43 : $y.hashCode());
            Matrix $x = this.getX();
            result = result * 59 + ($x == null ? 43 : $x.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getOutliers());
            result = result * 59 + Arrays.hashCode(this.getCoefficients());
            Matrix $coefficientsCovariance = this.getCoefficientsCovariance();
            result = result * 59 + ($coefficientsCovariance == null ? 43 : $coefficientsCovariance.hashCode());
            Matrix $regressors = this.getRegressors();
            result = result * 59 + ($regressors == null ? 43 : $regressors.hashCode());
            DoubleSeq $linearized = this.getLinearized();
            result = result * 59 + ($linearized == null ? 43 : $linearized.hashCode());
            DoubleSeq $residuals = this.getResiduals();
            result = result * 59 + ($residuals == null ? 43 : $residuals.hashCode());
            LikelihoodStatistics $initialLikelihood = this.getInitialLikelihood();
            result = result * 59 + ($initialLikelihood == null ? 43 : $initialLikelihood.hashCode());
            LikelihoodStatistics $finalLikelihood = this.getFinalLikelihood();
            result = result * 59 + ($finalLikelihood == null ? 43 : $finalLikelihood.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "TramoOutliersDetection.Results(initialArima=" + String.valueOf(this.getInitialArima()) + ", finalArima=" + String.valueOf(this.getFinalArima()) + ", y=" + String.valueOf(this.getY()) + ", x=" + String.valueOf(this.getX()) + ", outliers=" + Arrays.deepToString(this.getOutliers()) + ", coefficients=" + Arrays.toString(this.getCoefficients()) + ", coefficientsCovariance=" + String.valueOf(this.getCoefficientsCovariance()) + ", regressors=" + String.valueOf(this.getRegressors()) + ", linearized=" + String.valueOf(this.getLinearized()) + ", residuals=" + String.valueOf(this.getResiduals()) + ", initialLikelihood=" + String.valueOf(this.getInitialLikelihood()) + ", finalLikelihood=" + String.valueOf(this.getFinalLikelihood()) + ")";
        }

        static {
            MAPPING.delegate(ARIMA0, SarimaModel.class, r -> r.getInitialArima());
            MAPPING.delegate(ARIMA1, SarimaModel.class, r -> r.getFinalArima());
            MAPPING.delegate(LL0, LikelihoodStatistics.class, r -> r.getInitialLikelihood());
            MAPPING.delegate(LL1, LikelihoodStatistics.class, r -> r.getFinalLikelihood());
            MAPPING.set(B, double[].class, source -> source.getCoefficients());
            MAPPING.set(T, double[].class, source -> source.tstats());
            MAPPING.set(BVAR, Matrix.class, source -> source.getCoefficientsCovariance());
            MAPPING.set(BNAMES, String[].class, source -> {
                int i;
                int nx = source.getNx();
                if (nx == 0) {
                    return null;
                }
                String[] names = new String[nx];
                OutlierDescriptor[] outliers = source.getOutliers();
                int no = outliers == null ? 0 : outliers.length;
                for (i = 0; i < nx - no; ++i) {
                    names[i] = "x-" + (i + 1);
                }
                i = nx - no;
                int j = 0;
                while (i < nx) {
                    names[i] = outliers[j].toString();
                    ++i;
                    ++j;
                }
                return names;
            });
            MAPPING.set(OUTLIERS, String[].class, source -> {
                OutlierDescriptor[] outliers = source.getOutliers();
                int no = outliers == null ? 0 : outliers.length;
                String[] names = new String[no];
                for (int i = 0; i < no; ++i) {
                    names[i] = outliers[i].toString();
                }
                return names;
            });
            MAPPING.set(Y, TsData.class, source -> source.getY());
            MAPPING.set(REGRESSORS, Matrix.class, source -> source.getRegressors());
            MAPPING.set(LIN, double[].class, source -> source.getLinearized().toArray());
        }

        @Generated
        public static class Builder {
            @Generated
            private SarimaModel initialArima;
            @Generated
            private SarimaModel finalArima;
            @Generated
            private TsData y;
            @Generated
            private Matrix x;
            @Generated
            private OutlierDescriptor[] outliers;
            @Generated
            private double[] coefficients;
            @Generated
            private Matrix coefficientsCovariance;
            @Generated
            private Matrix regressors;
            @Generated
            private DoubleSeq linearized;
            @Generated
            private DoubleSeq residuals;
            @Generated
            private LikelihoodStatistics initialLikelihood;
            @Generated
            private LikelihoodStatistics finalLikelihood;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder initialArima(SarimaModel initialArima) {
                this.initialArima = initialArima;
                return this;
            }

            @Generated
            public @NonNull Builder finalArima(SarimaModel finalArima) {
                this.finalArima = finalArima;
                return this;
            }

            @Generated
            public @NonNull Builder y(TsData y) {
                this.y = y;
                return this;
            }

            @Generated
            public @NonNull Builder x(Matrix x) {
                this.x = x;
                return this;
            }

            @Generated
            public @NonNull Builder outliers(OutlierDescriptor[] outliers) {
                this.outliers = outliers;
                return this;
            }

            @Generated
            public @NonNull Builder coefficients(double[] coefficients) {
                this.coefficients = coefficients;
                return this;
            }

            @Generated
            public @NonNull Builder coefficientsCovariance(Matrix coefficientsCovariance) {
                this.coefficientsCovariance = coefficientsCovariance;
                return this;
            }

            @Generated
            public @NonNull Builder regressors(Matrix regressors) {
                this.regressors = regressors;
                return this;
            }

            @Generated
            public @NonNull Builder linearized(DoubleSeq linearized) {
                this.linearized = linearized;
                return this;
            }

            @Generated
            public @NonNull Builder residuals(DoubleSeq residuals) {
                this.residuals = residuals;
                return this;
            }

            @Generated
            public @NonNull Builder initialLikelihood(LikelihoodStatistics initialLikelihood) {
                this.initialLikelihood = initialLikelihood;
                return this;
            }

            @Generated
            public @NonNull Builder finalLikelihood(LikelihoodStatistics finalLikelihood) {
                this.finalLikelihood = finalLikelihood;
                return this;
            }

            @Generated
            public @NonNull Results build() {
                return new Results(this.initialArima, this.finalArima, this.y, this.x, this.outliers, this.coefficients, this.coefficientsCovariance, this.regressors, this.linearized, this.residuals, this.initialLikelihood, this.finalLikelihood);
            }

            @Generated
            public @NonNull String toString() {
                return "TramoOutliersDetection.Results.Builder(initialArima=" + String.valueOf(this.initialArima) + ", finalArima=" + String.valueOf(this.finalArima) + ", y=" + String.valueOf(this.y) + ", x=" + String.valueOf(this.x) + ", outliers=" + Arrays.deepToString(this.outliers) + ", coefficients=" + Arrays.toString(this.coefficients) + ", coefficientsCovariance=" + String.valueOf(this.coefficientsCovariance) + ", regressors=" + String.valueOf(this.regressors) + ", linearized=" + String.valueOf(this.linearized) + ", residuals=" + String.valueOf(this.residuals) + ", initialLikelihood=" + String.valueOf(this.initialLikelihood) + ", finalLikelihood=" + String.valueOf(this.finalLikelihood) + ")";
            }
        }
    }
}

