/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.knowledge;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.knowledge.AbstractKnowledgeParser;
import org.vikamine.kernel.util.Group;
import org.vikamine.kernel.util.GroupReader;

public class AttributeGroupParser
extends AbstractKnowledgeParser {
    private static final String NAME = "AttributeGroupParser";
    private static final String START_LINE = "Attribute Groups:";

    @Override
    public void handleFile(File f, Reader fileContent, Ontology onto) {
        BufferedReader bufReader = new BufferedReader(fileContent);
        boolean firstLine = true;
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                if (firstLine && !line.startsWith("#")) {
                    firstLine = false;
                    if (!line.startsWith(START_LINE)) {
                        return;
                    }
                }
                List<RDFStatement> newStatements = this.createStatements(onto, bufReader, f);
                onto.getTripleStore().addStatements(newStatements);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<RDFStatement> createStatements(Ontology onto, BufferedReader bufReader, File f) {
        ArrayList<RDFStatement> statements = new ArrayList<RDFStatement>();
        GroupReader gr = new GroupReader(bufReader);
        for (Group<String> rootGroup : gr.getRootGroups()) {
            String rootGroupName = rootGroup.getId();
            statements.add(new RDFStatement<Ontology, String>(onto, OntologyConstants.HAS_ATTRIBUTE_GROUP, rootGroupName, f.getPath()));
            for (String s : rootGroup.getElements()) {
                Attribute att = onto.getAttribute(s);
                if (att == null) continue;
                statements.add(new RDFStatement<Attribute, String>(att, OntologyConstants.IN_ATTRIBUTE_GROUP, rootGroupName, f.getPath()));
            }
        }
        return statements;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

