/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis;

import java.util.Iterator;
import java.util.LinkedList;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.subgroup.SG;

public class SGSimilarityCalculator {
    private static boolean equalTargets(SG s1, SG s2) {
        return s1.getTarget() == null && s2.getTarget() == null || s1.getTarget() != null && s2.getTarget() != null && s1.getTarget().equals(s2.getTarget());
    }

    public static double calculateSimilarity(SG s1, SG s2) {
        if (s1 == null || s2 == null) {
            return Double.NaN;
        }
        if (s1 == s2) {
            return 1.0;
        }
        int intersection = 0;
        int union = 0;
        if (!SGSimilarityCalculator.equalTargets(s1, s2)) {
            return 0.0;
        }
        Iterator<DataRecord> iter = s1.getPopulation().instanceIterator();
        while (iter.hasNext()) {
            DataRecord i = iter.next();
            boolean b1 = s1.getSGDescription().isMatching(i);
            boolean b2 = s2.getSGDescription().isMatching(i);
            if (b1 || b2) {
                ++union;
            }
            if (!b1 || !b2) continue;
            ++intersection;
        }
        if (union == 0) {
            return 0.0;
        }
        return (double)intersection / (double)union;
    }

    public static double calculateSimilarity(SGInstanceData data1, SGInstanceData data2) {
        if (!SGSimilarityCalculator.equalTargets(data1.getSG(), data2.getSG())) {
            return 0.0;
        }
        int intersection = 0;
        boolean useFirst = data1.instanceIndices.length < data2.instanceIndices.length;
        int[] indices = useFirst ? data1.instanceIndices : data2.instanceIndices;
        boolean[] contained = useFirst ? data2.contained : data1.contained;
        int i = 0;
        while (i < indices.length) {
            boolean inOther = contained[indices[i]];
            if (inOther) {
                ++intersection;
            }
            ++i;
        }
        int union = data1.instanceIndices.length + data2.instanceIndices.length - intersection;
        if (union == 0) {
            return 0.0;
        }
        return (double)intersection / (double)union;
    }

    public static SGInstanceData createSGInstanceData(SG sg, DataView popu) {
        SGInstanceData data = new SGInstanceData(sg);
        data.contained = new boolean[popu.size()];
        LinkedList<Integer> sgInstIndices = new LinkedList<Integer>();
        int instIndex = 0;
        Iterator<DataRecord> iter = popu.instanceIterator();
        while (iter.hasNext()) {
            boolean inSG;
            DataRecord inst = iter.next();
            data.contained[instIndex] = inSG = sg.getSGDescription().isMatching(inst);
            if (inSG) {
                sgInstIndices.add(instIndex);
            }
            ++instIndex;
        }
        data.instanceIndices = new int[sgInstIndices.size()];
        int i = 0;
        for (Integer instanceIndex : sgInstIndices) {
            data.instanceIndices[i] = instanceIndex;
            ++i;
        }
        return data;
    }

    public static class SGInstanceData {
        private SG referenceSG;
        boolean[] contained;
        int[] instanceIndices;

        protected SGInstanceData() {
        }

        public SGInstanceData(SG sg) {
            this.referenceSG = sg;
        }

        public SG getSG() {
            return this.referenceSG;
        }
    }
}

