/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.ISystem;
import net.sf.jclec.base.DecoratedRecombinator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatRecombinator<I extends IIndividual>
extends DecoratedRecombinator<I> {
    private static final long serialVersionUID = 7926409688402274090L;
    protected int numberOfRepetitions;

    public RepeatRecombinator() {
    }

    public RepeatRecombinator(ISystem<I> system) {
        super(system);
    }

    public final int getNumberOfRepetitions() {
        return this.numberOfRepetitions;
    }

    public final void setNumberOfRepetitions(int numberOfRepetitions) {
        this.numberOfRepetitions = numberOfRepetitions;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        int numberOfRepetitions = settings.getInt("number-of-repetitions");
        this.setNumberOfRepetitions(numberOfRepetitions);
    }

    @Override
    public List<I> recombine(List<I> parents) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.numberOfRepetitions) {
            result.addAll(this.decorated.recombine(parents));
            ++i;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof RepeatRecombinator) {
            RepeatRecombinator o = (RepeatRecombinator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.decorated, o.decorated);
            eb.append(this.numberOfRepetitions, o.numberOfRepetitions);
            return eb.isEquals();
        }
        return false;
    }
}

