/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Hyperrectangles.BNGE;

import keel.Dataset.Attribute;

public class Rule {
    private static int size;
    private static boolean[] isNominal;
    private static int[] nValues;
    private double[] valueMin = new double[size];
    private double[] valueMax = new double[size];
    private boolean[][] valueNom = new boolean[size][];
    private double area;
    private int output;

    public static void setSize(int value) {
        size = value;
        nValues = new int[size];
    }

    public static void setAttributes(Attribute[] inputs) {
        isNominal = new boolean[size];
        for (int i = 0; i < size; ++i) {
            Rule.isNominal[i] = inputs[i].getType() == 0;
        }
    }

    public static void setNumValue(int value, int pos) {
        Rule.nValues[pos] = value;
    }

    public Rule() {
        for (int i = 0; i < size; ++i) {
            this.valueNom[i] = new boolean[nValues[i]];
            for (int j = 0; j < nValues[i]; ++j) {
                this.valueNom[i][j] = false;
            }
        }
        this.output = -1;
        this.area = 0.0;
    }

    public Rule(double[] instance, int out) {
        int i;
        for (i = 0; i < size; ++i) {
            this.valueNom[i] = new boolean[nValues[i]];
            for (int j = 0; j < nValues[i]; ++j) {
                this.valueNom[i][j] = false;
            }
        }
        for (i = 0; i < size; ++i) {
            if (isNominal[i]) {
                int nomRep = (int)(instance[i] * (double)(nValues[i] - 1));
                this.valueNom[i][nomRep] = true;
                continue;
            }
            this.valueMax[i] = instance[i];
            this.valueMin[i] = instance[i];
        }
        this.output = out;
        this.computeArea();
    }

    public void loadRule(double[] instance, int out) {
        for (int i = 0; i < size; ++i) {
            if (isNominal[i]) {
                int nomRep = (int)(instance[i] * (double)(nValues[i] - 1));
                this.valueNom[i][nomRep] = true;
                continue;
            }
            this.valueMax[i] = instance[i];
            this.valueMin[i] = instance[i];
        }
        this.output = out;
        this.computeArea();
    }

    private void computeArea() {
        this.area = 0.0;
        for (int i = 0; i < size; ++i) {
            if (isNominal[i]) {
                int count = 0;
                for (int j = 0; j < this.valueNom[i].length; ++j) {
                    if (!this.valueNom[i][j]) continue;
                    ++count;
                }
                this.area += (double)count / (double)this.valueNom[i].length;
                continue;
            }
            this.area += this.valueMax[i] - this.valueMin[i];
        }
    }

    public Rule clone() {
        Rule clon = new Rule();
        for (int i = 0; i < size; ++i) {
            if (isNominal[i]) {
                System.arraycopy(this.valueNom[i], 0, clon.valueNom[i], 0, nValues[i]);
                continue;
            }
            clon.valueMax[i] = this.valueMax[i];
            clon.valueMin[i] = this.valueMin[i];
        }
        clon.output = this.output;
        clon.area = this.area;
        return clon;
    }

    public boolean equals(Object rul) {
        Rule another = (Rule)rul;
        boolean isEqual = true;
        if (this.output != another.output) {
            isEqual = false;
        }
        if (this.area != another.area) {
            isEqual = false;
        }
        for (int i = 0; i < size && isEqual; ++i) {
            if (isNominal[i]) {
                for (int j = 0; j < nValues[i] && isEqual; ++j) {
                    if (this.valueNom[i][j] == another.valueNom[i][j]) continue;
                    isEqual = false;
                }
                continue;
            }
            if (this.valueMin[i] != another.valueMin[i]) {
                isEqual = false;
            }
            if (this.valueMax[i] == another.valueMax[i]) continue;
            isEqual = false;
        }
        return isEqual;
    }

    public String toString() {
        String text = "";
        for (int i = 0; i < size; ++i) {
            text = text + "Att" + i + ": ";
            if (isNominal[i]) {
                for (int j = 0; j < nValues[i]; ++j) {
                    text = text + j + ",";
                }
                continue;
            }
            text = text + this.valueMin[i] + "-";
            text = text + this.valueMax[i] + " ";
        }
        text = text + "Output= " + this.output;
        text = text + " Area: " + this.area;
        return text;
    }

    public int getOutput() {
        return this.output;
    }

    public double getArea() {
        return this.area;
    }

    public double distance(double[] instance) {
        double dist = 0.0;
        for (int i = 0; i < size; ++i) {
            double inc;
            if (isNominal[i]) {
                int nomRep = (int)(instance[i] * (double)(nValues[i] - 1));
                if (this.valueNom[i][nomRep]) continue;
                dist += 1.0;
                continue;
            }
            if (instance[i] < this.valueMin[i]) {
                inc = this.valueMin[i] - instance[i];
                dist += inc * inc;
            }
            if (!(instance[i] > this.valueMax[i])) continue;
            inc = instance[i] - this.valueMax[i];
            dist += inc * inc;
        }
        return dist;
    }

    public double distanceRule(Rule another) {
        double dist = 0.0;
        for (int i = 0; i < size; ++i) {
            double inc;
            if (isNominal[i]) {
                int count = 0;
                for (int j = 0; j < nValues[i]; ++j) {
                    if (this.valueNom[i][j] == another.valueNom[i][j]) continue;
                    ++count;
                }
                inc = (double)count / (double)nValues[i];
            } else {
                double a = (this.valueMax[i] - this.valueMin[i]) / 2.0;
                double b = (another.valueMax[i] - another.valueMin[i]) / 2.0;
                inc = a > b ? a - b : b - a;
            }
            dist += inc * inc;
        }
        return dist;
    }

    public boolean overlap(Rule another) {
        boolean over = true;
        for (int i = 0; i < size && over; ++i) {
            boolean test;
            if (isNominal[i]) {
                test = false;
                for (int j = 0; j < nValues[i] && !test; ++j) {
                    if (!this.valueNom[i][j] || !another.valueNom[i][j]) continue;
                    test = true;
                }
                if (test) continue;
                over = false;
                continue;
            }
            test = false;
            if (another.valueMax[i] >= this.valueMin[i] && another.valueMax[i] <= this.valueMax[i]) {
                test = true;
            } else if (this.valueMax[i] >= another.valueMin[i] && this.valueMax[i] <= another.valueMax[i]) {
                test = true;
            }
            if (test) continue;
            over = false;
        }
        return over;
    }

    public void merge(Rule another) {
        for (int i = 0; i < size; ++i) {
            if (isNominal[i]) {
                for (int j = 0; j < nValues[i]; ++j) {
                    if (!another.valueNom[i][j]) continue;
                    this.valueNom[i][j] = true;
                }
                continue;
            }
            if (another.valueMin[i] < this.valueMin[i]) {
                this.valueMin[i] = another.valueMin[i];
            }
            if (!(another.valueMax[i] > this.valueMax[i])) continue;
            this.valueMax[i] = another.valueMax[i];
        }
        this.computeArea();
    }
}

