/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA;

import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Apriori;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.RuleBase;
import org.core.Randomize;

public class Individual
implements Comparable {
    int[] chromosome;
    double fitness;
    double accuracy;
    int lengthSC;
    int n_e;
    double wCAR;
    double wV;

    public Individual() {
    }

    public Individual(int[] chromosome, double wCAR, double wV, int lengthSC) {
        this.wCAR = wCAR;
        this.wV = wV;
        this.lengthSC = lengthSC;
        this.n_e = 1;
        this.chromosome = new int[this.lengthSC * 2];
        for (int i = 0; i < this.chromosome.length; ++i) {
            this.chromosome[i] = chromosome[i];
        }
    }

    public Individual(double wCAR, double wV, int lengthSC) {
        this.wCAR = wCAR;
        this.wV = wV;
        this.lengthSC = lengthSC;
        this.n_e = 1;
        this.chromosome = new int[this.lengthSC * 2];
    }

    public void randomValues() {
        for (int i = 0; i < this.chromosome.length; ++i) {
            this.chromosome[i] = Randomize.Rand() < 0.5 ? 0 : 1;
        }
        this.n_e = 1;
    }

    public void interchangeValues(Individual indiv, int pointCross1, int pointCross2) {
        for (int i = pointCross1; i <= pointCross2; ++i) {
            int aux = this.chromosome[i];
            this.chromosome[i] = indiv.chromosome[i];
            indiv.chromosome[i] = aux;
        }
        this.n_e = 1;
        indiv.n_e = 1;
    }

    public int size() {
        return this.chromosome.length;
    }

    public void mutation(double prob) {
        for (int i = 0; i < this.chromosome.length; ++i) {
            if (!(Randomize.Rand() < prob)) continue;
            this.chromosome[i] = this.chromosome[i] == 0 ? 1 : 0;
            this.n_e = 1;
        }
    }

    public Individual clone() {
        Individual i = new Individual();
        i.lengthSC = this.lengthSC;
        i.fitness = this.fitness;
        i.accuracy = this.accuracy;
        i.wCAR = this.wCAR;
        i.wV = this.wV;
        i.n_e = this.n_e;
        i.chromosome = new int[this.chromosome.length];
        for (int j = 0; j < this.chromosome.length; ++j) {
            i.chromosome[j] = this.chromosome[j];
        }
        return i;
    }

    public boolean isNew() {
        return this.n_e == 1;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getFitness() {
        return this.fitness;
    }

    public double getMinFS() {
        double minFS = 0.0;
        int i = 0;
        for (int j = this.lengthSC - 1; j >= 0; --j) {
            if (this.chromosome[i] > 0) {
                minFS += Math.pow(2.0, j);
            }
            ++i;
        }
        return minFS /= Math.pow(2.0, this.lengthSC);
    }

    public double getMinFC() {
        double minFC = 0.0;
        int i = this.lengthSC;
        for (int j = this.lengthSC - 1; j >= 0; --j) {
            if (this.chromosome[i] > 0) {
                minFC += Math.pow(2.0, j);
            }
            ++i;
        }
        return minFC /= Math.pow(2.0, this.lengthSC);
    }

    public RuleBase generateRB(Apriori apriori, double n1, double n2, int Jmax) {
        double minFS = this.getMinFS();
        double minFC = this.getMinFC();
        RuleBase ruleBase = apriori.generateRB(minFS, minFC);
        ruleBase.adaptiveRules(n1, n2, Jmax);
        return ruleBase;
    }

    public void evaluate(Apriori apriori, double n1, double n2, int Jmax) {
        RuleBase ruleBase = this.generateRB(apriori, n1, n2, Jmax);
        if (ruleBase.size() < 1) {
            this.fitness = Double.NEGATIVE_INFINITY;
            this.accuracy = 0.0;
        } else {
            this.accuracy = ruleBase.evaluate();
            this.fitness = this.wCAR * ruleBase.getAccuracy() - this.wV * (double)ruleBase.size();
        }
        this.n_e = 0;
    }

    public int compareTo(Object a) {
        if (((Individual)a).fitness < this.fitness) {
            return -1;
        }
        if (((Individual)a).fitness > this.fitness) {
            return 1;
        }
        return 0;
    }
}

