/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javolution.lang.Reflection;
import javolution.xml.sax.Attributes;
import javolution.xml.sax.ContentHandler;
import javolution.xml.sax.XmlSaxParserImpl;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class XMLReaderImpl
implements XMLReader {
    private static Sax2DefaultHandler DEFAULT_HANDLER = new Sax2DefaultHandler();
    private final XmlSaxParserImpl _parser = new XmlSaxParserImpl();
    private static final Reflection.Constructor NEW_URL = Reflection.getConstructor("java.net.URL(java.lang.String)");
    private static final Reflection.Method OPEN_STREAM = Reflection.getMethod("java.net.URL.openStream()");
    private static final Reflection.Constructor NEW_FILE_INPUT_STREAM = Reflection.getConstructor("java.io.FileInputStream(java.lang.String)");

    public XMLReaderImpl() {
        Proxy proxy = new Proxy();
        this._parser.setContentHandler(proxy);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._parser.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._parser.setFeature(string, bl);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._parser.getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._parser.setProperty(string, object);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._parser.setEntityResolver(entityResolver);
    }

    public EntityResolver getEntityResolver() {
        return this._parser.getEntityResolver();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this._parser.setDTDHandler(dTDHandler);
    }

    public DTDHandler getDTDHandler() {
        return this._parser.getDTDHandler();
    }

    public void setContentHandler(org.xml.sax.ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException();
        }
        Proxy proxy = (Proxy)this._parser.getContentHandler();
        proxy._sax2Handler = contentHandler;
    }

    public org.xml.sax.ContentHandler getContentHandler() {
        Proxy proxy = (Proxy)this._parser.getContentHandler();
        return proxy._sax2Handler == DEFAULT_HANDLER ? null : proxy._sax2Handler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._parser.setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this._parser.getErrorHandler();
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            this._parser.parse(reader);
        } else {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                String string = inputSource.getEncoding();
                if (string == null || string.equals("UTF-8") || string.equals("utf-8")) {
                    this._parser.parse(inputStream);
                } else {
                    reader = new InputStreamReader(inputStream, string);
                    this._parser.parse(reader);
                }
            } else {
                this.parse(inputSource.getSystemId());
            }
        }
    }

    public void parse(String string) throws IOException, SAXException {
        InputStream inputStream;
        try {
            Object object = NEW_URL.newInstance(string);
            inputStream = (InputStream)OPEN_STREAM.invoke(object);
        }
        catch (Exception exception) {
            try {
                inputStream = (InputStream)NEW_FILE_INPUT_STREAM.newInstance(string);
            }
            catch (Exception exception2) {
                throw new UnsupportedOperationException("Cannot parse " + string);
            }
        }
        this._parser.parse(inputStream);
    }

    static /* synthetic */ Sax2DefaultHandler access$200() {
        return DEFAULT_HANDLER;
    }

    private static final class Sax2DefaultHandler
    implements EntityResolver,
    DTDHandler,
    org.xml.sax.ContentHandler,
    ErrorHandler {
        private Sax2DefaultHandler() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return null;
        }

        public void notationDecl(String string, String string2, String string3) throws SAXException {
        }

        public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private static final class Proxy
    implements ContentHandler,
    org.xml.sax.Attributes {
        private org.xml.sax.ContentHandler _sax2Handler = XMLReaderImpl.access$200();
        private Attributes _attributes;

        public void setDocumentLocator(Locator locator) {
            this._sax2Handler.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            this._sax2Handler.startDocument();
        }

        public void endDocument() throws SAXException {
            this._sax2Handler.endDocument();
        }

        public void startPrefixMapping(CharSequence charSequence, CharSequence charSequence2) throws SAXException {
            this._sax2Handler.startPrefixMapping(((Object)charSequence).toString(), ((Object)charSequence2).toString());
        }

        public void endPrefixMapping(CharSequence charSequence) throws SAXException {
            this._sax2Handler.endPrefixMapping(((Object)charSequence).toString());
        }

        public void startElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, Attributes attributes) throws SAXException {
            this._attributes = attributes;
            this._sax2Handler.startElement(((Object)charSequence).toString(), ((Object)charSequence2).toString(), ((Object)charSequence3).toString(), this);
        }

        public void endElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws SAXException {
            this._sax2Handler.endElement(((Object)charSequence).toString(), ((Object)charSequence2).toString(), ((Object)charSequence3).toString());
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this._sax2Handler.characters(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this._sax2Handler.ignorableWhitespace(cArray, n, n2);
        }

        public void processingInstruction(CharSequence charSequence, CharSequence charSequence2) throws SAXException {
            this._sax2Handler.processingInstruction(((Object)charSequence).toString(), ((Object)charSequence2).toString());
        }

        public void skippedEntity(CharSequence charSequence) throws SAXException {
            this._sax2Handler.skippedEntity(((Object)charSequence).toString());
        }

        public int getLength() {
            return this._attributes.getLength();
        }

        public String getURI(int n) {
            CharSequence charSequence = this._attributes.getURI(n);
            return charSequence != null ? ((Object)charSequence).toString() : null;
        }

        public String getLocalName(int n) {
            CharSequence charSequence = this._attributes.getLocalName(n);
            return charSequence != null ? ((Object)charSequence).toString() : null;
        }

        public String getQName(int n) {
            CharSequence charSequence = this._attributes.getQName(n);
            return charSequence != null ? ((Object)charSequence).toString() : null;
        }

        public String getType(int n) {
            return this._attributes.getType(n);
        }

        public String getValue(int n) {
            CharSequence charSequence = this._attributes.getValue(n);
            return charSequence != null ? ((Object)charSequence).toString() : null;
        }

        public int getIndex(String string, String string2) {
            return this._attributes.getIndex(string, string2);
        }

        public int getIndex(String string) {
            return this._attributes.getIndex(string);
        }

        public String getType(String string, String string2) {
            return this._attributes.getType(string, string2);
        }

        public String getType(String string) {
            return this._attributes.getType(string);
        }

        public String getValue(String string, String string2) {
            return ((Object)this._attributes.getValue(string, string2)).toString();
        }

        public String getValue(String string) {
            return ((Object)this._attributes.getValue(string)).toString();
        }
    }
}

