/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm;

import java.util.List;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IEvaluator;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IPopulation;
import net.sf.jclec.IProvider;
import net.sf.jclec.ISpecies;
import net.sf.jclec.algorithm.AbstractAlgorithm;
import net.sf.jclec.util.random.IRandGen;
import net.sf.jclec.util.random.IRandGenFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PopulationAlgorithm<I extends IIndividual>
extends AbstractAlgorithm<I>
implements IPopulation<I>,
IConfigure {
    protected IRandGenFactory randGenFactory;
    protected ISpecies<I> species;
    protected IEvaluator<I> evaluator;
    protected IProvider<I> provider;
    protected int populationSize;
    protected int maxOfGenerations;
    protected int generation;
    protected List<I> bset;
    protected transient List<I> pset;
    protected transient List<I> cset;
    protected transient List<I> rset;

    @Override
    public final ISpecies<I> getSpecies() {
        return this.species;
    }

    @Override
    public final IEvaluator<I> getEvaluator() {
        return this.evaluator;
    }

    @Override
    public final int getGeneration() {
        return this.generation;
    }

    @Override
    public List<I> getInhabitants() {
        return this.bset;
    }

    public void setSpecies(ISpecies<I> species) {
        this.species = species;
    }

    public void setEvaluator(IEvaluator<I> evaluator) {
        this.evaluator = evaluator;
    }

    public final void setGeneration(int generation) {
        this.generation = generation;
    }

    public final void setInhabitants(List<I> inhabitants) {
        this.bset = inhabitants;
    }

    public IRandGenFactory getRandGenFactory() {
        return this.randGenFactory;
    }

    public void setRandGenFactory(IRandGenFactory randGenFactory) {
        this.randGenFactory = randGenFactory;
    }

    public final IProvider<I> getProvider() {
        return this.provider;
    }

    public final void setProvider(IProvider<I> provider) {
        this.provider = provider;
        provider.contextualize(this);
    }

    public final int getPopulationSize() {
        return this.populationSize;
    }

    public final void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public final int getMaxOfGenerations() {
        return this.maxOfGenerations;
    }

    public final void setMaxOfGenerations(int maxOfGenerations) {
        this.maxOfGenerations = maxOfGenerations;
    }

    @Override
    public IRandGen createRandGen() {
        return this.randGenFactory.createRandGen();
    }

    @Override
    public void doInit() {
        this.finished = false;
        this.bset = this.provider.provide(this.populationSize);
        this.evaluator.evaluate(this.bset);
        this.doControl();
    }

    @Override
    public void doIterate() {
        ++this.generation;
        this.doSelection();
        this.doGeneration();
        this.doReplacement();
        this.doUpdate();
        this.doControl();
    }

    public void run() {
        this.doInit();
        while (!this.isFinished()) {
            this.doIterate();
        }
    }

    @Override
    public void configure(Configuration configuration) {
        try {
            String randGenFactoryClassname = configuration.getString("rand-gen-factory[@type]");
            Class<?> randGenFactoryClass = Class.forName(randGenFactoryClassname);
            IRandGenFactory randGenFactory = (IRandGenFactory)randGenFactoryClass.newInstance();
            if (randGenFactory instanceof IConfigure) {
                ((IConfigure)((Object)randGenFactory)).configure(configuration.subset("rand-gen-factory"));
            }
            this.setRandGenFactory(randGenFactory);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal random generators factory classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of random generators factory", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of random generators factory", e);
        }
        try {
            String speciesClassname = configuration.getString("species[@type]");
            Class<?> speciesClass = Class.forName(speciesClassname);
            ISpecies species = (ISpecies)speciesClass.newInstance();
            if (species instanceof IConfigure) {
                ((IConfigure)((Object)species)).configure(configuration.subset("species"));
            }
            this.setSpecies(species);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal species classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of species", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of species", e);
        }
        try {
            String evaluatorClassname = configuration.getString("evaluator[@type]");
            Class<?> evaluatorClass = Class.forName(evaluatorClassname);
            IEvaluator evaluator = (IEvaluator)evaluatorClass.newInstance();
            if (evaluator instanceof IConfigure) {
                ((IConfigure)((Object)evaluator)).configure(configuration.subset("evaluator"));
            }
            this.setEvaluator(evaluator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal evaluator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of evaluator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of evaluator", e);
        }
        int populationSize = configuration.getInt("population-size");
        this.setPopulationSize(populationSize);
        int maxOfGenerations = configuration.getInt("max-of-generations");
        this.setMaxOfGenerations(maxOfGenerations);
        try {
            String providerClassname = configuration.getString("provider[@type]");
            Class<?> providerClass = Class.forName(providerClassname);
            IProvider provider = (IProvider)providerClass.newInstance();
            if (provider instanceof IConfigure) {
                ((IConfigure)((Object)provider)).configure(configuration.subset("provider"));
            }
            this.setProvider(provider);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal provider classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of provider", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of provider", e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof PopulationAlgorithm) {
            PopulationAlgorithm cother = (PopulationAlgorithm)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.randGenFactory, cother.randGenFactory);
            eb.append(this.species, cother.species);
            eb.append(this.evaluator, cother.evaluator);
            eb.append(this.populationSize, cother.populationSize);
            eb.append(this.maxOfGenerations, cother.maxOfGenerations);
            eb.append(this.provider, cother.provider);
            return eb.isEquals();
        }
        return false;
    }

    protected abstract void doSelection();

    protected abstract void doGeneration();

    protected abstract void doReplacement();

    protected abstract void doUpdate();

    protected void doControl() {
        if (this.generation >= this.maxOfGenerations) {
            this.finished = true;
            return;
        }
        for (IIndividual individual : this.bset) {
            if (!individual.getFitness().isAcceptable()) continue;
            this.finished = true;
            return;
        }
    }
}

