/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.CART.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.AttributeType;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.CategoricalAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DatasetException;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IMetadata;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IntegerNumericalAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.KeelDataSet;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.RealNumericalAttribute;
import net.sf.jclec.util.intset.Interval;

public class DataSetManager {
    private static String header;
    private static IAttribute outputAttribute;

    public static String getHeader() {
        return header;
    }

    public static IAttribute getOutputAttribute() {
        return outputAttribute;
    }

    public static byte[] readSchema(String fileName) throws IOException, DatasetException {
        int i;
        KeelDataSet dataset = new KeelDataSet(fileName, new String[0]);
        dataset.open();
        File file = new File(fileName);
        ArrayList<String> inputIds = new ArrayList<String>();
        ArrayList<String> outputIds = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        StringTokenizer elementLine = new StringTokenizer(line);
        String element = elementLine.nextToken();
        while (!element.equalsIgnoreCase("@data")) {
            StringTokenizer commaTokenizer;
            if (element.equalsIgnoreCase("@inputs")) {
                while (elementLine.hasMoreTokens()) {
                    commaTokenizer = new StringTokenizer(elementLine.nextToken(), ",");
                    while (commaTokenizer.hasMoreTokens()) {
                        inputIds.add(commaTokenizer.nextToken());
                    }
                }
            } else if (element.equalsIgnoreCase("@outputs")) {
                while (elementLine.hasMoreTokens()) {
                    commaTokenizer = new StringTokenizer(elementLine.nextToken(), ",");
                    while (commaTokenizer.hasMoreTokens()) {
                        outputIds.add(commaTokenizer.nextToken());
                    }
                }
            }
            line = reader.readLine();
            while (line.startsWith("%") || line.equalsIgnoreCase("")) {
                line = reader.readLine();
            }
            elementLine = new StringTokenizer(line);
            element = elementLine.nextToken();
        }
        IMetadata metadata = dataset.getMetadata();
        byte[] schema = new byte[metadata.numberOfAttributes()];
        if (inputIds.isEmpty() || outputIds.isEmpty()) {
            for (i = 0; i < schema.length; ++i) {
                if (i != schema.length - 1) {
                    schema[i] = 1;
                    continue;
                }
                outputAttribute = metadata.getAttribute(i);
                schema[i] = 2;
            }
        } else {
            for (i = 0; i < schema.length; ++i) {
                if (inputIds.contains(metadata.getAttribute(i).getName())) {
                    schema[i] = 1;
                    continue;
                }
                if (outputIds.contains(metadata.getAttribute(i).getName())) {
                    outputAttribute = metadata.getAttribute(i);
                    schema[i] = 2;
                    continue;
                }
                schema[i] = -1;
            }
        }
        StringBuffer sheader = new StringBuffer();
        sheader.append("@relation " + dataset.getName() + "\n");
        for (int i2 = 0; i2 < metadata.numberOfAttributes(); ++i2) {
            IAttribute attribute = metadata.getAttribute(i2);
            sheader.append("@attribute " + attribute.getName() + " ");
            if (attribute.getType() == AttributeType.Categorical) {
                CategoricalAttribute catAtt = (CategoricalAttribute)attribute;
                Interval interval = catAtt.intervalValues();
                sheader.append("{");
                for (int j = (int)interval.getLeft(); j <= interval.size() + 1; ++j) {
                    sheader.append(catAtt.show(j) + (j != interval.size() + 1 ? "," : "}\n"));
                }
                continue;
            }
            if (attribute.getType() == AttributeType.IntegerNumerical) {
                IntegerNumericalAttribute intAtt = (IntegerNumericalAttribute)attribute;
                sheader.append("integer[" + (int)intAtt.intervalValues().getLeft() + "," + intAtt.intervalValues().getRight() + "]\n");
                continue;
            }
            if (attribute.getType() != AttributeType.DoubleNumerical) continue;
            RealNumericalAttribute doubleAtt = (RealNumericalAttribute)attribute;
            sheader.append("real[" + doubleAtt.intervalValues().getLeft() + "," + doubleAtt.intervalValues().getRight() + "]\n");
        }
        sheader.append("@data\n");
        header = sheader.toString();
        dataset.close();
        return schema;
    }
}

