/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.SSMALVQ3;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.LVQ.LVQ3;
import keel.Algorithms.Instance_Generation.SSMALVQ3.Cromosoma;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceSet;
import org.core.Fichero;
import org.core.Randomize;

public class SSMALVQ3
extends Metodo {
    private long semilla;
    private int tamPoblacion;
    private double nEval;
    private double pCross;
    private double pMut;
    private int kNeigh;
    public String Script;
    private PrototypeSet trainingDataSet;
    private PrototypeGenerator generador;
    private int Maxiter;
    private double alpha0;
    private double windowW;
    private double epsilon;
    protected int numberOfClass;
    protected int numberOfPrototypes;
    protected int numberOfStrategies;

    public SSMALVQ3(String ficheroScript) {
        super(ficheroScript);
    }

    public static PrototypeSet readPrototypeSet(String nameOfFile) {
        Attributes.clearAll();
        InstanceSet training = new InstanceSet();
        try {
            training.readSet(nameOfFile, true);
            training.setAttributesAsNonStatic();
            InstanceAttributes att = training.getAttributeDefinitions();
            Prototype.setAttributesTypes(att);
        }
        catch (Exception e) {
            System.err.println("readPrototypeSet has failed!");
            e.printStackTrace();
        }
        return new PrototypeSet(training);
    }

    public static Prototype _1nn(Prototype current, PrototypeSet dataSet) {
        Prototype nearestNeighbor = (Prototype)dataSet.get(0);
        int indexNN = 0;
        double minDist = Double.POSITIVE_INFINITY;
        int _size = dataSet.size();
        for (int i = 0; i < _size; ++i) {
            Prototype pi = (Prototype)dataSet.get(i);
            double currDist = Distance.euclideanDistance(pi, current);
            if (!(currDist > 0.0) || !(currDist < minDist)) continue;
            minDist = currDist;
            indexNN = i;
        }
        return (Prototype)dataSet.get(indexNN);
    }

    public double classficationAccuracy1NN(PrototypeSet training, PrototypeSet test) {
        int wellClassificated = 0;
        for (Prototype p : test) {
            Prototype nearestNeighbor = SSMALVQ3._1nn(p, training);
            if (p.getOutput(0) != nearestNeighbor.getOutput(0)) continue;
            ++wellClassificated;
        }
        return 100.0 * ((double)wellClassificated / (double)test.size());
    }

    public void ejecutar() {
        int j;
        double[][] dMatrix;
        int i;
        int nSel = 0;
        double ev = 0.0;
        double GAeffort = 0.0;
        double LSeffort = 0.0;
        double fAcierto = 0.0;
        double fReduccion = 0.0;
        int contAcierto = 0;
        int contReduccion = 0;
        long tiempo = System.currentTimeMillis();
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        boolean veryLarge = this.datosTrain.length > 9000;
        if (!veryLarge) {
            dMatrix = new double[this.datosTrain.length][this.datosTrain.length];
            for (i = 0; i < dMatrix.length; ++i) {
                for (j = i + 1; j < dMatrix[i].length; ++j) {
                    dMatrix[i][j] = KNN.distancia((double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (double[])this.datosTrain[j], (double[])this.realTrain[j], (int[])this.nominalTrain[j], (boolean[])this.nulosTrain[j], (boolean)this.distanceEu);
                }
            }
            for (i = 0; i < dMatrix.length; ++i) {
                dMatrix[i][i] = Double.POSITIVE_INFINITY;
            }
            for (i = 0; i < dMatrix.length; ++i) {
                for (j = i - 1; j >= 0; --j) {
                    dMatrix[i][j] = dMatrix[j][i];
                }
            }
        } else {
            dMatrix = null;
        }
        Randomize.setSeed(this.semilla);
        Object[] poblacion = new Cromosoma[this.tamPoblacion];
        for (i = 0; i < this.tamPoblacion; ++i) {
            poblacion[i] = new Cromosoma(this.kNeigh, this.datosTrain.length, dMatrix, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
        }
        for (i = 0; i < this.tamPoblacion; ++i) {
            poblacion[i].evaluacionCompleta(nClases, this.kNeigh, this.clasesTrain);
        }
        double umbralOpt = 0.0;
        while (ev < this.nEval) {
            int comp2;
            Arrays.sort(poblacion);
            contAcierto = fAcierto >= ((Cromosoma)poblacion[0]).getFitnessAc() * 100.0 / (double)this.datosTrain.length ? ++contAcierto : 0;
            fAcierto = ((Cromosoma)poblacion[0]).getFitnessAc() * 100.0 / (double)this.datosTrain.length;
            contReduccion = fReduccion >= (1.0 - (double)((Cromosoma)poblacion[0]).genesActivos() / (double)this.datosTrain.length) * 100.0 ? ++contReduccion : 0;
            fReduccion = (1.0 - (double)((Cromosoma)poblacion[0]).genesActivos() / (double)this.datosTrain.length) * 100.0;
            if (contReduccion >= 10 || contAcierto >= 10) {
                if (Randomize.Randint(0, 1) == 0) {
                    if (contAcierto >= 10) {
                        contAcierto = 0;
                        umbralOpt += 1.0;
                    } else {
                        contReduccion = 0;
                        umbralOpt -= 1.0;
                    }
                } else if (contReduccion >= 10) {
                    contReduccion = 0;
                    umbralOpt -= 1.0;
                } else {
                    contAcierto = 0;
                    umbralOpt += 1.0;
                }
            }
            int comp1 = Randomize.Randint(0, this.tamPoblacion - 1);
            while ((comp2 = Randomize.Randint(0, this.tamPoblacion - 1)) == comp1) {
            }
            int sel1 = ((Cromosoma)poblacion[comp1]).getFitness() > ((Cromosoma)poblacion[comp2]).getFitness() ? comp1 : comp2;
            comp1 = Randomize.Randint(0, this.tamPoblacion - 1);
            while ((comp2 = Randomize.Randint(0, this.tamPoblacion - 1)) == comp1) {
            }
            int sel2 = ((Cromosoma)poblacion[comp1]).getFitness() > ((Cromosoma)poblacion[comp2]).getFitness() ? comp1 : comp2;
            Cromosoma[] hijos = new Cromosoma[]{new Cromosoma(this.kNeigh, (Cromosoma)poblacion[sel1], (Cromosoma)poblacion[sel2], this.pCross, this.datosTrain.length), new Cromosoma(this.kNeigh, (Cromosoma)poblacion[sel2], (Cromosoma)poblacion[sel1], this.pCross, this.datosTrain.length)};
            hijos[0].mutation(this.kNeigh, this.pMut, dMatrix, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
            hijos[1].mutation(this.kNeigh, this.pMut, dMatrix, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
            hijos[0].evaluacionCompleta(nClases, this.kNeigh, this.clasesTrain);
            hijos[1].evaluacionCompleta(nClases, this.kNeigh, this.clasesTrain);
            GAeffort += 2.0;
            double temporal = ev += 2.0;
            if (hijos[0].getFitness() > ((Cromosoma)poblacion[this.tamPoblacion - 1]).getFitness() || Randomize.Rand() < 0.0625) {
                ev += hijos[0].optimizacionLocal(nClases, this.kNeigh, this.clasesTrain, dMatrix, umbralOpt, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
            }
            if (hijos[1].getFitness() > ((Cromosoma)poblacion[this.tamPoblacion - 1]).getFitness() || Randomize.Rand() < 0.0625) {
                ev += hijos[1].optimizacionLocal(nClases, this.kNeigh, this.clasesTrain, dMatrix, umbralOpt, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
            }
            LSeffort += ev - temporal;
            if (hijos[0].getFitness() > ((Cromosoma)poblacion[this.tamPoblacion - 1]).getFitness()) {
                poblacion[this.tamPoblacion - 1] = new Cromosoma(this.kNeigh, this.datosTrain.length, hijos[0]);
            }
            if (!(hijos[1].getFitness() > ((Cromosoma)poblacion[this.tamPoblacion - 2]).getFitness())) continue;
            poblacion[this.tamPoblacion - 2] = new Cromosoma(this.kNeigh, this.datosTrain.length, hijos[1]);
        }
        Arrays.sort(poblacion);
        nSel = ((Cromosoma)poblacion[0]).genesActivos();
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        int l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!((Cromosoma)poblacion[0]).getGen(i)) continue;
            for (j = 0; j < this.datosTrain[i].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("SSMA " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida((String)this.ficheroSalida[0], (double[][])conjR, (int[][])conjN, (boolean[][])conjM, (int[])clasesS, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        OutputIS.escribeSalida((String)this.ficheroSalida[1], (InstanceSet)this.test, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        Parameters.assertBasicArgs(this.ficheroSalida);
        PrototypeGenerationAlgorithm.readParametersFile(this.Script);
        PrototypeGenerationAlgorithm.printParameters();
        PrototypeSet training = SSMALVQ3.readPrototypeSet(this.ficheroSalida[0]);
        this.trainingDataSet = SSMALVQ3.readPrototypeSet(this.ficheroTraining);
        this.generador = new PrototypeGenerator(this.trainingDataSet);
        double initialAcc = this.classficationAccuracy1NN(training, this.trainingDataSet);
        System.out.println("Initial Acc = " + initialAcc);
        PrototypeSet LVQ32 = this.makeLVQ3Reduction(training, this.trainingDataSet);
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(LVQ32);
        initialAcc = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
        System.out.println("Final Acc = " + initialAcc);
        LVQ32.print();
        LVQ32.save(this.ficheroSalida[0]);
        int[][] trainRealClass = new int[this.datosTrain.length][1];
        int[][] trainPrediction = new int[this.datosTrain.length][1];
        for (i = 0; i < this.datosTrain.length; ++i) {
            trainRealClass[i][0] = this.clasesTrain[i];
            trainPrediction[i][0] = KNN.evaluate((double[])this.datosTrain[i], (double[][])LVQ32.prototypeSetTodouble(), (int)nClases, (int[])LVQ32.getClases(), (int)1);
        }
        KNN.writeOutput((String)this.ficheroSalida[0], (int[][])trainRealClass, (int[][])trainPrediction, (Attribute[])this.entradas, (Attribute)this.salida, (String)this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate((double[])this.datosTest[i], (double[][])LVQ32.prototypeSetTodouble(), (int)nClases, (int[])LVQ32.getClases(), (int)1);
        }
        KNN.writeOutput((String)this.ficheroSalida[1], (int[][])realClass, (int[][])prediction, (Attribute[])this.entradas, (Attribute)this.salida, (String)this.relation);
    }

    private PrototypeSet makeLVQ3Reduction(PrototypeSet InitialSet, PrototypeSet training) {
        int size = InitialSet.size();
        LVQ3 lvq3 = new LVQ3(InitialSet, training, this.Maxiter, size, this.alpha0, this.windowW, this.epsilon);
        PrototypeSet reducedByLVQ3 = lvq3.reduceSet();
        return reducedByLVQ3;
    }

    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroValidation = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.semilla = Long.parseLong(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.tamPoblacion = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.nEval = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.pCross = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.pMut = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.kNeigh = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.Maxiter = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.alpha0 = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.windowW = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.epsilon = Double.parseDouble(tokens.nextToken().substring(1));
        System.out.print("\nIsaac dice:   alpha0= " + this.alpha0 + " Maxiter= " + this.Maxiter + " epsilon=  " + this.epsilon + "\n");
    }
}

