/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Transformations.z_score;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class z_score {
    double[] mean = null;
    double[] std_dev = null;
    double tempData = 0.0;
    double new_min;
    double new_max;
    String[][] X = null;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    InstanceSet IS;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public z_score(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
    }

    public void normalize() {
        Attribute a;
        int j;
        Attribute a2;
        int j2;
        Instance inst;
        int i;
        int k;
        int[] numAtt;
        double[] square_sum;
        double[] sum;
        int out;
        int in;
        try {
            this.IS.readSet(this.input_train_name, true);
            in = 0;
            out = 0;
            this.ndatos = this.IS.getNumInstances();
            this.nvariables = Attributes.getNumAttributes();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nsalidas = Attributes.getOutputNumAttributes();
            this.X = new String[this.ndatos][this.nvariables];
            sum = new double[this.nvariables];
            square_sum = new double[this.nvariables];
            this.mean = new double[this.nvariables];
            this.std_dev = new double[this.nvariables];
            numAtt = new int[this.nvariables];
            for (k = 0; k < this.nvariables; ++k) {
                sum[k] = 0.0;
                square_sum[k] = 0.0;
                numAtt[k] = 0;
            }
            for (i = 0; i < this.ndatos; ++i) {
                inst = this.IS.getInstance(i);
                in = 0;
                out = 0;
                for (j2 = 0; j2 < this.nvariables; ++j2) {
                    a2 = Attributes.getAttribute(j2);
                    this.direccion = a2.getDirectionAttribute();
                    this.tipo = a2.getType();
                    if (this.direccion == 1) {
                        if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                            int n = j2;
                            sum[n] = sum[n] + inst.getInputRealValues(in);
                            int n2 = j2;
                            square_sum[n2] = square_sum[n2] + inst.getInputRealValues(in) * inst.getInputRealValues(in);
                            int n3 = j2;
                            numAtt[n3] = numAtt[n3] + 1;
                        } else {
                            this.X[i][j2] = !inst.getInputMissingValues(in) ? inst.getInputNominalValues(in) : new String("?");
                        }
                        ++in;
                        continue;
                    }
                    if (this.direccion != 2) continue;
                    if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                        int n = j2;
                        sum[n] = sum[n] + inst.getOutputRealValues(out);
                        int n4 = j2;
                        square_sum[n4] = square_sum[n4] + inst.getOutputRealValues(out);
                        int n5 = j2;
                        numAtt[n5] = numAtt[n5] + 1;
                    } else {
                        this.X[i][j2] = !inst.getOutputMissingValues(out) ? inst.getOutputNominalValues(out) : new String("?");
                    }
                    ++out;
                }
            }
            for (j = 0; j < this.nvariables; ++j) {
                if (numAtt[j] == 0) continue;
                this.mean[j] = sum[j] / (double)numAtt[j];
                this.std_dev[j] = square_sum[j] / (double)numAtt[j] - this.mean[j] * this.mean[j];
                this.std_dev[j] = Math.sqrt(this.std_dev[j]);
            }
            for (i = 0; i < this.ndatos; ++i) {
                inst = this.IS.getInstance(i);
                in = 0;
                out = 0;
                for (j2 = 0; j2 < this.nvariables; ++j2) {
                    a2 = Attributes.getAttribute(j2);
                    this.direccion = a2.getDirectionAttribute();
                    this.tipo = a2.getType();
                    if (this.direccion == 1) {
                        if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                            this.tempData = this.std_dev[j2] != 0.0 ? (inst.getInputRealValues(in) - this.mean[j2]) / this.std_dev[j2] : this.mean[j2];
                            this.X[i][j2] = new String(String.valueOf(this.tempData));
                        }
                        ++in;
                        continue;
                    }
                    if (this.direccion != 2) continue;
                    if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                        this.tempData = this.std_dev[j2] != 0.0 ? (inst.getOutputRealValues(out) - this.mean[j2]) / this.std_dev[j2] : this.mean[j2];
                        this.X[i][j2] = new String(String.valueOf(this.tempData));
                    }
                    ++out;
                }
            }
            for (j = 0; j < this.nvariables; ++j) {
                a = Attributes.getAttribute(j);
                if (this.std_dev[j] != 0.0) {
                    this.new_min = (a.getMinAttribute() - this.mean[j]) / this.std_dev[j];
                    this.new_max = (a.getMaxAttribute() - this.mean[j]) / this.std_dev[j];
                } else {
                    this.new_min = this.new_max = this.mean[j];
                }
                this.tipo = a.getType();
                if (this.tipo == 0) continue;
                a.setBounds(this.new_min, this.new_max);
            }
        }
        catch (Exception e) {
            System.out.println("Dataset exception = " + e);
            System.exit(-1);
        }
        this.write_results(this.output_train_name);
        if (this.input_train_name.compareTo(this.input_test_name) != 0) {
            try {
                Attributes.clearAll();
                this.IS.readSet(this.input_test_name, true);
                in = 0;
                out = 0;
                this.ndatos = this.IS.getNumInstances();
                this.nvariables = Attributes.getNumAttributes();
                this.nentradas = Attributes.getInputNumAttributes();
                this.nsalidas = Attributes.getOutputNumAttributes();
                this.X = new String[this.ndatos][this.nvariables];
                sum = new double[this.nvariables];
                square_sum = new double[this.nvariables];
                this.mean = new double[this.nvariables];
                this.std_dev = new double[this.nvariables];
                numAtt = new int[this.nvariables];
                for (k = 0; k < this.nvariables; ++k) {
                    sum[k] = 0.0;
                    square_sum[k] = 0.0;
                    numAtt[k] = 0;
                }
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IS.getInstance(i);
                    in = 0;
                    out = 0;
                    for (j2 = 0; j2 < this.nvariables; ++j2) {
                        a2 = Attributes.getAttribute(j2);
                        this.direccion = a2.getDirectionAttribute();
                        this.tipo = a2.getType();
                        if (this.direccion == 1) {
                            if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                                int n = j2;
                                sum[n] = sum[n] + inst.getInputRealValues(in);
                                int n6 = j2;
                                square_sum[n6] = square_sum[n6] + inst.getInputRealValues(in) * inst.getInputRealValues(in);
                                int n7 = j2;
                                numAtt[n7] = numAtt[n7] + 1;
                            } else {
                                this.X[i][j2] = !inst.getInputMissingValues(in) ? inst.getInputNominalValues(in) : new String("?");
                            }
                            ++in;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                            int n = j2;
                            sum[n] = sum[n] + inst.getOutputRealValues(out);
                            int n8 = j2;
                            square_sum[n8] = square_sum[n8] + inst.getOutputRealValues(out);
                            int n9 = j2;
                            numAtt[n9] = numAtt[n9] + 1;
                        } else {
                            this.X[i][j2] = !inst.getOutputMissingValues(out) ? inst.getOutputNominalValues(out) : new String("?");
                        }
                        ++out;
                    }
                }
                for (j = 0; j < this.nvariables; ++j) {
                    if (numAtt[j] == 0) continue;
                    this.mean[j] = sum[j] / (double)numAtt[j];
                    this.std_dev[j] = square_sum[j] / (double)numAtt[j] - this.mean[j] * this.mean[j];
                    this.std_dev[j] = Math.sqrt(this.std_dev[j]);
                }
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IS.getInstance(i);
                    in = 0;
                    out = 0;
                    for (j2 = 0; j2 < this.nvariables; ++j2) {
                        a2 = Attributes.getAttribute(j2);
                        this.direccion = a2.getDirectionAttribute();
                        this.tipo = a2.getType();
                        if (this.direccion == 1) {
                            if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                                this.tempData = this.std_dev[j2] != 0.0 ? (inst.getInputRealValues(in) - this.mean[j2]) / this.std_dev[j2] : this.mean[j2];
                                this.X[i][j2] = new String(String.valueOf(this.tempData));
                            }
                            ++in;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                            this.tempData = this.std_dev[j2] != 0.0 ? (inst.getOutputRealValues(out) - this.mean[j2]) / this.std_dev[j2] : this.mean[j2];
                            this.X[i][j2] = new String(String.valueOf(this.tempData));
                        }
                        ++out;
                    }
                }
                for (j = 0; j < this.nvariables; ++j) {
                    a = Attributes.getAttribute(j);
                    if (this.std_dev[j] != 0.0) {
                        this.new_min = (a.getMinAttribute() - this.mean[j]) / this.std_dev[j];
                        this.new_max = (a.getMaxAttribute() - this.mean[j]) / this.std_dev[j];
                    } else {
                        this.new_min = this.new_max = this.mean[j];
                    }
                    this.tipo = a.getType();
                    if (this.tipo == 0) continue;
                    a.setBounds(this.new_min, this.new_max);
                }
            }
            catch (Exception e) {
                System.out.println("Dataset exception = " + e);
                System.exit(-1);
            }
            this.write_results(this.output_test_name);
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            file_reader.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void write_results(String output) {
        String header = "";
        try {
            int j;
            int i;
            FileWriter file_write = new FileWriter(output);
            header = header + "@relation " + Attributes.getRelationName() + "\n";
            for (i = 0; i < Attributes.getNumAttributes(); ++i) {
                Attribute a = Attributes.getAttribute(i);
                if (a.getDirectionAttribute() == 1) {
                    header = header + "@attribute " + a.getName() + " ";
                    if (a.getType() == 0) {
                        header = header + "{";
                        for (j = 0; j < a.getNominalValuesList().size(); ++j) {
                            header = header + (String)a.getNominalValuesList().elementAt(j);
                            if (j >= a.getNominalValuesList().size() - 1) continue;
                            header = header + ", ";
                        }
                        header = header + "}\n";
                        continue;
                    }
                    if (a.getType() == 1) {
                        header = header + "integer";
                        header = header + " [" + String.valueOf((int)a.getMinAttribute()) + ", " + String.valueOf((int)a.getMaxAttribute()) + "]\n";
                        continue;
                    }
                    header = header + "real";
                    header = header + " [" + String.valueOf(a.getMinAttribute()) + ", " + String.valueOf(a.getMaxAttribute()) + "]\n";
                    continue;
                }
                header = header + "@attribute " + a.getName() + " ";
                if (a.getType() == 0) {
                    header = header + "{";
                    for (j = 0; j < a.getNominalValuesList().size(); ++j) {
                        header = header + (String)a.getNominalValuesList().elementAt(j);
                        if (j >= a.getNominalValuesList().size() - 1) continue;
                        header = header + ", ";
                    }
                    header = header + "}\n";
                    continue;
                }
                header = header + "integer [" + String.valueOf((int)a.getMinAttribute()) + ", " + String.valueOf((int)a.getMaxAttribute()) + "]\n";
            }
            file_write.write(header);
            file_write.write(Attributes.getInputHeader() + "\n");
            file_write.write(Attributes.getOutputHeader() + "\n");
            file_write.write("@data\n");
            for (i = 0; i < this.ndatos; ++i) {
                file_write.write(this.X[i][0]);
                for (j = 1; j < this.nvariables; ++j) {
                    file_write.write("," + this.X[i][j]);
                }
                file_write.write("\n");
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }
}

