/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FitnessABDMaxMin;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FuzzyClassifier;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FuzzyRule;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.GeneticAlgorithmForBoosting;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.GenotypeBoostingMaxMin;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.MatrixCalcs;
import org.core.Randomize;

class AdaBoostMaxMin
extends FuzzyClassifier {
    final int MAX_NIT = 4;
    final double MAXLIMALPHA = 1.0;
    int[] cdeseado;
    double[] w;
    static Randomize r;

    AdaBoostMaxMin(double[][] vejemplos, double[][] vdeseado, Randomize vr) {
        super(vejemplos, vdeseado);
        this.cdeseado = new int[vejemplos.length];
        block0: for (int i = 0; i < this.cdeseado.length; ++i) {
            for (int j = 0; j < this.nsalidas; ++j) {
                if (vdeseado[i][j] == 0.0) continue;
                this.cdeseado[i] = j;
                continue block0;
            }
        }
        this.w = new double[1];
        r = vr;
    }

    private int[] duplica(int[] a) {
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    private double[] duplica(double[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    private double[][] duplica(double[][] a) {
        double[][] result = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            result[i] = this.duplica(a[i]);
        }
        return result;
    }

    private void asigna(double[] result, double[] a) {
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i];
        }
    }

    private void asigna(double[][] result, double[][] a) {
        for (int i = 0; i < a.length; ++i) {
            this.asigna(result[i], a[i]);
        }
    }

    public int fuzzyclasificamaxmin(int ej, double[][][] Mu, double[] Peso) {
        int nsalidas = this.BaseConocimiento[0].consecuente.length;
        double max = 0.0;
        int imax = -1;
        int cmax = 0;
        boolean primera = true;
        for (int r = 0; r < this.BaseConocimiento.length; ++r) {
            double act = 0.0;
            int cmaxr = -1;
            double tr = this.CertezaAntecedenteEj(ej, this.BaseConocimiento[r], Mu);
            if (tr == 0.0) continue;
            for (int c = 0; c < this.BaseConocimiento[r].consecuente.length; ++c) {
                double cact = tr * this.BaseConocimiento[r].consecuente[c];
                if (!(cact > act) && c != 0) continue;
                act = cact;
                cmaxr = c;
            }
            if (!(act > max) && !primera) continue;
            primera = false;
            max = act;
            imax = r;
            cmax = cmaxr;
        }
        Peso[0] = max;
        return cmax;
    }

    double FuncionCosteChi(double[][][] Mu) {
        double L = 0.0;
        for (int i = 0; i < this.nelem; ++i) {
            int o = this.fuzzyclasificamaxmin(i, Mu, this.w);
            int d = this.cdeseado[i];
            double ew = Math.exp(this.w[0]);
            double ew1 = Math.exp(-this.w[0] / (double)(this.nsalidas - 1));
            double den = ew + (double)(this.nsalidas - 1) * ew1;
            for (int s = 0; s < this.nsalidas; ++s) {
                double po = s == o ? ew / den : ew1 / den;
                double pd = s == d ? 1.0 : 0.0;
                L += (po - pd) * (po - pd);
            }
        }
        return L;
    }

    double FuncionCosteRMS(double[][][] Mu) {
        double L = 0.0;
        for (int i = 0; i < this.nelem; ++i) {
            int o = this.fuzzyclasificamaxmin(i, Mu, this.w);
            int d = this.cdeseado[i];
            double ew = this.w[0];
            double ew1 = -this.w[0] / (double)(this.nsalidas - 1);
            for (int s = 0; s < this.nsalidas; ++s) {
                double po = s == o ? ew : ew1;
                double pd = s == d ? 2.0 : -2.0;
                L += (po - pd) * (po - pd);
            }
        }
        return L;
    }

    double FuncionCosteERR(double[][][] Mu) {
        double L = 0.0;
        for (int i = 0; i < this.nelem; ++i) {
            int d;
            int o = this.fuzzyclasificamaxmin(i, Mu, this.w);
            if (o == (d = this.cdeseado[i])) continue;
            L += 1.0;
        }
        return L;
    }

    double FuncionCoste(double[][][] Mu) {
        return this.FuncionCosteRMS(Mu);
    }

    double MinimizaFitness(FuzzyRule regla, double[][] alpha, double[][][] Mu, boolean[] entra, boolean optimiza, Randomize rand) {
        int i;
        boolean cubrir = false;
        for (int i2 = 0; i2 < this.nelem; ++i2) {
            if (this.CertezaAntecedenteEj(i2, regla, Mu) == 0.0) continue;
            cubrir = true;
            break;
        }
        if (!cubrir) {
            return 1300000.0;
        }
        int[][] I = new int[this.nelem][this.BaseConocimiento.length + 1];
        int[][] I_old = new int[I.length][I[0].length];
        double[][] Y = new double[this.nsalidas][this.nelem];
        double[][] F = new double[this.BaseConocimiento.length + 1][this.nelem];
        FuzzyRule[] GuardaBanco = this.BaseConocimiento;
        FuzzyRule[] MiNuevoBanco = new FuzzyRule[this.BaseConocimiento.length + 1];
        for (i = 0; i < this.BaseConocimiento.length; ++i) {
            MiNuevoBanco[i] = new FuzzyRule(this.duplica(this.BaseConocimiento[i].antecedente), this.duplica(this.BaseConocimiento[i].consecuente));
        }
        MiNuevoBanco[this.BaseConocimiento.length] = new FuzzyRule(new int[this.nentradas], new double[this.nsalidas]);
        for (i = 0; i < this.nentradas; ++i) {
            MiNuevoBanco[this.BaseConocimiento.length].antecedente[i] = regla.antecedente[i];
        }
        for (i = 0; i < this.nsalidas; ++i) {
            MiNuevoBanco[this.BaseConocimiento.length].consecuente[i] = regla.consecuente[i];
        }
        for (i = 0; i < entra.length; ++i) {
            for (int Clase = 0; Clase < this.nsalidas; ++Clase) {
                MiNuevoBanco[i].consecuente[Clase] = alpha[i][Clase];
            }
        }
        this.BaseConocimiento = MiNuevoBanco;
        double[][] NuevoAlpha = this.duplica(alpha);
        double fitness = 0.0;
        double Rfitness = 0.0;
        if (optimiza) {
            I = this.CalculaI(Mu, MiNuevoBanco);
        }
        int nit = 0;
        while (true) {
            int i3;
            int i4;
            if (nit == 0 && !optimiza) {
                fitness = this.FuncionCoste(Mu);
                break;
            }
            for (int i5 = 0; i5 < F.length; ++i5) {
                for (int j = 0; j < this.nelem; ++j) {
                    for (int Clase = 0; Clase < this.nsalidas; ++Clase) {
                        F[i5][j] = this.CertezaAntecedenteEj(j, MiNuevoBanco[i5], Mu) * (double)I[j][i5];
                        Y[Clase][j] = (this.deseado[j][Clase] - 0.5) / 0.25;
                    }
                }
            }
            int ientra = 0;
            for (int i6 = 0; i6 < entra.length; ++i6) {
                entra[i6] = false;
                for (int j = 0; j < this.nelem; ++j) {
                    if (F[i6][j] == 0.0) continue;
                    entra[i6] = true;
                    break;
                }
                if (!entra[i6]) continue;
                ++ientra;
            }
            double[][] Fentra = new double[ientra][];
            double[][] NuevoAlphaEntra = new double[ientra][this.nsalidas];
            ientra = 0;
            for (int i7 = 0; i7 < entra.length; ++i7) {
                if (!entra[i7]) continue;
                Fentra[ientra] = F[i7];
                ++ientra;
            }
            double[][] NA = this.duplica(NuevoAlpha);
            if (ientra == 0) {
                this.asigna(alpha, NuevoAlpha);
                fitness = 1200000.0;
                break;
            }
            try {
                NuevoAlphaEntra = MatrixCalcs.tr(MatrixCalcs.matmul(Y, MatrixCalcs.matmul(MatrixCalcs.tr(Fentra), MatrixCalcs.inv(MatrixCalcs.matmul((double[][])Fentra, MatrixCalcs.tr(Fentra))))));
            }
            catch (MatrixCalcs.ErrorDimension e) {
                System.err.println(e);
                System.exit(0);
            }
            catch (MatrixCalcs.ErrorSingular e) {
                this.asigna(alpha, NuevoAlpha);
                fitness = 1200000.0;
                break;
            }
            ientra = 0;
            for (int i8 = 0; i8 < entra.length; ++i8) {
                int j;
                if (entra[i8]) {
                    for (j = 0; j < this.nsalidas; ++j) {
                        NuevoAlpha[i8][j] = NuevoAlphaEntra[ientra][j];
                    }
                    ++ientra;
                    continue;
                }
                for (j = 0; j < this.nsalidas; ++j) {
                    NuevoAlpha[i8][j] = 0.0;
                }
            }
            double lambda = 0.75;
            double maxdifalpha = 0.0;
            if (nit > 0) {
                for (int Clase = 0; Clase < this.nsalidas; ++Clase) {
                    for (i4 = 0; i4 < NuevoAlpha.length; ++i4) {
                        double dif = Math.abs(NuevoAlpha[i4][Clase] - NA[i4][Clase]);
                        if (dif > maxdifalpha) {
                            maxdifalpha = dif;
                        }
                        NuevoAlpha[i4][Clase] = lambda * NA[i4][Clase] + (1.0 - lambda) * NuevoAlpha[i4][Clase];
                    }
                }
            }
            for (i3 = 0; i3 < alpha.length; ++i3) {
                for (int Clase = 0; Clase < this.nsalidas; ++Clase) {
                    MiNuevoBanco[i3].consecuente[Clase] = NuevoAlpha[i3][Clase];
                }
            }
            for (i3 = 0; i3 < I.length; ++i3) {
                for (int j = 0; j < I[0].length; ++j) {
                    I_old[i3][j] = I[i3][j];
                }
            }
            I = this.CalculaI(Mu, MiNuevoBanco);
            int distintos = 0;
            for (i4 = 0; i4 < I.length; ++i4) {
                for (int j = 0; j < I[0].length; ++j) {
                    if (I_old[i4][j] == I[i4][j]) continue;
                    ++distintos;
                }
            }
            boolean negativo = true;
            for (int r = 0; r < MiNuevoBanco.length; ++r) {
                negativo = true;
                for (int i9 = 0; i9 < this.nsalidas; ++i9) {
                    if (!(MiNuevoBanco[r].consecuente[i9] > 0.0)) continue;
                    negativo = false;
                    break;
                }
                if (negativo) break;
            }
            if (negativo) {
                fitness = 1100000.0;
                break;
            }
            if (nit >= 4) {
                fitness = this.FuncionCoste(Mu);
                this.asigna(alpha, NuevoAlpha);
                break;
            }
            if (distintos == 0 && maxdifalpha <= 1.0) {
                fitness = this.FuncionCoste(Mu);
                this.asigna(alpha, NuevoAlpha);
                break;
            }
            ++nit;
        }
        this.BaseConocimiento = GuardaBanco;
        return fitness;
    }

    int argmaxabs(double[] x) {
        double max = Math.abs(x[0]);
        int imax = 0;
        for (int i = 1; i < x.length; ++i) {
            if (!(Math.abs(x[i]) > max)) continue;
            max = Math.abs(x[i]);
            imax = i;
        }
        return imax;
    }

    double AnadeReglaABDMM(double[][][] Mu) {
        int i;
        int i2;
        int[] antecedente = new int[this.nentradas];
        double[] consecuente = new double[this.nsalidas];
        double[][] minalpha = new double[this.nelem][this.nsalidas];
        FuzzyRule result = new FuzzyRule(new int[this.nentradas], new double[this.nsalidas]);
        double minfit = 0.0;
        double minfc = 0.0;
        FuzzyRule TestRegla = new FuzzyRule(antecedente, consecuente);
        int nlabels = this.Etiquetas[0].vertices.length;
        FitnessABDMaxMin fitness = new FitnessABDMaxMin(this, this.nentradas, this.nsalidas, nlabels, Mu, r);
        GeneticAlgorithmForBoosting AG = new GeneticAlgorithmForBoosting(new GenotypeBoostingMaxMin(this.nentradas, nlabels, this.nsalidas, this.BaseConocimiento.length + 1, r));
        GenotypeBoostingMaxMin gen = (GenotypeBoostingMaxMin)AG.EncuentraMinimo(this.nentradas, nlabels, fitness, 250, r);
        System.out.println("Convergencias=" + FitnessABDMaxMin.Cuentait[0]);
        System.out.println("Negativos=" + FitnessABDMaxMin.Cuentait[1]);
        System.out.println("Singulares=" + FitnessABDMaxMin.Cuentait[2]);
        System.out.println("No cubre=" + FitnessABDMaxMin.Cuentait[3]);
        FuzzyRule solucion = new FuzzyRule(new int[this.nentradas], new double[this.nsalidas]);
        for (i2 = 0; i2 < this.nentradas; ++i2) {
            solucion.antecedente[i2] = gen.x[i2];
        }
        for (i2 = 0; i2 < this.nsalidas; ++i2) {
            solucion.consecuente[i2] = gen.alpha[this.BaseConocimiento.length * this.nsalidas + i2];
        }
        double fc = fitness.evalua_sin_optimizar(gen);
        System.out.println("Candidato= " + this.AString(solucion.antecedente) + " -> " + this.AString(solucion.consecuente) + " Z=" + fc);
        FuzzyRule[] NuevoBanco = new FuzzyRule[this.BaseConocimiento.length + 1];
        NuevoBanco[this.BaseConocimiento.length] = new FuzzyRule(new int[this.nentradas], new double[this.nsalidas]);
        for (i = 0; i < this.BaseConocimiento.length; ++i) {
            NuevoBanco[i] = this.BaseConocimiento[i];
        }
        for (int r = 0; r < this.BaseConocimiento.length; ++r) {
            for (int Clase = 0; Clase < this.nsalidas; ++Clase) {
                NuevoBanco[r].consecuente[Clase] = gen.alpha[r * this.nsalidas + Clase];
            }
        }
        for (i = 0; i < this.nentradas; ++i) {
            NuevoBanco[this.BaseConocimiento.length].antecedente[i] = solucion.antecedente[i];
        }
        for (i = 0; i < this.nsalidas; ++i) {
            NuevoBanco[this.BaseConocimiento.length].consecuente[i] = solucion.consecuente[i];
        }
        this.BaseConocimiento = NuevoBanco;
        return fc;
    }
}

