/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.DT_GA;

import keel.Algorithms.Decision_Trees.DT_GA.myDataset;
import org.core.Randomize;

public class Selector {
    int atributo;
    int operador;
    public static int IGUAL = 0;
    public static int MENOR_IGUAL = 1;
    public static int MAYOR = 2;
    double valor;
    String[] valoresNom;
    double[] valores;
    String[] nombreAtributos;
    myDataset train;

    public Selector() {
    }

    public Selector(String atributo, String operador, String valor) {
        String numero = new String("" + atributo.charAt(3));
        if (atributo.length() > 4) {
            numero = numero + atributo.charAt(4);
        }
        this.atributo = Integer.parseInt(numero);
        this.valoresNom = new String[1];
        this.valores = new double[1];
        if (operador.equalsIgnoreCase("=")) {
            this.operador = IGUAL;
            this.valoresNom[0] = valor;
            this.valores[0] = myDataset.valorReal(this.atributo, valor);
        } else if (operador.equalsIgnoreCase("<=")) {
            this.operador = MENOR_IGUAL;
            this.valor = Double.parseDouble(valor);
        } else if (operador.equalsIgnoreCase(">")) {
            this.operador = MAYOR;
            this.valor = Double.parseDouble(valor);
        } else {
            System.err.println("There was an error in the parsing of the tree");
            System.exit(0);
        }
    }

    public Selector(int atributo, myDataset train) {
        this.train = train;
        this.atributo = atributo;
        this.adjuntaNombres(train.nombres());
        if (train.getTipo(atributo) == 2) {
            int i;
            this.operador = IGUAL;
            int totalNominales = train.totalNominales(atributo);
            int nominalesEscogidos = Randomize.RandintClosed(1, totalNominales);
            this.valoresNom = new String[nominalesEscogidos];
            this.valores = new double[nominalesEscogidos];
            int[] noSeleccionados = new int[totalNominales];
            for (i = 0; i < totalNominales; ++i) {
                noSeleccionados[i] = i;
            }
            for (i = 0; i < this.valoresNom.length; ++i) {
                int seleccion = Randomize.RandintClosed(0, totalNominales - 1);
                this.valores[i] = 1.0 * (double)noSeleccionados[seleccion];
                this.valoresNom[i] = myDataset.valorNominal(atributo, this.valores[i]);
                noSeleccionados[seleccion] = noSeleccionados[totalNominales - 1];
                --totalNominales;
            }
        } else {
            this.valoresNom = new String[1];
            this.valores = new double[1];
            this.operador = Randomize.RandintClosed(MENOR_IGUAL, MAYOR);
            int ejemplo = Randomize.RandintClosed(0, train.size() - 1);
            this.valor = train.getExample(ejemplo)[atributo];
        }
    }

    public void adjuntaNombres(String[] atributos) {
        this.nombreAtributos = new String[atributos.length];
        this.nombreAtributos = (String[])atributos.clone();
    }

    public String printString() {
        String cadena = new String("");
        cadena = cadena + " " + this.nombreAtributos[this.atributo];
        if (this.operador == IGUAL) {
            int i;
            cadena = cadena + " = {";
            for (i = 0; i < this.valores.length - 1; ++i) {
                cadena = cadena + this.valoresNom[i] + ", ";
            }
            cadena = cadena + this.valoresNom[i] + "} ";
        } else {
            cadena = this.operador == MENOR_IGUAL ? cadena + " <= " + this.valor + " " : cadena + " > " + this.valor + " ";
        }
        return cadena;
    }

    public Selector copia() {
        Selector s = new Selector();
        s.atributo = this.atributo;
        s.operador = this.operador;
        s.valor = this.valor;
        s.valoresNom = new String[this.valoresNom.length];
        s.valoresNom = (String[])this.valoresNom.clone();
        s.valores = new double[this.valores.length];
        s.valores = (double[])this.valores.clone();
        s.nombreAtributos = new String[this.nombreAtributos.length];
        s.nombreAtributos = (String[])this.nombreAtributos.clone();
        s.train = this.train;
        return s;
    }

    public boolean cubre(double[] ejemplo) {
        boolean cubierto = false;
        if (this.operador == IGUAL) {
            for (int i = 0; i < this.valores.length; ++i) {
                cubierto = cubierto || ejemplo[this.atributo] == this.valores[i];
            }
        } else {
            cubierto = this.operador == MENOR_IGUAL ? ejemplo[this.atributo] <= this.valor : ejemplo[this.atributo] > this.valor;
        }
        return cubierto;
    }

    public void modifica(double[] ejemplo) {
        if (this.operador == IGUAL) {
            int i;
            double[] aux = (double[])this.valores.clone();
            String[] auxNom = (String[])this.valoresNom.clone();
            this.valores = new double[aux.length + 1];
            this.valoresNom = new String[auxNom.length + 1];
            for (i = 0; i < aux.length; ++i) {
                this.valores[i] = aux[i];
                this.valoresNom[i] = auxNom[i];
            }
            this.valores[i] = ejemplo[this.atributo];
            this.valoresNom[i] = myDataset.valorNominal(this.atributo, this.valores[i]);
        } else {
            this.valor = this.operador == MENOR_IGUAL ? ejemplo[this.atributo] : ejemplo[this.atributo] - 1.0;
        }
    }

    public int getAtributo() {
        return this.atributo;
    }

    public void mutar() {
        if (this.operador == IGUAL) {
            int i;
            int totalNominales = this.train.totalNominales(this.atributo);
            int nominalesEscogidos = Randomize.RandintClosed(1, totalNominales);
            this.valoresNom = new String[nominalesEscogidos];
            this.valores = new double[nominalesEscogidos];
            int[] noSeleccionados = new int[totalNominales];
            for (i = 0; i < totalNominales; ++i) {
                noSeleccionados[i] = i;
            }
            for (i = 0; i < this.valoresNom.length; ++i) {
                int seleccion = Randomize.RandintClosed(0, totalNominales - 1);
                this.valores[i] = 1.0 * (double)noSeleccionados[seleccion];
                this.valoresNom[i] = myDataset.valorNominal(this.atributo, this.valores[i]);
                noSeleccionados[seleccion] = noSeleccionados[totalNominales - 1];
                --totalNominales;
            }
        } else {
            int ejemplo = Randomize.RandintClosed(0, this.train.size() - 1);
            this.valor = this.train.getExample(ejemplo)[this.atributo];
        }
    }
}

