## ---- echo = FALSE-------------------------------------------------------
library(knitLatex)
knitr::opts_chunk$set(collapse = TRUE)
cars  <- mtcars[1:10,1:5]

## ------------------------------------------------------------------------
xTab(cars)

## ------------------------------------------------------------------------
xTab(cars, label = 'tab:mytable')

## ------------------------------------------------------------------------
xTab(cars, caption.top = 'my table')

## ------------------------------------------------------------------------
xTab(cars, caption.bottom = 'my table')

## ------------------------------------------------------------------------
xTab(cars, booktabs = TRUE)

## ------------------------------------------------------------------------
xTab(cars, booktabs = TRUE, midrule = '\\hline')

## ------------------------------------------------------------------------
xTab(cars, position = '!htbp')

## ------------------------------------------------------------------------
xTab(cars,
     head = 'col1 & col 2 & col3 & \\eta & col5 \\\\')

## ------------------------------------------------------------------------
xTab(cars, head = NULL)

## ------------------------------------------------------------------------
lTab(cars, head = '', midrule = NULL)

## ------------------------------------------------------------------------
xTab(cars, rows = TRUE)

## ------------------------------------------------------------------------
xTab(cars,
     rows =  TRUE,
     head = 'rows & col1 & col2 & col3 & \\eta & col5 \\\\')

## ------------------------------------------------------------------------
xTab(cars, rowsep = '\\hline')

## ------------------------------------------------------------------------
xTab(cars, rowsep = '\\midrule')

## ------------------------------------------------------------------------
xTab(cars, coldef ='rlc|l|p{5cm}')

## ------------------------------------------------------------------------
xTab(cars, colsep = '|')

