/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.Field;
import cc.mallet.extract.LabeledSpan;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.types.Label;
import gnu.trove.THashMap;
import java.util.Iterator;

public class Record {
    private THashMap fieldMap;
    private String name;

    public Record(String name, LabeledSpans spans) {
        this.name = name;
        this.fieldMap = new THashMap();
        for (int i = 0; i < spans.size(); ++i) {
            LabeledSpan span = spans.getLabeledSpan(i);
            if (span.isBackground()) continue;
            Label tag = span.getLabel();
            Field field = (Field)this.fieldMap.get((Object)tag);
            if (field == null) {
                field = new Field(span);
                this.fieldMap.put((Object)tag, (Object)field);
                continue;
            }
            field.addFiller(span);
        }
    }

    public String getName() {
        return this.name;
    }

    public Field getField(Label name) {
        return (Field)this.fieldMap.get((Object)name);
    }

    public Iterator fieldsIterator() {
        return this.fieldMap.values().iterator();
    }
}

