/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.fetch.ui;

import com.qarks.util.fetch.logic.DynamicDataFetcher;
import com.qarks.util.fetch.logic.DynamicDataSet;
import com.qarks.util.fetch.logic.DynamicTableDataProvider;
import com.qarks.util.ui.sort.Arrow;
import com.qarks.util.ui.sort.ColumnTable;
import com.qarks.util.ui.sort.SortableColumn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class DynamicTable
extends JPanel {
    private ColumnTable table;
    private JScrollPane scrollPane;
    private JScrollBar verticalScrollBar;
    private Timer monitorTimer;
    private DynamicDataFetcher dataFetcher;
    private Hashtable<String, String> bindings = new Hashtable();
    private String sortCriteria;
    private boolean ascending = false;
    private boolean scrollingDown = true;
    private int previousScrollValue = 0;
    private final int THRESHOLD = 10;
    private final int INCREMENT = 20;
    private final int CLEAN = 200;
    private int startVisibleIndex;
    private int endVisibleIndex;
    private boolean initDone = false;
    private boolean fetching = false;
    private int emptyRowIndex = 0;
    private TableHeaderMouseAdapter mouseListener;
    private boolean requestDefined = false;
    public boolean contentSet = false;

    public DynamicTable(DynamicTableDataProvider dynamicTableDataProvider) {
        this.dataFetcher = new DynamicDataFetcher(dynamicTableDataProvider);
        this.table = new ColumnTable();
        this.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.scrollPane = new JScrollPane(jPanel);
        jPanel.add((Component)this.table, "Center");
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortableHeaderRenderer(jTableHeader.getDefaultRenderer()));
        this.mouseListener = new TableHeaderMouseAdapter();
        jTableHeader.addMouseListener(this.mouseListener);
        jTableHeader.setReorderingAllowed(false);
        this.scrollPane.setColumnHeaderView(jTableHeader);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.verticalScrollBar = this.scrollPane.getVerticalScrollBar();
        this.verticalScrollBar.setUnitIncrement(fontMetrics.getHeight());
        this.verticalScrollBar.addAdjustmentListener(new DynamicTableScrollBarListener());
        this.scrollPane.addComponentListener(new TableComponentListener());
        this.monitorTimer = new Timer(200, new TimerListener());
        this.add(this.scrollPane);
    }

    public void setRequestDefined(boolean bl) {
        if (this.requestDefined != bl) {
            this.requestDefined = bl;
            this.init();
        }
    }

    public JTable getTable() {
        return this.table;
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    protected void init() {
        if (this.requestDefined) {
            this.updateVisibleIndexes();
            this.table.setRowCount(this.endVisibleIndex + 10);
            this.table.resetData(0, this.endVisibleIndex + 10 - 1);
            this.initDone = true;
            this.monitorTimer.start();
        } else {
            this.table.setRowCount(0);
            this.initDone = false;
        }
    }

    private void updateVisibleIndexes() {
        int n;
        int n2 = n = this.verticalScrollBar.getValue();
        int n3 = this.table.getRowHeight();
        this.startVisibleIndex = n2 / n3;
        int n4 = this.scrollPane.getViewport().getHeight();
        this.endVisibleIndex = (n2 + n4) / n3;
    }

    public void reset() {
        this.verticalScrollBar.setValue(0);
        this.emptyRowIndex = 0;
        this.init();
        this.updateView();
        this.table.getSelectionModel().clearSelection();
    }

    private void updateView() {
        if (this.initDone && !this.fetching) {
            int n;
            this.updateVisibleIndexes();
            int n2 = this.table.getRowCount();
            boolean bl = false;
            for (n = this.startVisibleIndex; !bl && n < this.endVisibleIndex; ++n) {
                if (n < 0 || n >= n2 || this.table.getValueAt(n, 0) != null) continue;
                bl = true;
            }
            if (bl && (n = n2 - this.emptyRowIndex - 1) > 0) {
                this.fetching = true;
                this.dataFetcher.asynchFetchData(null, this.sortCriteria, this.ascending, this.emptyRowIndex, n + 20);
            }
        }
    }

    private void checkForDataFetched() {
        DynamicDataSet[] dynamicDataSetArray;
        boolean bl = false;
        for (DynamicDataSet dynamicDataSet : dynamicDataSetArray = this.dataFetcher.consumeFetchedDataSet()) {
            Object[] objectArray = dynamicDataSet.getDataRows();
            int n = dynamicDataSet.getOffset() + objectArray.length;
            if (!dynamicDataSet.isLast()) {
                n += 20;
            }
            if (n > this.table.getRowCount() || dynamicDataSet.isLast()) {
                this.table.setRowCount(n);
            }
            bl = true;
            int n2 = dynamicDataSet.getOffset();
            for (int i = 0; i < objectArray.length; ++i) {
                this.table.setValueAt(objectArray[i], n2 + i, 0);
            }
            this.emptyRowIndex = n2 + objectArray.length;
        }
        if (bl) {
            this.fetching = false;
        }
    }

    public int[] getColumnSizes() {
        int[] nArray = new int[this.table.getColumnCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.table.getColumnModel().getColumn(i).getWidth();
        }
        return nArray;
    }

    public void addColumn(String string, SortableColumn sortableColumn) {
        this.bindings.put(sortableColumn.getName(), string);
        this.table.addColumn(sortableColumn);
    }

    private int getSortingStatus(int n) {
        SortableColumn sortableColumn = (SortableColumn)this.table.getColumnModel().getColumn(n);
        return sortableColumn.getDirection();
    }

    private void cancelSorting() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            SortableColumn sortableColumn = (SortableColumn)this.table.getColumnModel().getColumn(i);
            sortableColumn.setSorted(0, 0);
        }
    }

    private void setSortingStatus(int n, int n2) {
        SortableColumn sortableColumn = (SortableColumn)this.table.getColumnModel().getColumn(n);
        sortableColumn.setSorted(n2, 0);
        if (n2 != 0) {
            String string = sortableColumn.getName();
            this.sortCriteria = this.bindings.get(string);
            this.ascending = sortableColumn.getDirection() == 1;
        } else {
            this.sortCriteria = null;
            this.ascending = false;
        }
    }

    protected Icon getHeaderRendererIcon(int n, int n2) {
        SortableColumn sortableColumn = (SortableColumn)this.table.getColumnModel().getColumn(n);
        int n3 = sortableColumn.getDirection();
        int n4 = sortableColumn.getPriority();
        if (n3 == 0) {
            return null;
        }
        return new Arrow(n3 == -1, n2, n4);
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(DynamicTable.this.table, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                int n3 = DynamicTable.this.table.convertColumnIndexToModel(n2);
                jLabel.setIcon(DynamicTable.this.getHeaderRendererIcon(n3, jLabel.getFont().getSize()));
            }
            return component;
        }
    }

    private class TableHeaderMouseAdapter
    extends MouseAdapter {
        private TableHeaderMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 != -1) {
                int n3 = DynamicTable.this.getSortingStatus(n2);
                DynamicTable.this.cancelSorting();
                n3 += mouseEvent.isShiftDown() ? 1 : -1;
                n3 = (n3 + 4) % 3 - 1;
                DynamicTable.this.setSortingStatus(n2, n3);
            }
            DynamicTable.this.verticalScrollBar.setValue(0);
            DynamicTable.this.reset();
            DynamicTable.this.repaint();
        }
    }

    private class TableComponentListener
    implements ComponentListener {
        private TableComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (DynamicTable.this.isVisible() && !DynamicTable.this.contentSet) {
                if (!DynamicTable.this.initDone) {
                    DynamicTable.this.init();
                }
                DynamicTable.this.updateView();
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            DynamicTable.this.monitorTimer.start();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            DynamicTable.this.monitorTimer.stop();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }
    }

    private class DynamicTableScrollBarListener
    implements AdjustmentListener {
        private DynamicTableScrollBarListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            boolean bl = false;
            if (!adjustmentEvent.getValueIsAdjusting()) {
                int n = DynamicTable.this.verticalScrollBar.getValue();
                DynamicTable.this.scrollingDown = n > DynamicTable.this.previousScrollValue;
                bl = n != DynamicTable.this.previousScrollValue;
                DynamicTable.this.previousScrollValue = n;
                if (bl) {
                    DynamicTable.this.updateView();
                }
            }
        }
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DynamicTable.this.checkForDataFetched();
        }
    }
}

