/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RStringVector;

public class RFactorVector
extends RIntegerVector {
    public RFactorVector(int[] values, RPair attributes) {
        super(values, attributes);
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    public RStringVector getLevels() {
        return this.getStringAttribute("levels");
    }

    public List<String> getLevelValues() {
        RStringVector levels = this.getLevels();
        return levels.getValues();
    }

    public String getFactorValue(int index) {
        RStringVector levels = this.getLevels();
        Integer value = this.getValue(index);
        if (value == null) {
            return null;
        }
        return levels.getValue(value - 1);
    }

    public List<String> getFactorValues() {
        List<Integer> values = this.getValues();
        final List<String> levelValues = this.getLevelValues();
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer value) {
                if (value == null) {
                    return null;
                }
                return (String)levelValues.get(value - 1);
            }
        };
        return Lists.transform(values, (Function)function);
    }
}

