/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModuleSpec
implements Cloneable {
    public static final byte SPEC_TYPE_COMP = 0;
    public static final byte SPEC_TYPE_TILE = 1;
    public static final byte SPEC_TYPE_TILE_COMP = 2;
    public static final byte SPEC_DEF = 0;
    public static final byte SPEC_COMP_DEF = 1;
    public static final byte SPEC_TILE_DEF = 2;
    public static final byte SPEC_TILE_COMP = 3;
    protected int specType;
    protected int nTiles = 0;
    protected int nComp = 0;
    protected byte[][] specValType;
    protected Object def = null;
    protected Object[] compDef = null;
    protected Object[] tileDef = null;
    protected Hashtable tileCompVal;
    protected String specified;

    public ModuleSpec getCopy() {
        return (ModuleSpec)this.clone();
    }

    public ModuleSpec(int nt, int nc, byte type) {
        this.nTiles = nt;
        this.nComp = nc;
        this.specValType = new byte[nt][nc];
        switch (type) {
            case 1: {
                this.specType = 1;
                break;
            }
            case 0: {
                this.specType = 0;
                break;
            }
            case 2: {
                this.specType = 2;
            }
        }
    }

    protected Object clone() {
        int t;
        ModuleSpec ms;
        try {
            ms = (ModuleSpec)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new Error("Error when cloning ModuleSpec instance");
        }
        ms.specValType = new byte[this.nTiles][this.nComp];
        for (t = 0; t < this.nTiles; ++t) {
            for (int c2 = 0; c2 < this.nComp; ++c2) {
                ms.specValType[t][c2] = this.specValType[t][c2];
            }
        }
        if (this.tileDef != null) {
            ms.tileDef = new Object[this.nTiles];
            for (t = 0; t < this.nTiles; ++t) {
                ms.tileDef[t] = this.tileDef[t];
            }
        }
        if (this.tileCompVal != null) {
            ms.tileCompVal = new Hashtable();
            Enumeration e3 = this.tileCompVal.keys();
            while (e3.hasMoreElements()) {
                String tmpKey = (String)e3.nextElement();
                Object tmpVal = this.tileCompVal.get(tmpKey);
                ms.tileCompVal.put(tmpKey, tmpVal);
            }
        }
        return ms;
    }

    public void rotate90(Point anT) {
        int ax;
        int ay;
        byte[][] tmpsvt = new byte[this.nTiles][];
        Point bnT = new Point(anT.y, anT.x);
        for (int by = 0; by < bnT.y; ++by) {
            for (int bx = 0; bx < bnT.x; ++bx) {
                ay = bx;
                ax = bnT.y - by - 1;
                tmpsvt[ay * anT.x + ax] = this.specValType[by * bnT.x + bx];
            }
        }
        this.specValType = tmpsvt;
        if (this.tileDef != null) {
            Object[] tmptd = new Object[this.nTiles];
            for (int by = 0; by < bnT.y; ++by) {
                for (int bx = 0; bx < bnT.x; ++bx) {
                    ay = bx;
                    ax = bnT.y - by - 1;
                    tmptd[ay * anT.x + ax] = this.tileDef[by * bnT.x + bx];
                }
            }
            this.tileDef = tmptd;
        }
        if (this.tileCompVal != null && this.tileCompVal.size() > 0) {
            Hashtable tmptcv = new Hashtable();
            Enumeration e2 = this.tileCompVal.keys();
            while (e2.hasMoreElements()) {
                String tmpKey = (String)e2.nextElement();
                Object tmpVal = this.tileCompVal.get(tmpKey);
                int i1 = tmpKey.indexOf(116);
                int i2 = tmpKey.indexOf(99);
                int btIdx = new Integer(tmpKey.substring(i1 + 1, i2));
                int bx = btIdx % bnT.x;
                int by = btIdx / bnT.x;
                ay = bx;
                ax = bnT.y - by - 1;
                int atIdx = ax + ay * anT.x;
                tmptcv.put("t" + atIdx + tmpKey.substring(i2), tmpVal);
            }
            this.tileCompVal = tmptcv;
        }
    }

    public void setDefault(Object value) {
        this.def = value;
    }

    public Object getDefault() {
        return this.def;
    }

    public void setCompDef(int c2, Object value) {
        if (this.specType == 1) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for components as it is a 'tile only' specific " + "option";
            throw new Error(errMsg);
        }
        if (this.compDef == null) {
            this.compDef = new Object[this.nComp];
        }
        for (int i = 0; i < this.nTiles; ++i) {
            if (this.specValType[i][c2] >= 1) continue;
            this.specValType[i][c2] = 1;
        }
        this.compDef[c2] = value;
    }

    public Object getCompDef(int c2) {
        if (this.specType == 1) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.compDef == null || this.compDef[c2] == null) {
            return this.getDefault();
        }
        return this.compDef[c2];
    }

    public void setTileDef(int t, Object value) {
        if (this.specType == 0) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for tiles as it is a 'component only' specific " + "option";
            throw new Error(errMsg);
        }
        if (this.tileDef == null) {
            this.tileDef = new Object[this.nTiles];
        }
        for (int i = 0; i < this.nComp; ++i) {
            if (this.specValType[t][i] >= 2) continue;
            this.specValType[t][i] = 2;
        }
        this.tileDef[t] = value;
    }

    public Object getTileDef(int t) {
        if (this.specType == 0) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.tileDef == null || this.tileDef[t] == null) {
            return this.getDefault();
        }
        return this.tileDef[t];
    }

    public void setTileCompVal(int t, int c2, Object value) {
        if (this.specType != 2) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for ";
            switch (this.specType) {
                case 1: {
                    errMsg = errMsg + "components as it is a 'tile only' specific option";
                    break;
                }
                case 0: {
                    errMsg = errMsg + "tiles as it is a 'component only' specific option";
                }
            }
            throw new Error(errMsg);
        }
        if (this.tileCompVal == null) {
            this.tileCompVal = new Hashtable();
        }
        this.specValType[t][c2] = 3;
        this.tileCompVal.put("t" + t + "c" + c2, value);
    }

    public Object getTileCompVal(int t, int c2) {
        if (this.specType != 2) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        return this.getSpec(t, c2);
    }

    protected Object getSpec(int t, int c2) {
        switch (this.specValType[t][c2]) {
            case 0: {
                return this.getDefault();
            }
            case 1: {
                return this.getCompDef(c2);
            }
            case 2: {
                return this.getTileDef(t);
            }
            case 3: {
                return this.tileCompVal.get("t" + t + "c" + c2);
            }
        }
        throw new IllegalArgumentException("Not recognized spec type");
    }

    public byte getSpecValType(int t, int c2) {
        return this.specValType[t][c2];
    }

    public boolean isCompSpecified(int c2) {
        return this.compDef != null && this.compDef[c2] != null;
    }

    public boolean isTileSpecified(int t) {
        return this.tileDef != null && this.tileDef[t] != null;
    }

    public boolean isTileCompSpecified(int t, int c2) {
        return this.tileCompVal != null && this.tileCompVal.get("t" + t + "c" + c2) != null;
    }

    public static final boolean[] parseIdx(String word, int maxIdx) {
        int j;
        int nChar = word.length();
        char c2 = word.charAt(0);
        int idx = -1;
        int lastIdx = -1;
        boolean isDash = false;
        boolean[] idxSet = new boolean[maxIdx];
        for (int i = 1; i < nChar; ++i) {
            c2 = word.charAt(i);
            if (Character.isDigit(c2)) {
                if (idx == -1) {
                    idx = 0;
                }
                idx = idx * 10 + (c2 - 48);
                continue;
            }
            if (idx == -1 || c2 != ',' && c2 != '-') {
                throw new IllegalArgumentException("Bad construction for parameter: " + word);
            }
            if (idx < 0 || idx >= maxIdx) {
                throw new IllegalArgumentException("Out of range index in parameter `" + word + "' : " + idx);
            }
            if (c2 == ',') {
                if (isDash) {
                    for (j = lastIdx + 1; j < idx; ++j) {
                        idxSet[j] = true;
                    }
                }
                isDash = false;
            } else {
                isDash = true;
            }
            idxSet[idx] = true;
            lastIdx = idx;
            idx = -1;
        }
        if (idx < 0 || idx >= maxIdx) {
            throw new IllegalArgumentException("Out of range index in parameter `" + word + "' : " + idx);
        }
        if (isDash) {
            for (j = lastIdx + 1; j < idx; ++j) {
                idxSet[j] = true;
            }
        }
        idxSet[idx] = true;
        return idxSet;
    }
}

