/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class NaiveTimeCumulFilter
extends CumulFilter {
    private int[] time = new int[31];

    public NaiveTimeCumulFilter(int nbMaxTasks) {
        super(nbMaxTasks);
    }

    @Override
    public void filter(IntVar[] s2, IntVar[] d2, IntVar[] e2, IntVar[] h2, IntVar capa, ISet tasks, Propagator<IntVar> aCause) throws ContradictionException {
        int min2 = 0x3FFFFFFF;
        int max = -1073741824;
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int i2 = tIter.nextInt();
            if (s2[i2].getUB() >= s2[i2].getLB() + d2[i2].getValue()) continue;
            min2 = Math.min(min2, s2[i2].getUB());
            max = Math.max(max, s2[i2].getLB() + d2[i2].getValue());
        }
        if (min2 < max) {
            int t;
            if (max - min2 > this.time.length) {
                this.time = new int[max - min2];
            } else {
                Arrays.fill(this.time, 0, max - min2, 0);
            }
            int capaMax = capa.getValue();
            tIter = tasks.iterator();
            while (tIter.hasNext()) {
                int i3 = tIter.nextInt();
                int elb = s2[i3].getLB() + d2[i3].getValue();
                int hlb = h2[i3].getValue();
                for (t = s2[i3].getUB(); t < elb; ++t) {
                    int n = t - min2;
                    this.time[n] = this.time[n] + hlb;
                }
            }
            ISetIterator i3 = tasks.iterator();
            while (i3.hasNext()) {
                int i4 = (Integer)i3.next();
                if (d2[i4].getValue() <= 0 || h2[i4].getValue() <= 0) continue;
                if (s2[i4].getLB() + d2[i4].getValue() > min2) {
                    this.filterInf(s2[i4], d2[i4].getValue(), h2[i4].getValue(), min2, max, this.time, capaMax, aCause);
                }
                if (s2[i4].getUB() >= max) continue;
                this.filterSup(s2[i4], d2[i4].getValue(), h2[i4].getValue(), min2, max, this.time, capaMax, aCause);
            }
            OptionalInt tmax = IntStream.range(0, max - min2).filter(k -> this.time[k] > capaMax).findAny();
            if (tmax.isPresent()) {
                t = tmax.getAsInt() + min2;
                int[] _tasks = IntStream.range(0, s2.length).filter(i -> d2[i].getValue() > 0 && h2[i].getValue() > 0 && s2[i].getUB() <= t && t < s2[i].getLB() + d2[i].getValue()).toArray();
                if (_tasks.length > 0) {
                    s2[_tasks[0]].updateUpperBound(t - d2[_tasks[0]].getValue(), aCause);
                } else {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void filterInf(IntVar start, int dlb, int hlb, int min2, int max, int[] time, int capaMax, Propagator<IntVar> aCause) throws ContradictionException {
        int nbOk = 0;
        int sub = start.getUB();
        for (int t = start.getLB(); t < sub; ++t) {
            if (t < min2 || t >= max || hlb + time[t - min2] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            nbOk = 0;
            start.updateLowerBound(t + 1, aCause);
        }
    }

    private void filterSup(IntVar start, int dlb, int hlb, int min2, int max, int[] time, int capaMax, Propagator<IntVar> aCause) throws ContradictionException {
        int nbOk = 0;
        int elb = start.getLB() + dlb;
        for (int t = start.getUB() + dlb; t > elb; --t) {
            if (t - 1 < min2 || t - 1 >= max || hlb + time[t - min2 - 1] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            nbOk = 0;
            start.updateUpperBound(t - 1 - dlb, aCause);
        }
    }
}

