/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sort;

import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.util.Arrays;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.PriorityQueue;
import org.chocosolver.util.tools.ArrayUtils;

public final class PropSort
extends Propagator<IntVar> {
    private final int n;
    private final PriorityQueue pQueue;
    private final IntVar[] x;
    private final IntVar[] y;
    private final int[] f;
    private final int[] fPrime;
    private final int[][] xyGraph;
    private final int[] dfsNodes;
    private final int[] sccNumbers;
    private int currentSccNumber;
    private final int[] tmpArray;
    private final int[][] sccSequences;
    private final TIntStack s1;
    private final Stack2 s2;
    private final int[] recupStack = new int[3];
    private final int[] recupStack2 = new int[3];

    public PropSort(IntVar[] x, IntVar[] y) {
        super((Variable[])ArrayUtils.append(x, y), (Priority)PropagatorPriority.LINEAR, false);
        if (x.length != y.length || x.length == 0) {
            throw new IllegalArgumentException("PropSort Error: the two vectors must be of the same (non zero) size");
        }
        this.n = x.length;
        this.x = x;
        this.y = y;
        this.f = new int[this.n];
        this.fPrime = new int[this.n];
        this.xyGraph = new int[this.n][this.n];
        this.sccSequences = new int[this.n][this.n];
        this.dfsNodes = new int[this.n];
        this.sccNumbers = new int[this.n];
        this.tmpArray = new int[this.n];
        this.pQueue = new PriorityQueue(this.n);
        this.s1 = new TIntArrayStack(this.n);
        this.s2 = new Stack2(this.n);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int i;
            int[] _x = new int[this.n];
            for (i = 0; i < this.n; ++i) {
                _x[i] = this.x[i].getValue();
            }
            Arrays.sort(_x);
            for (i = 0; i < this.n && _x[i] == this.y[i].getValue(); ++i) {
            }
            return ESat.eval(i == this.n);
        }
        return ESat.UNDEFINED;
    }

    private void filter() throws ContradictionException {
        int k;
        int jprime;
        int j;
        int i;
        for (i = 0; i < this.n; ++i) {
            Arrays.fill(this.xyGraph[i], -1);
            Arrays.fill(this.sccSequences[i], -1);
        }
        this.normalize(this.y);
        this.pQueue.clear();
        for (i = 0; i < this.n; ++i) {
            if (!this.intersect(0, i)) continue;
            this.pQueue.addElement(i, this.x[i].getUB());
        }
        this.f[0] = this.computeF(0);
        for (j = 1; j < this.n; ++j) {
            for (i = 0; i < this.n; ++i) {
                if (this.x[i].getLB() <= this.y[j - 1].getUB() || this.x[i].getLB() > this.y[j].getUB()) continue;
                this.pQueue.addElement(i, this.x[i].getUB());
            }
            this.f[j] = this.computeF(j);
        }
        for (i = 0; i < this.n; ++i) {
            this.y[i].updateUpperBound(this.x[this.f[i]].getUB(), this);
        }
        this.pQueue.clear();
        for (i = 0; i < this.n; ++i) {
            if (!this.intersect(this.n - 1, i)) continue;
            this.pQueue.addElement(i, -this.x[i].getLB());
        }
        this.fPrime[this.n - 1] = this.computeFPrime(this.n - 1);
        for (j = this.n - 2; j >= 0; --j) {
            for (i = 0; i < this.n; ++i) {
                if (this.x[i].getUB() >= this.y[j + 1].getLB() || this.x[i].getUB() < this.y[j].getLB()) continue;
                this.pQueue.addElement(i, -this.x[i].getLB());
            }
            this.fPrime[j] = this.computeFPrime(j);
        }
        for (i = 0; i < this.n; ++i) {
            this.y[i].updateLowerBound(this.x[this.fPrime[i]].getLB(), this);
        }
        for (j = 0; j < this.n; ++j) {
            int tmp = 0;
            jprime = this.f[j];
            for (i = 0; i < this.n; ++i) {
                if (j == i || !this.intersect(i, jprime)) continue;
                this.xyGraph[j][tmp] = i;
                ++tmp;
            }
        }
        this.dfs();
        Arrays.fill(this.tmpArray, 0);
        for (i = 0; i < this.n; ++i) {
            this.sccSequences[this.sccNumbers[i]][this.tmpArray[this.sccNumbers[i]]] = i;
            int n = this.sccNumbers[i];
            this.tmpArray[n] = this.tmpArray[n] + 1;
        }
        for (i = 0; i < this.n && this.sccSequences[i][0] != -1; ++i) {
            for (j = 0; j < this.n && this.sccSequences[i][j] != -1; ++j) {
                jprime = this.f[this.sccSequences[i][j]];
                for (k = 0; k < this.n && this.sccSequences[i][k] != -1 && this.x[jprime].getLB() > this.y[this.sccSequences[i][k]].getUB(); ++k) {
                }
                assert (this.sccSequences[i][k] != -1);
                this.x[jprime].updateLowerBound(this.y[this.sccSequences[i][k]].getLB(), this);
            }
        }
        Arrays.fill(this.tmpArray, 0);
        for (i = this.n - 1; i >= 0; --i) {
            this.sccSequences[this.sccNumbers[i]][this.tmpArray[this.sccNumbers[i]]] = i;
            int n = this.sccNumbers[i];
            this.tmpArray[n] = this.tmpArray[n] + 1;
        }
        for (i = 0; i < this.n && this.sccSequences[i][0] != -1; ++i) {
            for (j = 0; j < this.n && this.sccSequences[i][j] != -1; ++j) {
                jprime = this.f[this.sccSequences[i][j]];
                for (k = 0; k < this.n && this.sccSequences[i][k] != -1 && this.x[jprime].getUB() < this.y[this.sccSequences[i][k]].getLB(); ++k) {
                }
                assert (this.sccSequences[i][k] != -1);
                this.x[jprime].updateUpperBound(this.y[this.sccSequences[i][k]].getUB(), this);
            }
        }
    }

    private void normalize(IntVar[] y) throws ContradictionException {
        int i;
        for (i = 1; i < this.n; ++i) {
            y[i].updateLowerBound(y[i - 1].getLB(), this);
        }
        for (i = this.n - 2; i >= 0; --i) {
            y[i].updateUpperBound(y[i + 1].getUB(), this);
        }
    }

    private boolean intersect(int y, int x) {
        return this.x[x].getLB() >= this.y[y].getLB() && this.x[x].getLB() <= this.y[y].getUB() || this.x[x].getUB() >= this.y[y].getLB() && this.x[x].getUB() <= this.y[y].getUB() || this.y[y].getLB() >= this.x[x].getLB() && this.y[y].getLB() <= this.x[x].getUB() || this.y[y].getUB() >= this.x[x].getLB() && this.y[y].getUB() <= this.x[x].getUB();
    }

    private int computeF(int j) throws ContradictionException {
        int i;
        if (this.pQueue.isEmpty()) {
            this.fails();
        }
        if (this.x[i = this.pQueue.pop()].getUB() < this.y[j].getLB()) {
            this.fails();
        }
        return i;
    }

    private int computeFPrime(int j) throws ContradictionException {
        int i;
        if (this.pQueue.isEmpty()) {
            this.fails();
        }
        if (this.x[i = this.pQueue.pop()].getLB() > this.y[j].getUB()) {
            this.fails();
        }
        return i;
    }

    private void dfs() {
        int i;
        Arrays.fill(this.dfsNodes, 0);
        this.s1.clear();
        this.s2.clear();
        this.currentSccNumber = 0;
        for (i = 0; i < this.n; ++i) {
            if (this.dfsNodes[i] != 0) continue;
            this.dfsVisit(i);
        }
        while (this.s1.size() > 0 && !this.s2.isEmpty()) {
            this.s2.peek(this.recupStack);
            do {
                i = this.s1.pop();
                this.sccNumbers[i] = this.currentSccNumber;
            } while (this.s1.size() > 0 && i != this.recupStack[0]);
            ++this.currentSccNumber;
            this.s2.pop();
        }
    }

    private void dfsVisit(int node) {
        this.dfsNodes[node] = 1;
        if (this.s2.isEmpty()) {
            this.s1.push(node);
            this.s2.push(node, node, this.x[this.f[node]].getUB());
            int i = 0;
            while (this.xyGraph[node][i] != -1) {
                if (this.dfsNodes[this.xyGraph[node][i]] == 0) {
                    this.dfsVisit(this.xyGraph[node][i]);
                }
                ++i;
            }
        } else {
            int i;
            while (this.s2.peek(this.recupStack) && this.recupStack[2] < this.y[node].getLB()) {
                while ((i = this.s1.pop()) != this.recupStack[0]) {
                    this.sccNumbers[i] = this.currentSccNumber;
                }
                this.sccNumbers[i] = this.currentSccNumber++;
                this.s2.pop();
            }
            this.s1.push(node);
            this.recupStack[0] = node;
            this.recupStack[1] = node;
            this.recupStack[2] = this.x[this.f[node]].getUB();
            this.mergeStack(node);
            i = 0;
            while (this.xyGraph[node][i] != -1) {
                if (this.dfsNodes[this.xyGraph[node][i]] == 0) {
                    this.dfsVisit(this.xyGraph[node][i]);
                }
                ++i;
            }
        }
        this.dfsNodes[node] = 2;
    }

    private boolean mergeStack(int node) {
        this.s2.peek(this.recupStack2);
        boolean flag = false;
        while (!this.s2.isEmpty() && this.y[this.recupStack2[1]].getUB() >= this.x[this.f[node]].getLB()) {
            flag = true;
            this.recupStack[0] = this.recupStack2[0];
            this.recupStack[1] = node;
            this.recupStack[2] = this.recupStack[2] > this.recupStack2[2] ? this.recupStack[2] : this.recupStack2[2];
            this.s2.pop();
            this.s2.peek(this.recupStack2);
        }
        this.s2.push(this.recupStack[0], this.recupStack[1], this.recupStack[2]);
        return flag;
    }

    private static class Stack2 {
        private final int[] roots;
        private final int[] rightMosts;
        private final int[] maxXs;
        private final int n;
        private int nbElts = 0;

        public Stack2(int _n) {
            this.n = _n;
            this.roots = new int[_n];
            this.rightMosts = new int[_n];
            this.maxXs = new int[_n];
        }

        public boolean push(int root, int rightMost, int maxX) {
            if (this.nbElts == this.n) {
                return false;
            }
            this.roots[this.nbElts] = root;
            this.rightMosts[this.nbElts] = rightMost;
            this.maxXs[this.nbElts] = maxX;
            ++this.nbElts;
            return true;
        }

        public boolean pop() {
            if (this.isEmpty()) {
                return false;
            }
            --this.nbElts;
            return true;
        }

        public boolean pop(int[] x) {
            if (this.isEmpty()) {
                return false;
            }
            --this.nbElts;
            x[0] = this.roots[this.nbElts];
            x[1] = this.rightMosts[this.nbElts];
            x[2] = this.maxXs[this.nbElts];
            return true;
        }

        public boolean peek(int[] x) {
            if (this.isEmpty()) {
                return false;
            }
            x[0] = this.roots[this.nbElts - 1];
            x[1] = this.rightMosts[this.nbElts - 1];
            x[2] = this.maxXs[this.nbElts - 1];
            return true;
        }

        public boolean isEmpty() {
            return this.nbElts == 0;
        }

        public void clear() {
            this.nbElts = 0;
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder();
            for (int i = 0; i < this.nbElts; ++i) {
                s2.append(" <").append(this.roots[i]).append(", ").append(this.rightMosts[i]).append(", ").append(this.maxXs[i]).append(">");
            }
            return s2.toString();
        }
    }
}

