/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (Geometry.class.isAssignableFrom(target)) {
            if (String.class.equals((Object)source)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        return new WKTReader2().read((String)source);
                    }
                };
            }
            if (Envelope.class.isAssignableFrom(source)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Envelope e2 = (Envelope)source;
                        GeometryFactory factory = new GeometryFactory();
                        return factory.createPolygon(factory.createLinearRing(new Coordinate[]{new Coordinate(e2.getMinX(), e2.getMinY()), new Coordinate(e2.getMaxX(), e2.getMinY()), new Coordinate(e2.getMaxX(), e2.getMaxY()), new Coordinate(e2.getMinX(), e2.getMaxY()), new Coordinate(e2.getMinX(), e2.getMinY())}), null);
                    }
                };
            }
        }
        if (Geometry.class.isAssignableFrom(source)) {
            if (Envelope.class.equals((Object)target)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Geometry geometry = (Geometry)source;
                        Envelope envelope = geometry.getEnvelopeInternal();
                        if (geometry.getUserData() instanceof CoordinateReferenceSystem) {
                            return new ReferencedEnvelope(envelope, (CoordinateReferenceSystem)geometry.getUserData());
                        }
                        return envelope;
                    }
                };
            }
            if (String.class.equals((Object)target)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Geometry geometry = (Geometry)source;
                        return geometry.toText();
                    }
                };
            }
        }
        return null;
    }
}

