/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class Sinusoidal
extends MapProjection {
    private static final long serialVersionUID = 7528023862968814860L;
    private static final double EPS10 = 1.0E-10;
    private static final double HALFPI = 1.5707963267948966;

    protected Sinusoidal(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
        double y;
        double x;
        if (this.isSpherical) {
            x = lam * Math.cos(phi);
            y = phi;
        } else {
            double s2 = Math.sin(phi);
            double c2 = Math.cos(phi);
            y = this.mlfn(phi, Math.sin(phi), Math.cos(phi));
            x = lam * c2 / Math.sqrt(1.0 - this.excentricitySquared * s2 * s2);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double lam;
        double phi;
        if (this.isSpherical) {
            phi = y;
            lam = x / Math.cos(y);
        } else {
            phi = this.inv_mlfn(y);
            double s2 = Math.abs(phi);
            double diff = Math.abs(s2 - 1.5707963267948966);
            if (diff < 1.0E-10) {
                lam = 0.0;
            } else if (s2 < 1.5707963267948966) {
                s2 = Math.sin(phi);
                lam = x * Math.sqrt(1.0 - this.excentricitySquared * s2 * s2) / Math.cos(phi) % Math.PI;
            } else {
                throw new ProjectionException(168);
            }
        }
        if (ptDst != null) {
            ptDst.setLocation(lam, phi);
            return ptDst;
        }
        return new Point2D.Double(lam, phi);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 8374488793001927036L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Sinusoidal"), new NamedIdentifier(Citations.ESRI, "Sinusoidal")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new Sinusoidal(parameters);
        }
    }
}

