/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.util.Classes;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class CRSUtilities {
    private CRSUtilities() {
    }

    public static int dimensionColinearWith(CoordinateSystem cs, CoordinateSystemAxis axis) {
        int candidate = -1;
        int dimension = cs.getDimension();
        AxisDirection direction = axis.getDirection().absolute();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis xi = cs.getAxis(i);
            if (!direction.equals(xi.getDirection().absolute())) continue;
            candidate = i;
            if (axis.equals(xi)) break;
        }
        return candidate;
    }

    public static Unit<?> getUnit(CoordinateSystem cs) {
        Unit<?> unit = null;
        int i = cs.getDimension();
        while (--i >= 0) {
            Unit<?> candidate = cs.getAxis(i).getUnit();
            if (candidate == null) continue;
            if (unit == null) {
                unit = candidate;
                continue;
            }
            if (unit.equals(candidate)) continue;
            return null;
        }
        return unit;
    }

    private static List<CoordinateReferenceSystem> getComponents(CoordinateReferenceSystem crs) {
        List<CoordinateReferenceSystem> components;
        if (crs instanceof CompoundCRS && !(components = ((CompoundCRS)crs).getCoordinateReferenceSystems()).isEmpty()) {
            return components;
        }
        return null;
    }

    public static int getDimensionOf(CoordinateReferenceSystem crs, Class<? extends CoordinateReferenceSystem> type) throws IllegalArgumentException {
        if (type.isAssignableFrom(crs.getClass())) {
            return 0;
        }
        List<CoordinateReferenceSystem> c2 = CRSUtilities.getComponents(crs);
        if (c2 != null) {
            int offset = 0;
            for (CoordinateReferenceSystem ci : c2) {
                int index = CRSUtilities.getDimensionOf(ci, type);
                if (index >= 0) {
                    return index + offset;
                }
                offset += ci.getCoordinateSystem().getDimension();
            }
        }
        return -1;
    }

    public static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem crs, int lower, int upper) {
        int dimension = crs.getCoordinateSystem().getDimension();
        if (lower < 0 || lower > upper || upper > dimension) {
            throw new IndexOutOfBoundsException(Errors.format(79, lower < 0 ? lower : upper));
        }
        while (lower != 0 || upper != dimension) {
            List<CoordinateReferenceSystem> c2 = CRSUtilities.getComponents(crs);
            if (c2 == null) {
                return null;
            }
            Iterator<CoordinateReferenceSystem> it = c2.iterator();
            while (it.hasNext() && lower >= (dimension = (crs = it.next()).getCoordinateSystem().getDimension())) {
                lower -= dimension;
                upper -= dimension;
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem getCRS2D(CoordinateReferenceSystem crs) throws TransformException {
        if (crs != null) {
            while (crs.getCoordinateSystem().getDimension() != 2) {
                List<CoordinateReferenceSystem> c2 = CRSUtilities.getComponents(crs);
                if (c2 == null) {
                    throw new TransformException(Errors.format(29, crs.getName()));
                }
                crs = c2.get(0);
            }
        }
        return crs;
    }

    public static Map<String, ?> changeDimensionInName(IdentifiedObject object, String search, String replace) {
        StringBuilder name = new StringBuilder(object.getName().getCode());
        int last = name.length() - search.length();
        boolean append = true;
        int i = name.lastIndexOf(search);
        while (i >= 0) {
            if (!(i != 0 && Character.isLetterOrDigit(name.charAt(i - 1)) || i != last && Character.isLetterOrDigit(i + search.length()))) {
                name.replace(i, i + search.length(), replace);
                i = name.indexOf(". ", i);
                if (i >= 0) {
                    name.setLength(i + 1);
                }
                append = false;
                break;
            }
            i = name.lastIndexOf(search, i - 1);
        }
        if (append) {
            if (name.indexOf(" ") >= 0) {
                name.append(" (").append(replace).append(')');
            } else {
                name.append('_').append(replace);
            }
        }
        return Collections.singletonMap("name", name.toString());
    }

    public static Datum getDatum(CoordinateReferenceSystem crs) {
        return crs instanceof SingleCRS ? ((SingleCRS)crs).getDatum() : null;
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem crs) {
        while (!(crs instanceof GeographicCRS)) {
            List<CoordinateReferenceSystem> c2 = CRSUtilities.getComponents(crs);
            if (c2 == null) {
                return null;
            }
            crs = c2.get(0);
        }
        return ((GeographicCRS)crs).getDatum().getEllipsoid();
    }

    public static GeographicCRS getStandardGeographicCRS2D(CoordinateReferenceSystem crs) {
        while (crs instanceof GeneralDerivedCRS) {
            crs = ((GeneralDerivedCRS)crs).getBaseCRS();
        }
        if (!(crs instanceof SingleCRS)) {
            return DefaultGeographicCRS.WGS84;
        }
        Datum datum = ((SingleCRS)crs).getDatum();
        if (!(datum instanceof GeodeticDatum)) {
            return DefaultGeographicCRS.WGS84;
        }
        GeodeticDatum geoDatum = (GeodeticDatum)datum;
        if (geoDatum.getPrimeMeridian().getGreenwichLongitude() != 0.0) {
            geoDatum = new DefaultGeodeticDatum(geoDatum.getName().getCode(), geoDatum.getEllipsoid(), (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
        } else if (crs instanceof GeographicCRS && CRS.equalsIgnoreMetadata(DefaultEllipsoidalCS.GEODETIC_2D, crs.getCoordinateSystem())) {
            return (GeographicCRS)crs;
        }
        return new DefaultGeographicCRS(crs.getName().getCode(), geoDatum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
    }

    public static DirectPosition deltaTransform(MathTransform transform, DirectPosition origin, DirectPosition source) throws TransformException {
        int i;
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        DirectPosition P1 = new GeneralDirectPosition(sourceDim);
        DirectPosition P2 = new GeneralDirectPosition(sourceDim);
        for (i = 0; i < sourceDim; ++i) {
            double c2 = origin.getOrdinate(i);
            double d2 = source.getOrdinate(i) * 0.5;
            P1.setOrdinate(i, c2 - d2);
            P2.setOrdinate(i, c2 + d2);
        }
        P1 = transform.transform(P1, sourceDim == targetDim ? P1 : null);
        P2 = transform.transform(P2, sourceDim == targetDim ? P2 : null);
        for (i = 0; i < targetDim; ++i) {
            P2.setOrdinate(i, P2.getOrdinate(i) - P1.getOrdinate(i));
        }
        return P2;
    }

    public static Point2D deltaTransform(MathTransform2D transform, Point2D origin, Point2D source, Point2D dest) throws TransformException {
        if (transform instanceof AffineTransform) {
            return ((AffineTransform)((Object)transform)).deltaTransform(source, dest);
        }
        double ox = origin.getX();
        double oy = origin.getY();
        double dx = source.getX() * 0.5;
        double dy = source.getY() * 0.5;
        Point2D P1 = new Point2D.Double(ox - dx, oy - dy);
        Point2D P2 = new Point2D.Double(ox + dx, oy + dy);
        P1 = transform.transform(P1, P1);
        P2 = transform.transform(P2, P2);
        if (dest == null) {
            dest = P2;
        }
        dest.setLocation(P2.getX() - P1.getX(), P2.getY() - P1.getY());
        return dest;
    }

    public static String toWGS84String(CoordinateReferenceSystem crs, Rectangle2D bounds) {
        Exception exception;
        StringBuffer buffer = new StringBuffer();
        SingleCRS crs2D = CRS.getHorizontalCRS(crs);
        if (crs2D == null) {
            exception = new UnsupportedOperationException(Errors.format(31, crs.getName()));
        } else {
            try {
                if (!CRS.equalsIgnoreMetadata(DefaultGeographicCRS.WGS84, crs2D)) {
                    CoordinateOperation op = ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation(crs2D, DefaultGeographicCRS.WGS84);
                    bounds = CRS.transform(op, bounds, null);
                }
                AngleFormat fmt = new AngleFormat("DD\u00b0MM.m'");
                fmt.format(new Latitude(bounds.getMinY()), buffer, null).append('-');
                fmt.format(new Latitude(bounds.getMaxY()), buffer, null).append(' ');
                fmt.format(new Longitude(bounds.getMinX()), buffer, null).append('-');
                fmt.format(new Longitude(bounds.getMaxX()), buffer, null);
                return buffer.toString();
            }
            catch (TransformException e2) {
                exception = e2;
            }
            catch (FactoryException e3) {
                exception = e3;
            }
        }
        buffer.append(Classes.getShortClassName(exception));
        String message = exception.getLocalizedMessage();
        if (message != null) {
            buffer.append(": ").append(message);
        }
        return buffer.toString();
    }
}

