/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.OHLCChartBuilder;
import org.knowm.xchart.OHLCSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.AxisPair;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_OHLC;
import org.knowm.xchart.internal.chartpart.Plot_OHLC;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.OHLCStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.theme.Theme;

public class OHLCChart
extends Chart<OHLCStyler, OHLCSeries> {
    public OHLCChart(int width, int height) {
        super(width, height, new OHLCStyler());
        this.axisPair = new AxisPair<OHLCStyler, OHLCSeries>(this);
        this.plot = new Plot_OHLC<OHLCStyler, OHLCSeries>(this);
        this.legend = new Legend_OHLC<OHLCStyler, OHLCSeries>(this);
    }

    public OHLCChart(int width, int height, Theme theme) {
        this(width, height);
        ((OHLCStyler)this.styler).setTheme(theme);
        ((OHLCStyler)this.styler).setToolTipBackgroundColor(new Color(210, 210, 210));
        ((OHLCStyler)this.styler).setToolTipFont(new Font("SansSerif", 0, 12));
    }

    public OHLCChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public OHLCChart(OHLCChartBuilder chartBuilder) {
        this(chartBuilder.width, chartBuilder.height, chartBuilder.chartTheme);
        this.setTitle(chartBuilder.title);
        this.setXAxisTitle(chartBuilder.xAxisTitle);
        this.setYAxisTitle(chartBuilder.yAxisTitle);
    }

    public OHLCSeries addSeries(String seriesName, float[] openData, float[] highData, float[] lowData, float[] closeData) {
        return this.addSeries(seriesName, (float[])null, openData, highData, lowData, closeData);
    }

    public OHLCSeries addSeries(String seriesName, float[] xData, float[] openData, float[] highData, float[] lowData, float[] closeData) {
        return this.addSeries(seriesName, Utils.getDoubleArrayFromFloatArray(xData), Utils.getDoubleArrayFromFloatArray(openData), Utils.getDoubleArrayFromFloatArray(highData), Utils.getDoubleArrayFromFloatArray(lowData), Utils.getDoubleArrayFromFloatArray(closeData), null, Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, float[] xData, float[] openData, float[] highData, float[] lowData, float[] closeData, float[] volumeData) {
        return this.addSeries(seriesName, Utils.getDoubleArrayFromFloatArray(xData), Utils.getDoubleArrayFromFloatArray(openData), Utils.getDoubleArrayFromFloatArray(highData), Utils.getDoubleArrayFromFloatArray(lowData), Utils.getDoubleArrayFromFloatArray(closeData), Utils.getLongArrayFromFloatArray(volumeData), Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, int[] openData, int[] highData, int[] lowData, int[] closeData) {
        return this.addSeries(seriesName, (int[])null, openData, highData, lowData, closeData);
    }

    public OHLCSeries addSeries(String seriesName, int[] xData, int[] openData, int[] highData, int[] lowData, int[] closeData) {
        return this.addSeries(seriesName, Utils.getDoubleArrayFromIntArray(xData), Utils.getDoubleArrayFromIntArray(openData), Utils.getDoubleArrayFromIntArray(highData), Utils.getDoubleArrayFromIntArray(lowData), Utils.getDoubleArrayFromIntArray(closeData), null, Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, int[] xData, int[] openData, int[] highData, int[] lowData, int[] closeData, int[] volumeData) {
        return this.addSeries(seriesName, Utils.getDoubleArrayFromIntArray(xData), Utils.getDoubleArrayFromIntArray(openData), Utils.getDoubleArrayFromIntArray(highData), Utils.getDoubleArrayFromIntArray(lowData), Utils.getDoubleArrayFromIntArray(closeData), Utils.getLongArrayFromIntArray(volumeData), Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, List<?> xData, List<? extends Number> openData, List<? extends Number> highData, List<? extends Number> lowData, List<? extends Number> closeData) {
        Series.DataType dataType = this.getDataType(xData);
        switch (dataType) {
            case Date: {
                return this.addSeries(seriesName, Utils.getDoubleArrayFromDateList(xData), Utils.getDoubleArrayFromNumberList(openData), Utils.getDoubleArrayFromNumberList(highData), Utils.getDoubleArrayFromNumberList(lowData), Utils.getDoubleArrayFromNumberList(closeData), null, Series.DataType.Date);
            }
        }
        return this.addSeries(seriesName, Utils.getDoubleArrayFromNumberList(xData), Utils.getDoubleArrayFromNumberList(openData), Utils.getDoubleArrayFromNumberList(highData), Utils.getDoubleArrayFromNumberList(lowData), Utils.getDoubleArrayFromNumberList(closeData), null, Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, List<?> xData, List<? extends Number> openData, List<? extends Number> highData, List<? extends Number> lowData, List<? extends Number> closeData, List<? extends Number> volumeData) {
        Series.DataType dataType = this.getDataType(xData);
        switch (dataType) {
            case Date: {
                return this.addSeries(seriesName, Utils.getDoubleArrayFromDateList(xData), Utils.getDoubleArrayFromNumberList(openData), Utils.getDoubleArrayFromNumberList(highData), Utils.getDoubleArrayFromNumberList(lowData), Utils.getDoubleArrayFromNumberList(closeData), Utils.getLongArrayFromNumberList(volumeData), Series.DataType.Date);
            }
        }
        return this.addSeries(seriesName, Utils.getDoubleArrayFromNumberList(xData), Utils.getDoubleArrayFromNumberList(openData), Utils.getDoubleArrayFromNumberList(highData), Utils.getDoubleArrayFromNumberList(lowData), Utils.getDoubleArrayFromNumberList(closeData), Utils.getLongArrayFromNumberList(volumeData), Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, List<? extends Number> openData, List<? extends Number> highData, List<? extends Number> lowData, List<? extends Number> closeData) {
        return this.addSeries(seriesName, null, openData, highData, lowData, closeData);
    }

    public OHLCSeries addSeries(String seriesName, int[] xData, int[] yData) {
        return this.addSeries(seriesName, Utils.getDoubleArrayFromIntArray(xData), Utils.getDoubleArrayFromIntArray(yData), Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, float[] xData, float[] yData) {
        return this.addSeries(seriesName, Utils.getDoubleArrayFromFloatArray(xData), Utils.getDoubleArrayFromFloatArray(yData), Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, double[] xData, double[] yData) {
        return this.addSeries(seriesName, xData, yData, Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData) {
        Series.DataType dataType = this.getDataType(xData);
        switch (dataType) {
            case Date: {
                return this.addSeries(seriesName, Utils.getDoubleArrayFromDateList(xData), Utils.getDoubleArrayFromNumberList(yData), this.getDataType(xData));
            }
        }
        return this.addSeries(seriesName, Utils.getDoubleArrayFromNumberList(xData), Utils.getDoubleArrayFromNumberList(yData), this.getDataType(xData));
    }

    private Series.DataType getDataType(List<?> data) {
        Series.DataType axisType;
        if (data == null || data.isEmpty()) {
            return Series.DataType.Number;
        }
        Iterator<?> itr = data.iterator();
        Object dataPoint = itr.next();
        if (dataPoint instanceof Number) {
            axisType = Series.DataType.Number;
        } else if (dataPoint instanceof Date) {
            axisType = Series.DataType.Date;
        } else {
            throw new IllegalArgumentException("Series data must be either Number or Date type!!!");
        }
        return axisType;
    }

    public OHLCSeries addSeries(String seriesName, double[] xData, double[] openData, double[] highData, double[] lowData, double[] closeData) {
        return this.addSeries(seriesName, xData, openData, highData, lowData, closeData, null, Series.DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, double[] openData, double[] highData, double[] lowData, double[] closeData) {
        return this.addSeries(seriesName, null, openData, highData, lowData, closeData);
    }

    public OHLCSeries addSeries(String seriesName, double[] xData, double[] openData, double[] highData, double[] lowData, double[] closeData, long[] volumeData) {
        return this.addSeries(seriesName, xData, openData, highData, lowData, closeData, volumeData, Series.DataType.Number);
    }

    private OHLCSeries addSeries(String seriesName, double[] xData, double[] openData, double[] highData, double[] lowData, double[] closeData, long[] volumeData, Series.DataType dataType) {
        double[] xDataToUse;
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        this.sanityCheck(seriesName, openData, highData, lowData, closeData, volumeData);
        if (xData != null) {
            this.checkDataLengths(seriesName, "X-Axis", "Close", xData, closeData);
            xDataToUse = xData;
        } else {
            xDataToUse = Utils.getGeneratedDataAsArray(closeData.length);
        }
        OHLCSeries series = new OHLCSeries(seriesName, xDataToUse, openData, highData, lowData, closeData, volumeData, dataType);
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private OHLCSeries addSeries(String seriesName, double[] xData, double[] yData, Series.DataType dataType) {
        double[] xDataToUse;
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        if (xData != null) {
            this.checkDataLengths(seriesName, "X-Axis", "Y-Axis", xData, yData);
            xDataToUse = xData;
        } else {
            xDataToUse = Utils.getGeneratedDataAsArray(yData.length);
        }
        OHLCSeries series = new OHLCSeries(seriesName, xDataToUse, yData, dataType);
        this.seriesMap.put(seriesName, series);
        return series;
    }

    public OHLCSeries updateOHLCSeries(String seriesName, List<?> newXData, List<? extends Number> newOpenData, List<? extends Number> newHighData, List<? extends Number> newLowData, List<? extends Number> newCloseData) {
        Series.DataType dataType = this.getDataType(newXData);
        switch (dataType) {
            case Date: {
                return this.updateOHLCSeries(seriesName, Utils.getDoubleArrayFromDateList(newXData), Utils.getDoubleArrayFromNumberList(newOpenData), Utils.getDoubleArrayFromNumberList(newHighData), Utils.getDoubleArrayFromNumberList(newLowData), Utils.getDoubleArrayFromNumberList(newCloseData));
            }
        }
        return this.updateOHLCSeries(seriesName, Utils.getDoubleArrayFromNumberList(newXData), Utils.getDoubleArrayFromNumberList(newOpenData), Utils.getDoubleArrayFromNumberList(newHighData), Utils.getDoubleArrayFromNumberList(newLowData), Utils.getDoubleArrayFromNumberList(newCloseData));
    }

    public OHLCSeries updateOHLCSeries(String seriesName, List<?> newXData, List<? extends Number> newOpenData, List<? extends Number> newHighData, List<? extends Number> newLowData, List<? extends Number> newCloseData, List<? extends Number> volumeData) {
        Series.DataType dataType = this.getDataType(newXData);
        switch (dataType) {
            case Date: {
                return this.updateOHLCSeries(seriesName, Utils.getDoubleArrayFromDateList(newXData), Utils.getDoubleArrayFromNumberList(newOpenData), Utils.getDoubleArrayFromNumberList(newHighData), Utils.getDoubleArrayFromNumberList(newLowData), Utils.getDoubleArrayFromNumberList(newCloseData), Utils.getLongArrayFromNumberList(volumeData));
            }
        }
        return this.updateOHLCSeries(seriesName, Utils.getDoubleArrayFromNumberList(newXData), Utils.getDoubleArrayFromNumberList(newOpenData), Utils.getDoubleArrayFromNumberList(newHighData), Utils.getDoubleArrayFromNumberList(newLowData), Utils.getDoubleArrayFromNumberList(newCloseData), Utils.getLongArrayFromNumberList(volumeData));
    }

    public OHLCSeries updateOHLCSeries(String seriesName, double[] newXData, double[] newOpenData, double[] newHighData, double[] newLowData, double[] newCloseData) {
        return this.updateOHLCSeries(seriesName, newXData, newOpenData, newHighData, newLowData, newCloseData, null);
    }

    public OHLCSeries updateOHLCSeries(String seriesName, double[] newXData, double[] newOpenData, double[] newHighData, double[] newLowData, double[] newCloseData, long[] newVolumeData) {
        double[] xDataToUse;
        this.sanityCheck(seriesName, newOpenData, newHighData, newLowData, newCloseData, newVolumeData);
        Map seriesMap = this.getSeriesMap();
        OHLCSeries series = (OHLCSeries)seriesMap.get(seriesName);
        if (series == null) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< not found!!!");
        }
        if (newXData != null) {
            this.checkDataLengths(seriesName, "X-Axis", "Close", newXData, newCloseData);
            xDataToUse = newXData;
        } else {
            xDataToUse = Utils.getGeneratedDataAsArray(newCloseData.length);
        }
        series.replaceData(xDataToUse, newOpenData, newHighData, newLowData, newCloseData, newVolumeData);
        return series;
    }

    public OHLCSeries updateOHLCSeries(String seriesName, List<?> newXData, List<? extends Number> newYData) {
        Series.DataType dataType = this.getDataType(newXData);
        switch (dataType) {
            case Date: {
                return this.updateOHLCSeries(seriesName, Utils.getDoubleArrayFromDateList(newXData), Utils.getDoubleArrayFromNumberList(newYData));
            }
        }
        return this.updateOHLCSeries(seriesName, Utils.getDoubleArrayFromNumberList(newXData), Utils.getDoubleArrayFromNumberList(newYData));
    }

    public OHLCSeries updateOHLCSeries(String seriesName, double[] newXData, double[] newYData) {
        double[] xDataToUse;
        Map seriesMap = this.getSeriesMap();
        OHLCSeries series = (OHLCSeries)seriesMap.get(seriesName);
        if (series == null) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< not found!!!");
        }
        if (newXData != null) {
            this.checkDataLengths(seriesName, "newXData", "newYData", newXData, newYData);
            xDataToUse = newXData;
        } else {
            xDataToUse = Utils.getGeneratedDataAsArray(newYData.length);
        }
        series.replaceData(xDataToUse, newYData);
        return series;
    }

    private void checkData(String seriesName, String dataName, double[] data) {
        if (data == null) {
            throw new IllegalArgumentException(dataName + " data cannot be null!!! >" + seriesName);
        }
        if (data.length == 0) {
            throw new IllegalArgumentException(dataName + " data cannot be empty!!! >" + seriesName);
        }
    }

    private void checkDataLengths(String seriesName, String data1Name, String data2Name, double[] data1, double[] data2) {
        if (data1.length != data2.length) {
            throw new IllegalArgumentException(data1Name + " and " + data2Name + " sizes are not the same!!! >" + seriesName);
        }
    }

    private void sanityCheck(String seriesName, double[] openData, double[] highData, double[] lowData, double[] closeData, long[] volumeData) {
        this.checkData(seriesName, "Open", openData);
        this.checkData(seriesName, "High", highData);
        this.checkData(seriesName, "Low", lowData);
        this.checkData(seriesName, "Close", closeData);
        this.checkDataLengths(seriesName, "Open", "Close", openData, closeData);
        this.checkDataLengths(seriesName, "High", "Close", highData, closeData);
        this.checkDataLengths(seriesName, "Low", "Close", lowData, closeData);
        if (volumeData != null && volumeData.length != closeData.length) {
            throw new IllegalArgumentException("Volume and Close sizes are not the same!!! >" + seriesName);
        }
    }

    @Override
    public void paint(Graphics2D g2, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (OHLCSeries series : this.getSeriesMap().values()) {
            OHLCSeries.OHLCSeriesRenderStyle renderStyle = series.getOhlcSeriesRenderStyle();
            if (renderStyle != null) continue;
            series.setOhlcSeriesRenderStyle(((OHLCStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        this.paintBackground(g2);
        this.axisPair.paint(g2);
        this.plot.paint(g2);
        this.chartTitle.paint(g2);
        this.legend.paint(g2);
        this.annotations.forEach(x -> x.paint(g2));
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((OHLCStyler)this.getStyler()).getSeriesColors(), ((OHLCStyler)this.getStyler()).getSeriesMarkers(), ((OHLCStyler)this.getStyler()).getSeriesLines());
        for (OHLCSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getOhlcSeriesRenderStyle() == OHLCSeries.OHLCSeriesRenderStyle.Line && series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() == null) {
                series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getUpColor() == null) {
                series.setUpColor(new Color(19, 179, 70));
            }
            if (series.getDownColor() != null) continue;
            series.setDownColor(new Color(242, 39, 42));
        }
    }
}

