/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.measure.UnitConverter;
import tech.units.indriya.function.ConverterCompositionHandler;
import tech.uom.lib.common.function.Converter;
import tech.uom.lib.common.util.UnitComparator;

public abstract class AbstractConverter
implements UnitConverter,
Converter<Number, Number>,
Serializable,
Comparable<UnitConverter> {
    private static final long serialVersionUID = 5790242858468427131L;
    public static final AbstractConverter IDENTITY = new Identity();
    public static ConverterCompositionHandler UNIT_COMPOSITION_HANDLER = ConverterCompositionHandler.yieldingNormalForm();
    protected List<? extends UnitConverter> conversionSteps;

    protected AbstractConverter() {
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected abstract String transformationLiteral();

    public final String toString() {
        String converterName = this.getClass().getSimpleName();
        if (converterName.endsWith("Converter")) {
            converterName = converterName.substring(0, converterName.length() - "Converter".length());
        }
        if (this.isIdentity()) {
            return String.format("%s(IDENTITY)", converterName);
        }
        String transformationLiteral = this.transformationLiteral();
        if (transformationLiteral == null || transformationLiteral.length() == 0) {
            return String.format("%s", converterName);
        }
        return String.format("%s(%s)", converterName, transformationLiteral);
    }

    protected abstract AbstractConverter inverseWhenNotIdentity();

    @Override
    public final AbstractConverter inverse() {
        if (this.isIdentity()) {
            return this;
        }
        return this.inverseWhenNotIdentity();
    }

    protected abstract boolean canReduceWith(AbstractConverter var1);

    protected AbstractConverter reduce(AbstractConverter that) {
        throw new IllegalStateException(String.format("Concrete UnitConverter '%s' does not implement reduce(...).", this));
    }

    @Override
    public final UnitConverter concatenate(UnitConverter converter) {
        Objects.requireNonNull(converter, "Cannot compose with converter that is null.");
        if (converter instanceof AbstractConverter) {
            AbstractConverter other = (AbstractConverter)converter;
            return UNIT_COMPOSITION_HANDLER.compose(this, other, AbstractConverter::canReduceWith, AbstractConverter::reduce);
        }
        if (converter.isIdentity()) {
            return this;
        }
        if (this.isIdentity()) {
            return converter;
        }
        return new Pair(this, converter);
    }

    @Override
    public final List<? extends UnitConverter> getConversionSteps() {
        if (this.conversionSteps != null) {
            return this.conversionSteps;
        }
        if (this instanceof Pair) {
            this.conversionSteps = ((Pair)this).createConversionSteps();
            return this.conversionSteps;
        }
        this.conversionSteps = Collections.singletonList(this);
        return this.conversionSteps;
    }

    protected abstract Number convertWhenNotIdentity(Number var1);

    @Override
    public final double convert(double value) {
        if (this.isIdentity()) {
            return value;
        }
        return this.convertWhenNotIdentity(value).doubleValue();
    }

    @Override
    public final Number convert(Number value) {
        if (this.isIdentity()) {
            return value;
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return this.convertWhenNotIdentity(value);
    }

    public static final class Pair
    extends AbstractConverter
    implements Serializable {
        private static final Comparator unitComparator = new UnitComparator();
        private static final long serialVersionUID = -123063827821728331L;
        private final UnitConverter left;
        private final UnitConverter right;

        public Pair(UnitConverter left, UnitConverter right) {
            if (left == null || right == null) {
                throw new IllegalArgumentException("Converters cannot be null");
            }
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isLinear() {
            return this.left.isLinear() && this.right.isLinear();
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        protected List<? extends UnitConverter> createConversionSteps() {
            List<? extends UnitConverter> leftSteps = this.left.getConversionSteps();
            List<? extends UnitConverter> rightSteps = this.right.getConversionSteps();
            ArrayList<UnitConverter> steps = new ArrayList<UnitConverter>(leftSteps.size() + rightSteps.size());
            steps.addAll(leftSteps);
            steps.addAll(rightSteps);
            return steps;
        }

        @Override
        public Pair inverseWhenNotIdentity() {
            return new Pair(this.right.inverse(), this.left.inverse());
        }

        @Override
        protected Number convertWhenNotIdentity(Number value) {
            if (!(this.left instanceof AbstractConverter)) {
                throw this.requiresAbstractConverter();
            }
            if (!(this.right instanceof AbstractConverter)) {
                throw this.requiresAbstractConverter();
            }
            AbstractConverter absLeft = (AbstractConverter)this.left;
            AbstractConverter absRight = (AbstractConverter)this.right;
            return absLeft.convertWhenNotIdentity(absRight.convertWhenNotIdentity(value));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public UnitConverter getLeft() {
            return this.left;
        }

        public UnitConverter getRight() {
            return this.right;
        }

        @Override
        public int compareTo(UnitConverter obj) {
            if (this == obj) {
                return 0;
            }
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                return Objects.compare(this.left, that.left, unitComparator) + Objects.compare(this.right, that.right, unitComparator);
            }
            return -1;
        }

        @Override
        protected String transformationLiteral() {
            return String.format("%s", this.getConversionSteps().stream().map(Object::toString).collect(Collectors.joining(" \u25cb ")));
        }

        @Override
        protected boolean canReduceWith(AbstractConverter that) {
            return false;
        }

        private IllegalArgumentException requiresAbstractConverter() {
            return new IllegalArgumentException("can only handle instances of AbstractConverter");
        }
    }

    private static final class Identity
    extends AbstractConverter {
        private static final long serialVersionUID = -4460463244427587361L;

        private Identity() {
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        protected Number convertWhenNotIdentity(Number value) {
            throw this.unreachable();
        }

        @Override
        public boolean equals(Object cvtr) {
            return cvtr instanceof Identity;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean isLinear() {
            return true;
        }

        @Override
        public int compareTo(UnitConverter o) {
            if (o instanceof Identity) {
                return 0;
            }
            return -1;
        }

        @Override
        protected boolean canReduceWith(AbstractConverter that) {
            throw this.unreachable();
        }

        @Override
        protected AbstractConverter reduce(AbstractConverter that) {
            throw this.unreachable();
        }

        @Override
        protected AbstractConverter inverseWhenNotIdentity() {
            throw this.unreachable();
        }

        @Override
        protected String transformationLiteral() {
            return null;
        }

        private IllegalStateException unreachable() {
            return new IllegalStateException("code was reached, that is expected unreachable");
        }
    }
}

