/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.io;

import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.io.NexusImporter;
import dr.evolution.tree.Tree;
import dr.util.Identifiable;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class TreeTrace
implements Identifiable {
    private ArrayList<Tree> trees = new ArrayList();
    private int minState;
    private int stepSize;
    private String id;

    public int getTreeCount(int n) {
        int n2 = (n - this.minState) / this.stepSize;
        if (n2 < 0) {
            n2 = 0;
        }
        return this.trees.size() - n2;
    }

    public Tree getTree(int n, int n2) {
        int n3 = (n2 - this.minState) / this.stepSize;
        if (n3 < 0) {
            n3 = 0;
        }
        return this.trees.get(n + n3);
    }

    public void add(Tree tree) {
        this.trees.add(tree);
    }

    public void setMinimumState(int n) {
        this.minState = n;
    }

    public int getMinimumState() {
        return this.minState;
    }

    public void setStepSize(int n) {
        this.stepSize = n;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public int getMaximumState() {
        return (this.trees.size() - 1) * this.stepSize + this.minState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public static TreeTrace loadTreeTrace(Reader reader) throws IOException, Importer.ImportException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        TreeTrace treeTrace = new TreeTrace();
        Tree tree = null;
        int n = -1;
        int n2 = 0;
        String string = bufferedReader.readLine();
        if (string.toUpperCase().startsWith("#NEXUS")) {
            NexusImporter nexusImporter = new NexusImporter(bufferedReader);
            Tree[] treeArray = nexusImporter.importTrees(null);
            if (treeArray.length < 2) {
                throw new Importer.ImportException("Less than two trees in the trace file");
            }
            String string2 = treeArray[0].getId();
            String string3 = treeArray[1].getId();
            n = TreeTrace.getStateNumber(string2);
            n2 = TreeTrace.getStateNumber(string3) - n;
            for (Tree tree2 : treeArray) {
                treeTrace.add(tree2);
            }
        } else {
            NewickImporter newickImporter = new NewickImporter(bufferedReader);
            while (true) {
                Tree tree3;
                int n3;
                block11: {
                    n3 = 0;
                    try {
                        n3 = newickImporter.readInteger();
                        tree3 = newickImporter.importTree(tree);
                        if (tree != null) break block11;
                        tree = tree3;
                    }
                    catch (Importer.ImportException importException) {
                        System.out.println("Error reading tree for state " + n3);
                        throw importException;
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                }
                if (n == -1) {
                    n = n3;
                } else if (n2 == 0) {
                    n2 = n3 - n;
                }
                treeTrace.add(tree3);
            }
        }
        treeTrace.setMinimumState(n);
        treeTrace.setStepSize(n2);
        return treeTrace;
    }

    private static int getStateNumber(String string) throws Importer.ImportException {
        try {
            if (string.indexOf(95) != -1) {
                return Integer.parseInt(string.substring(string.indexOf(95) + 1));
            }
            if (string.indexOf(46) != -1) {
                int n = Integer.parseInt(string.substring(string.indexOf(46) + 1));
                if (n == 1) {
                    n = 0;
                }
                return n;
            }
            throw new NumberFormatException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new Importer.ImportException("Bad state number in tree label '" + string + "', the state must be preceded by an underscore(_).");
        }
    }
}

