/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.alignment.PatternList;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.LatentTruncation;
import dr.evomodel.continuous.SoftThresholdLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.Distribution;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class IntervalLatentLiabilityLikelihood
extends AbstractModelLikelihood
implements LatentTruncation,
Citable,
SoftThresholdLikelihood {
    public static final String LATENT_LIABILITY_LIKELIHOOD = "intervalLatentLiabilityLikelihood";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String TIP_TRAIT = "tipTrait";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(AbstractMultivariateTraitLikelihood.class, "The model for the latent random variables"), new ElementRule("tipTrait", CompoundParameter.class, "The parameter of tip locations from the tree"), new ElementRule(TreeModel.class, "The tree model")};

        @Override
        public String getParserName() {
            return IntervalLatentLiabilityLikelihood.LATENT_LIABILITY_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(AbstractMultivariateTraitLikelihood.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            CompoundParameter compoundParameter = (CompoundParameter)xMLObject.getElementFirstChild(TIP_TRAIT);
            int n = treeModel.getTaxonCount();
            int n2 = abstractMultivariateTraitLikelihood.getNumData();
            int n3 = abstractMultivariateTraitLikelihood.getDimTrait();
            if (compoundParameter.getDimension() != n * n2 * n3) {
                throw new XMLParseException("Tip trait parameter is wrong dimension in latent liability model");
            }
            return new IntervalLatentLiabilityLikelihood(treeModel, compoundParameter);
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a latent liability model on multivariate-binary trait data";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return IntervalLatentLiabilityLikelihood.class;
        }
    };
    private final LatentTruncation.Delegate normalizationDelegate = new LatentTruncation.Delegate(){

        @Override
        protected double computeNormalizationConstant(Distribution distribution) {
            double d = 0.0;
            for (long l : IntervalLatentLiabilityLikelihood.this.tipData) {
                d += Math.log(distribution.cdf((double)l + 0.5) - distribution.cdf((double)l - 0.5));
            }
            return -d;
        }
    };
    private TreeModel treeModel;
    private PatternList patternList;
    private CompoundParameter tipTraitParameter;
    private long[] tipData;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private double storedLogLikelihood;
    private static final boolean DEBUG = false;
    private double pathParameter = 1.0;

    public IntervalLatentLiabilityLikelihood(TreeModel treeModel, CompoundParameter compoundParameter) {
        super(LATENT_LIABILITY_LIKELIHOOD);
        this.treeModel = treeModel;
        this.patternList = null;
        this.tipTraitParameter = compoundParameter;
        this.addVariable(compoundParameter);
        this.setTipDataValuesForAllNodes();
        for (int i = 0; i < compoundParameter.getParameterCount(); ++i) {
            Parameter parameter = compoundParameter.getParameter(i);
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, parameter.getDimension()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing a unit interval latent liability likelihood model:\n");
        stringBuilder.append("\tPlease cite:\n").append(Citable.Utils.getCitationString(this));
        Logger.getLogger("dr.evomodel.continuous").info(stringBuilder.toString());
    }

    private void setTipDataValuesForAllNodes() {
        System.err.println(this.tipTraitParameter.getParameterCount());
        System.err.println(this.tipTraitParameter.getDimension());
        if (this.tipData == null) {
            this.tipData = new long[this.tipTraitParameter.getDimension()];
        }
        for (int i = 0; i < this.tipData.length; ++i) {
            this.tipData[i] = Math.round(this.tipTraitParameter.getParameterValue(i));
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
    }

    protected double computeLogLikelihood() {
        int n;
        int n2 = 1;
        for (n = 0; n < this.tipData.length && n2 != 0; ++n) {
            double d = this.tipTraitParameter.getParameterValue(n);
            long l = Math.round(d);
            n2 = l == this.tipData[n] ? 1 : 0;
        }
        n = 1;
        for (int i = 0; i < this.treeModel.getExternalNodeCount() && n != 0; ++i) {
            if (this.validTraitForTip(i)) continue;
            n = 0;
        }
        if (n2 != n) {
            throw new RuntimeException("Error in computing validity of tips values");
        }
        if (n2 != 0) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean validTraitForTip(int n) {
        boolean bl = true;
        Parameter parameter = this.tipTraitParameter.getParameter(n);
        int n2 = parameter.getDimension() * n;
        for (int i = 0; i < parameter.getDimension() && bl; ++i) {
            double d = parameter.getParameterValue(i);
            long l = Math.round(d);
            bl = l == this.tipData[i + n2];
        }
        return bl;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Intervaled latent liability model";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        arrayList.add(CommonCitations.CYBIS_2015_ASSESSING);
        return arrayList;
    }

    @Override
    public double getNormalizationConstant(Distribution distribution) {
        return this.normalizationDelegate.getNormalizationConstant(distribution);
    }

    @Override
    public void setPathParameter(double d) {
        this.pathParameter = d;
    }

    @Override
    public double getLikelihoodCorrection() {
        return 0.0;
    }
}

