/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.math.EmpiricalBayesPoissonSmoother;
import dr.stats.DiscreteStatistics;
import dr.util.HeapSort;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public class OldDnDsPerSiteAnalysis {
    public static final String DNDS_PERSITE_ANALYSIS = "olddNdSPerSiteAnalysis";
    public static final String COND_SPERSITE_COLUMNS = "conditionalSperSite";
    public static final String UNCOND_SPERSITE_COLUMNS = "unconditionalSperSite";
    public static final String COND_NPERSITE_COLUMNS = "conditionalNperSite";
    public static final String UNCOND_NPERSITE_COLUMNS = "unconditionalNperSite";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("fileName", "The traceName of a BEAST log file (can not include trees, which should be logged separately")};

        @Override
        public String getParserName() {
            return OldDnDsPerSiteAnalysis.DNDS_PERSITE_ANALYSIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("fileName");
            try {
                File file = new File(string);
                String string2 = file.getName();
                String string3 = file.getParent();
                if (!file.isAbsolute()) {
                    string3 = System.getProperty("user.dir");
                }
                file = new File(string3, string2);
                string = file.getAbsolutePath();
                LogFileTraces logFileTraces = new LogFileTraces(string, file);
                logFileTraces.loadTraces();
                long l = logFileTraces.getMaxState();
                long l2 = xMLObject.getAttribute("burnIn", l / 10L);
                if (l2 < 0L || l2 >= l) {
                    l2 = l / 5L;
                    System.out.println("WARNING: Burn-in larger than total number of states - using to 20%");
                }
                logFileTraces.setBurnIn(l2);
                double[][][] dArrayArray = new double[4][][];
                for (int i = 0; i < 4; ++i) {
                    Object object;
                    int n;
                    XMLObject xMLObject2 = xMLObject.getChild(names[i]);
                    String string4 = xMLObject2.getStringAttribute("name");
                    int n2 = -1;
                    int n3 = -1;
                    boolean bl = false;
                    for (n = 0; n < logFileTraces.getTraceCount(); ++n) {
                        object = logFileTraces.getTraceName(n);
                        if (!((String)object).trim().contains(string4)) continue;
                        n3 = n;
                        if (bl) continue;
                        n2 = n;
                        bl = true;
                    }
                    if (n2 == -1) {
                        throw new XMLParseException(string4 + " columns can not be found for " + this.getParserName() + " element.");
                    }
                    n = 1 + (n3 - n2);
                    object = new double[n][];
                    for (int j = 0; j < n; ++j) {
                        List<Double> list = logFileTraces.getValues(j + n2);
                        object[j] = new double[list.size()];
                        for (int k = 0; k < list.size(); ++k) {
                            object[j][k] = list.get(k);
                        }
                    }
                    dArrayArray[i] = (double[][])object;
                }
                OldDnDsPerSiteAnalysis oldDnDsPerSiteAnalysis = new OldDnDsPerSiteAnalysis(dArrayArray[0], dArrayArray[1], dArrayArray[2], dArrayArray[3]);
                System.out.println(oldDnDsPerSiteAnalysis.output());
                return oldDnDsPerSiteAnalysis;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
        }

        @Override
        public String getParserDescription() {
            return "Performs a trace dN dS analysis.";
        }

        @Override
        public Class getReturnType() {
            return OldDnDsPerSiteAnalysis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final int numSites;
    private final int numSamples;
    private double[][][] allSamples;
    private static final int NUM_VARIABLES = 4;
    private static final int COND_S = 0;
    private static final int UNCOND_S = 1;
    private static final int COND_N = 2;
    private static final int UNCOND_N = 3;
    private static final String[] names = new String[]{"conditionalSperSite", "unconditionalSperSite", "conditionalNperSite", "unconditionalNperSite"};
    private double[][][] smoothSamples;
    private double[][][] smoothDnDsSamples;
    private static final boolean DEBUG = true;
    private double[][] rawMeanStats;
    private double[][] smoothMeanStats;
    private double[][] smoothMeanDnDsStats;
    private double[][][] smoothHPDDnDsStats;

    OldDnDsPerSiteAnalysis(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4) {
        this.numSites = dArray3.length;
        this.numSamples = dArray3[0].length;
        this.allSamples = new double[4][this.numSites][this.numSamples];
        this.allSamples[0] = dArray;
        this.allSamples[1] = dArray2;
        this.allSamples[2] = dArray3;
        this.allSamples[3] = dArray4;
        System.err.println("sumSites = " + this.numSites);
        System.err.println("numSamples = " + this.numSamples);
        this.smoothSamples = this.performSmoothing(this.allSamples);
        this.smoothDnDsSamples = this.getDnDsSamples(this.smoothSamples);
        this.rawMeanStats = this.computeMeanStats(this.allSamples);
        this.smoothMeanStats = this.computeMeanStats(this.smoothSamples);
        this.smoothMeanDnDsStats = this.computeMeanStats(this.smoothDnDsSamples);
        this.smoothHPDDnDsStats = this.computeHPDStats(this.smoothDnDsSamples);
    }

    private double[][][] getDnDsSamples(double[][][] dArray) {
        double[][][] dArrayArray;
        dArrayArray = new double[][][]{this.get2DArrayRatio(dArray[0], dArray[1]), this.get2DArrayRatio(dArray[2], dArray[3]), this.get2DArrayRatio(dArrayArray[1], dArrayArray[0])};
        return dArrayArray;
    }

    private double[][] get2DArrayRatio(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = this.get1DArrayRatio(dArray[i], dArray2[i]);
        }
        return dArray3;
    }

    private double[] get1DArrayRatio(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] / dArray2[i];
        }
        return dArray3;
    }

    private double[][] transpose(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    private double computeDnDs(double[][][] dArray, int n, int n2) {
        return dArray[2][n][n2] / dArray[0][n][n2] / (dArray[3][n][n2] / dArray[1][n][n2]);
    }

    private double[][][] performSmoothing(double[][][] dArray) {
        double[][][] dArrayArray = new double[dArray.length][][];
        double[][][] dArrayArray2 = new double[dArray.length][][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray2[i] = this.transpose(dArray[i]);
            for (int j = 0; j < this.numSamples; ++j) {
                dArrayArray2[i][j] = EmpiricalBayesPoissonSmoother.smooth(dArrayArray2[i][j]);
            }
            dArrayArray[i] = this.transpose(dArrayArray2[i]);
        }
        return dArrayArray;
    }

    private double computeRatio(double[][][] dArray, int n, int n2, int n3, int n4) {
        return dArray[n3][n][n2] / dArray[n4][n][n2];
    }

    private double[][] computeMeanStats(double[][][] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = OldDnDsPerSiteAnalysis.mean(dArray[i]);
        }
        return dArray2;
    }

    private double[][][] computeHPDStats(double[][][] dArray) {
        double[][][] dArray2 = new double[dArray.length][dArray[0].length][2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = OldDnDsPerSiteAnalysis.getArrayHPDintervals(dArray[i]);
        }
        return dArray2;
    }

    public String output() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("site\tcS\tuS\tcN\tuN\tsmooth(cS)\tsmooth(uS)\tsmooth(cN)\tsmooth(uN)\tsmooth(cS/uS)\tsmooth(cN/uN)\tsmooth((cN/uN)/(cS/uS))\t[hpd]\n");
        for (int i = 0; i < this.numSites; ++i) {
            stringBuffer.append(i + 1 + "\t" + this.rawMeanStats[0][i] + "\t" + this.rawMeanStats[1][i] + "\t" + this.rawMeanStats[2][i] + "\t" + this.rawMeanStats[3][i] + "\t" + this.smoothMeanStats[0][i] + "\t" + this.smoothMeanStats[1][i] + "\t" + this.smoothMeanStats[2][i] + "\t" + this.smoothMeanStats[3][i] + "\t" + this.smoothMeanDnDsStats[0][i] + "\t" + this.smoothMeanDnDsStats[1][i] + "\t" + this.smoothMeanDnDsStats[2][i] + "\t[" + this.smoothHPDDnDsStats[2][i][0] + "," + this.smoothHPDDnDsStats[2][i][1] + "]");
            if (this.smoothHPDDnDsStats[2][i][0] > 1.0 || this.smoothHPDDnDsStats[2][i][1] < 1.0) {
                stringBuffer.append("\t*");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static double[][] getArrayHPDintervals(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][2];
        for (int i = 0; i < dArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < dArray[0].length; ++j) {
                if (Double.valueOf(dArray[i][j]).isNaN()) continue;
                ++n;
            }
            if (n > 0) {
                double[] dArray3 = new double[n];
                int n2 = 0;
                for (int j = 0; j < dArray[0].length; ++j) {
                    if (Double.valueOf(dArray[i][j]).isNaN()) continue;
                    dArray3[n2] = dArray[i][j];
                    ++n2;
                }
                int[] nArray = new int[n];
                HeapSort.sort(dArray3, nArray);
                double[] dArray4 = OldDnDsPerSiteAnalysis.getHPDInterval(0.95, dArray3, nArray);
                dArray2[i][0] = dArray4[0];
                dArray2[i][1] = dArray4[1];
                continue;
            }
            dArray2[i][0] = Double.NaN;
            dArray2[i][1] = Double.NaN;
        }
        return dArray2;
    }

    private static double[] getHPDInterval(double d, double[] dArray, int[] nArray) {
        double[] dArray2 = new double[2];
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = (int)Math.round(d * (double)dArray.length);
        for (int i = 0; i <= dArray.length - n2; ++i) {
            double d3 = dArray[nArray[i + n2 - 1]];
            double d4 = dArray[nArray[i]];
            double d5 = Math.abs(d3 - d4);
            if (!(d5 < d2)) continue;
            d2 = d5;
            n = i;
        }
        dArray2[0] = dArray[nArray[n]];
        dArray2[1] = dArray[nArray[n + n2 - 1]];
        return dArray2;
    }

    private static double[] mean(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = DiscreteStatistics.mean(dArray[i]);
        }
        return dArray2;
    }
}

