/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.Serializable;
import umontreal.iro.lecuyer.util.BitVector;

public class BitMatrix
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2472769969919959608L;
    private BitVector[] rows;
    private int r;
    private int c;

    public BitMatrix(int n, int n2) {
        this.rows = new BitVector[n];
        for (int i = 0; i < n; ++i) {
            this.rows[i] = new BitVector(n2);
        }
        this.r = n;
        this.c = n2;
    }

    public BitMatrix(BitVector[] bitVectorArray) {
        this.rows = new BitVector[bitVectorArray.length];
        for (int i = 0; i < bitVectorArray.length; ++i) {
            this.rows[i] = new BitVector(bitVectorArray[i]);
        }
        this.r = bitVectorArray.length;
        this.c = this.r > 0 ? bitVectorArray[0].size() : 0;
    }

    public BitMatrix(int[][] nArray, int n, int n2) {
        this.rows = new BitVector[n];
        for (int i = 0; i < n; ++i) {
            this.rows[i] = new BitVector(nArray[i], n2);
        }
        this.r = n;
        this.c = n2;
    }

    public BitMatrix(BitMatrix bitMatrix) {
        this.r = bitMatrix.r;
        this.c = bitMatrix.c;
        this.rows = new BitVector[this.r];
        for (int i = 0; i < this.r; ++i) {
            this.rows[i] = new BitVector(bitMatrix.rows[i]);
        }
    }

    public Object clone() {
        try {
            BitMatrix bitMatrix = (BitMatrix)super.clone();
            bitMatrix.rows = (BitVector[])this.rows.clone();
            for (int i = 0; i < this.rows.length; ++i) {
                bitMatrix.rows[i] = (BitVector)this.rows[i].clone();
            }
            return bitMatrix;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(cloneNotSupportedException);
            throw illegalStateException;
        }
    }

    public boolean equals(BitMatrix bitMatrix) {
        if (this.r != bitMatrix.r || this.c != bitMatrix.c) {
            return false;
        }
        for (int i = 0; i < this.r; ++i) {
            if (this.rows[i].equals(bitMatrix.rows[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (n = 0; n < this.rows.length - 1; ++n) {
            for (int i = 0; i < this.rows[n].size(); ++i) {
                stringBuffer.append(this.rows[n].getBool(i) ? "1" : "0");
            }
            stringBuffer.append("\n  ");
        }
        if (this.r > 0) {
            for (n = 0; n < this.c; ++n) {
                stringBuffer.append(this.rows[this.r - 1].getBool(n) ? "1" : "0");
            }
            stringBuffer.append(" }");
        } else {
            stringBuffer.append(" }");
        }
        return stringBuffer.toString();
    }

    public String printData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (int i = 0; i < this.r; ++i) {
            stringBuffer.append("{");
            for (int j = 0; j < (this.c + 31) / 32; ++j) {
                stringBuffer.append(this.rows[i].getInt(j));
                if (j == (this.c - 1) / 32) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            if (i == this.r - 1) continue;
            stringBuffer.append(",\n  ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public int numRows() {
        return this.r;
    }

    public int numColumns() {
        return this.c;
    }

    public boolean getBool(int n, int n2) {
        if (n >= this.r || n2 >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        return this.rows[n].getBool(n2);
    }

    public void setBool(int n, int n2, boolean bl) {
        if (n >= this.r || n2 >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        this.rows[n].setBool(n2, bl);
    }

    public BitMatrix transpose() {
        BitMatrix bitMatrix = new BitMatrix(this.c, this.r);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                bitMatrix.rows[j].setBool(i, this.rows[i].getBool(j));
            }
        }
        return bitMatrix;
    }

    public BitMatrix not() {
        BitMatrix bitMatrix = new BitMatrix(this);
        for (int i = 0; i < this.r; ++i) {
            bitMatrix.rows[i].selfNot();
        }
        return bitMatrix;
    }

    public BitMatrix and(BitMatrix bitMatrix) {
        if (this.c != bitMatrix.c || this.r != bitMatrix.r) {
            throw new IncompatibleDimensionException("Both matrices must have the same dimension. this is a " + this.r + "x" + this.c + " matrix " + "while that is a " + bitMatrix.r + "x" + bitMatrix.c + " matrix.");
        }
        BitMatrix bitMatrix2 = new BitMatrix(this);
        for (int i = 0; i < this.r; ++i) {
            bitMatrix2.rows[i].selfAnd(bitMatrix.rows[i]);
        }
        return bitMatrix2;
    }

    public BitMatrix or(BitMatrix bitMatrix) {
        if (this.c != bitMatrix.c || this.r != bitMatrix.r) {
            throw new IncompatibleDimensionException("Both matrices must have the same dimension. this is a " + this.r + "x" + this.c + " matrix " + "while that is a " + bitMatrix.r + "x" + bitMatrix.c + " matrix.");
        }
        BitMatrix bitMatrix2 = new BitMatrix(this);
        for (int i = 0; i < this.r; ++i) {
            bitMatrix2.rows[i].selfOr(bitMatrix.rows[i]);
        }
        return bitMatrix2;
    }

    public BitMatrix xor(BitMatrix bitMatrix) {
        if (this.c != bitMatrix.c || this.r != bitMatrix.r) {
            throw new IncompatibleDimensionException("Both matrices must have the same dimension. this is a " + this.r + "x" + this.c + " matrix " + "while that is a " + bitMatrix.r + "x" + bitMatrix.c + " matrix.");
        }
        BitMatrix bitMatrix2 = new BitMatrix(this);
        for (int i = 0; i < this.r; ++i) {
            bitMatrix2.rows[i].selfXor(bitMatrix.rows[i]);
        }
        return bitMatrix2;
    }

    public BitVector multiply(BitVector bitVector) {
        BitVector bitVector2 = new BitVector(this.r);
        for (int i = 0; i < this.r; ++i) {
            bitVector2.setBool(i, this.rows[i].scalarProduct(bitVector));
        }
        return bitVector2;
    }

    public int multiply(int n) {
        BitVector bitVector = new BitVector(new int[]{n});
        return this.multiply(bitVector).getInt(0);
    }

    public BitMatrix multiply(BitMatrix bitMatrix) {
        if (this.c != bitMatrix.r) {
            throw new IncompatibleDimensionException("The number of columns of this (" + this.c + ") must be equal to the number of rows of that (" + bitMatrix.r + ").");
        }
        BitMatrix bitMatrix2 = new BitMatrix(this.r, bitMatrix.c);
        for (int i = 0; i < bitMatrix2.r; ++i) {
            for (int j = 0; j < bitMatrix2.c; ++j) {
                if (!this.rows[i].getBool(j)) continue;
                bitMatrix2.rows[i].selfXor(bitMatrix.rows[j]);
            }
        }
        return bitMatrix2;
    }

    public BitMatrix power(long l) {
        if (this.c != this.r) {
            throw new IncompatibleDimensionException("Only square matrices can be raised to a power.");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Only non-negative powers are accepted.");
        }
        if (l == 0L) {
            BitMatrix bitMatrix = new BitMatrix(this.r, this.r);
            for (int i = 0; i < this.r; ++i) {
                bitMatrix.setBool(i, i, true);
            }
            return bitMatrix;
        }
        if (l == 1L) {
            return this;
        }
        if (l % 2L == 0L) {
            BitMatrix bitMatrix = this.power(l / 2L);
            return bitMatrix.multiply(bitMatrix);
        }
        return this.multiply(this.power(l - 1L));
    }

    public BitMatrix power2e(int n) {
        if (this.c != this.r) {
            throw new IncompatibleDimensionException("Only square matrices can be raised to a power.");
        }
        BitMatrix bitMatrix = this;
        for (int i = 0; i < n; ++i) {
            bitMatrix = bitMatrix.multiply(bitMatrix);
        }
        return bitMatrix;
    }

    public class IncompatibleDimensionException
    extends RuntimeException {
        private IncompatibleDimensionException() {
        }

        private IncompatibleDimensionException(String string) {
            super(string);
        }
    }
}

