/*
 * Decompiled with CFR 0.152.
 */
package jdr.spec.ts;

import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import jdr.spec.ts.Utility;

public class SpanSelector {
    private final TsPeriodSelector core;

    public SpanSelector(TsPeriodSelector sel) {
        this.core = sel;
    }

    public TsPeriodSelector getCore() {
        return this.core;
    }

    public String getType() {
        return this.core.getType().name();
    }

    public String getD0() {
        return Utility.toString(this.core.getD0());
    }

    public String getD1() {
        return Utility.toString(this.core.getD1());
    }

    public int getN0() {
        return this.core.getN0();
    }

    public int getN1() {
        return this.core.getN1();
    }

    public void from(String d0) {
        this.core.from(Utility.of(d0));
    }

    public void to(String d1) {
        this.core.to(Utility.of(d1));
    }

    public void between(String d0, String d1) {
        this.core.between(Utility.of(d0), Utility.of(d1));
    }

    public void all() {
        this.core.all();
    }

    public void first(int n) {
        this.core.first(n);
    }

    public void last(int n) {
        this.core.last(n);
    }

    public void excluding(int n0, int n1) {
        this.core.excluding(n0, n1);
    }

    public static enum Type {
        All,
        From,
        To,
        Between,
        Last,
        First,
        Excluding;


        public static Type of(PeriodSelectorType type) {
            switch (type) {
                case All: {
                    return All;
                }
                case From: {
                    return From;
                }
                case To: {
                    return To;
                }
                case Between: {
                    return Between;
                }
                case Last: {
                    return Last;
                }
                case First: {
                    return First;
                }
                case Excluding: {
                    return Excluding;
                }
            }
            throw new IllegalArgumentException();
        }

        public static PeriodSelectorType to(Type type) {
            switch (type) {
                case All: {
                    return PeriodSelectorType.All;
                }
                case From: {
                    return PeriodSelectorType.From;
                }
                case To: {
                    return PeriodSelectorType.To;
                }
                case Between: {
                    return PeriodSelectorType.Between;
                }
                case Last: {
                    return PeriodSelectorType.Last;
                }
                case First: {
                    return PeriodSelectorType.First;
                }
                case Excluding: {
                    return PeriodSelectorType.Excluding;
                }
            }
            return PeriodSelectorType.None;
        }
    }
}

