/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.utilities.Ref;

public final class Utilities {
    static final double g_epsilon = 1.0E-9;

    public static boolean checkRoots(Complex[] roots, double nmax) {
        if (roots == null) {
            return true;
        }
        for (int i = 0; i < roots.length; ++i) {
            double n = roots[i].abs();
            if (!(n < nmax)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkRoots(IReadDataBlock c, double rmin) {
        int nc = c.getLength();
        switch (nc) {
            case 0: {
                return false;
            }
            case 1: {
                double cabs = Math.abs(c.get(0));
                return 1.0 / cabs > rmin;
            }
            case 2: {
                double a = c.get(0);
                double b = c.get(1);
                double ro = a * a - 4.0 * b;
                if (ro > 0.0) {
                    double sro = Math.sqrt(ro);
                    double x0 = (-a + sro) / (2.0 * b);
                    double x1 = (-a - sro) / (2.0 * b);
                    return Math.abs(x0) > rmin && Math.abs(x1) > rmin;
                }
                return 1.0 / Math.sqrt(b) > rmin;
            }
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        c.copyTo(ctmp, 1);
        Polynomial p = Polynomial.of(ctmp);
        return Utilities.checkRoots(p.roots(), rmin);
    }

    public static boolean checkStability(IReadDataBlock c) {
        int nc = c.getLength();
        if (nc == 0) {
            return true;
        }
        if (nc == 1) {
            return Math.abs(c.get(0)) < 1.0;
        }
        double[] coeff = new double[nc];
        c.copyTo(coeff, 0);
        double[] pat = new double[nc];
        double[] pu = new double[nc];
        for (int i = coeff.length - 1; i >= 0; --i) {
            pat[i] = coeff[i];
            if (Math.abs(pat[i]) >= 1.0) {
                return false;
            }
            for (int j = 0; j < i; ++j) {
                pu[j] = coeff[i - j - 1];
            }
            double den = 1.0 - pat[i] * pat[i];
            for (int j = 0; j < i / 2; ++j) {
                coeff[j] = (coeff[j] - pat[i] * pu[j]) / den;
                coeff[i - j - 1] = (coeff[i - j - 1] - pat[i] * pu[i - j - 1]) / den;
            }
            if (i % 2 == 0) continue;
            coeff[i / 2] = pu[i / 2] / (1.0 + pat[i]);
        }
        return true;
    }

    public static boolean checkQuasiStability(IReadDataBlock c, double rtol) {
        int nc = c.getLength();
        if (nc == 0) {
            return true;
        }
        if (nc == 1) {
            return Math.abs(c.get(0)) < rtol;
        }
        double[] coef = new double[nc + 1];
        coef[0] = 1.0;
        c.copyTo(coef, 1);
        Polynomial p = Polynomial.copyOf(coef);
        Complex[] roots = p.roots();
        for (int i = 0; i < roots.length; ++i) {
            if (!(roots[i].abs() < 1.0 / rtol)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkStability(Polynomial p) {
        return Utilities.checkStability(new DataBlock(p.getCoefficients()).drop(1, 0));
    }

    public static double[] compact(double[] data) {
        int cur;
        for (cur = data.length - 1; cur >= 0 && data[cur] == 0.0; --cur) {
        }
        if (cur < 0) {
            return null;
        }
        if (cur == data.length - 1) {
            return data;
        }
        double[] cdata = new double[cur + 1];
        for (int i = 0; i <= cur; ++i) {
            cdata[i] = data[i];
        }
        return cdata;
    }

    public static Complex frequencyResponse(double[] c, int lb, double w) {
        Complex phase = Complex.cart(Math.cos(w * (double)lb), Math.sin(w * (double)lb));
        double cos = Math.cos(w);
        double sin = Math.sin(w);
        Complex rslt = Complex.cart(c[0]);
        int n = c.length;
        Complex c0 = Complex.ONE;
        Complex c1 = Complex.cart(cos, sin);
        if (n > 1) {
            rslt = rslt.plus(c1.times(c[1]));
            for (int i = 2; i < n; ++i) {
                Complex eiw = c1.times(2.0 * cos).minus(c0);
                rslt = rslt.plus(eiw.times(c[i]));
                c0 = c1;
                c1 = eiw;
            }
        }
        return rslt.times(phase);
    }

    public static double[] smooth(double[] data) {
        return Utilities.smooth(data, 1.0E-9, true);
    }

    public static double[] smooth(double[] data, double epsilon, boolean bcompact) {
        for (int i = 0; i < data.length; ++i) {
            if (!(Math.abs(data[i]) < epsilon)) continue;
            data[i] = 0.0;
        }
        if (bcompact) {
            return Utilities.compact(data);
        }
        return data;
    }

    public static boolean stabilize(Polynomial p, double rmax, Ref<Polynomial> np) {
        np.val = p;
        if (p != null) {
            boolean rslt = false;
            Complex[] roots = p.roots();
            for (int i = 0; i < roots.length; ++i) {
                Complex root = roots[i];
                double n = roots[i].abs();
                if (!(n < 1.0 / rmax)) continue;
                roots[i] = root.div(n * rmax);
                rslt = true;
            }
            if (rslt) {
                np.val = Polynomial.fromComplexRoots(roots);
                np.val = ((Polynomial)np.val).divide(((Polynomial)np.val).get(0));
                return true;
            }
        }
        return false;
    }

    public static boolean stabilize(Polynomial p, Ref<Polynomial> np) {
        if (p != null && !Utilities.checkStability(p)) {
            Complex[] roots = p.roots();
            for (int i = 0; i < roots.length; ++i) {
                Complex root = roots[i];
                double n = roots[i].abs();
                if (!(n < 1.0)) continue;
                roots[i] = root.inv();
            }
            np.val = Polynomial.fromComplexRoots(roots);
            np.val = ((Polynomial)np.val).divide(((Polynomial)np.val).get(0));
            return true;
        }
        np.val = p;
        return false;
    }

    private Utilities() {
    }
}

