/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.ProbabilityType;
import java.util.Arrays;

public interface IRobustStandardDeviationComputer {
    public boolean compute(IReadDataBlock var1);

    public double get();

    public double get(int var1);

    public void reset();

    public static IRobustStandardDeviationComputer mad() {
        return new Mad2(50);
    }

    public static IRobustStandardDeviationComputer mad(boolean mediancorrected) {
        return mediancorrected ? new Mad2(50) : new Mad(50);
    }

    public static IRobustStandardDeviationComputer mad(int centile, boolean mediancorrected) {
        return mediancorrected ? new Mad2(centile) : new Mad(centile);
    }

    public static IRobustStandardDeviationComputer rmse() {
        return new Rmse();
    }

    public static class Rmse
    implements IRobustStandardDeviationComputer {
        private double ss;
        private IReadDataBlock data;

        @Override
        public boolean compute(IReadDataBlock e) {
            this.data = e;
            this.ss = e.ssq();
            return true;
        }

        @Override
        public double get(int i) {
            int n = this.data.getLength();
            if (i >= 0 && i < n) {
                double e = this.data.get(i);
                return Math.sqrt((this.ss - e * e) / (double)(n - 1));
            }
            return Math.sqrt(this.ss / (double)(n - 1));
        }

        @Override
        public double get() {
            int n = this.data.getLength();
            return Math.sqrt(this.ss / (double)n);
        }

        @Override
        public void reset() {
            this.data = null;
            this.ss = 0.0;
        }
    }

    public static class Mad2
    implements IRobustStandardDeviationComputer {
        private double mad;
        private final int centile;

        Mad2(int centile) {
            this.centile = centile;
        }

        @Override
        public boolean compute(IReadDataBlock data) {
            int n = data.getLength();
            double[] e = new double[n];
            data.copyTo(e, 0);
            Arrays.sort(e);
            double median = 0.0;
            int n2 = n / 2;
            median = n2 * 2 == n ? (e[n2 - 1] + e[n2]) / 2.0 : e[n2];
            for (int i = 0; i < n; ++i) {
                if (e[i] >= median) {
                    int n3 = i;
                    e[n3] = e[n3] - median;
                    continue;
                }
                e[i] = median - e[i];
            }
            Arrays.sort(e);
            int nm = (n + 1) * this.centile / 100;
            double dnm = (double)((n + 1) * this.centile) / 100.0;
            double dx = dnm - (double)nm;
            double m = dx < 1.0E-9 ? e[nm - 1] : e[nm - 1] * (1.0 - dx) + e[nm] * dx;
            Normal normal = new Normal();
            double l = normal.getProbabilityInverse(0.5 + 0.005 * (double)this.centile, ProbabilityType.Lower);
            this.mad = m / l;
            return true;
        }

        @Override
        public double get(int pos) {
            return this.mad;
        }

        @Override
        public double get() {
            return this.mad;
        }

        @Override
        public void reset() {
            this.mad = 0.0;
        }
    }

    public static class Mad
    implements IRobustStandardDeviationComputer {
        private double mad;
        private final int centile;

        Mad(int centile) {
            this.centile = centile;
        }

        @Override
        public boolean compute(IReadDataBlock e) {
            int n = e.getLength();
            double[] a = new double[n];
            e.copyTo(a, 0);
            for (int i = 0; i < n; ++i) {
                a[i] = Math.abs(a[i]);
            }
            Arrays.sort(a);
            int nm = (n + 1) * this.centile / 100;
            double dnm = (double)((n + 1) * this.centile) / 100.0;
            double dx = dnm - (double)nm;
            double m = dx < 1.0E-9 ? a[nm - 1] : a[nm - 1] * (1.0 - dx) + a[nm] * dx;
            Normal normal = new Normal();
            double l = normal.getProbabilityInverse(0.5 + 0.005 * (double)this.centile, ProbabilityType.Lower);
            this.mad = m / l;
            return true;
        }

        @Override
        public double get(int pos) {
            return this.mad;
        }

        @Override
        public double get() {
            return this.mad;
        }

        @Override
        public void reset() {
            this.mad = 0.0;
        }
    }
}

