/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.RestSdmx30Client;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxExceptionFactory;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxUnknownProviderException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxProxySelector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SDMXClientFactory {
    private static final String ECB_PROVIDER = "https://sdw-wsrest.ecb.europa.eu/service";
    private static final String ISTAT_PROVIDER_POP = "http://sdmx.istat.it/WS_CENSPOP/rest";
    private static final String ISTAT_RI_PROVIDER = "https://esploradati.istat.it/SDMXWS/rest";
    private static final String ISTAT_PROVIDER_AGR = "http://sdmx.istat.it/WS_CENSAGR/rest";
    private static final String ISTAT_PROVIDER_IND = "http://sdmx.istat.it/WS_CIS/rest";
    private static final String INSEE_PROVIDER = "https://bdm.insee.fr/series/sdmx";
    private static final String UNDATA_PROVIDER = "http://data.un.org/WS/rest";
    private static final String WITS_PROVIDER = "http://wits.worldbank.org/API/V1/SDMX/V21/rest";
    private static final String ILO_PROVIDER = "https://www.ilo.org/sdmx/rest";
    private static final String ABS_PROVIDER = "https://api.data.abs.gov.au";
    private static final String UNICEF_PROVIDER = "https://sdmx.data.unicef.org/ws/public/sdmxapi/rest";
    private static final String BIS_PROVIDER = "https://stats.bis.org/api/v1";
    public static final String SDMX_V2 = "SDMX_V2";
    public static final String SDMX_V3 = "SDMX_V3";
    private static final String sourceClass;
    protected static Logger logger;
    private static NavigableMap<String, Provider> providers;

    private static void initBuiltInProviders() throws SdmxException {
        SDMXClientFactory.addBuiltInProvider("ECB", ECB_PROVIDER, false, false, true, "European Central Bank", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("ISTAT_RI", ISTAT_RI_PROVIDER, false, false, false, "Italian National Institute of Statistics", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("ISTAT_CENSUS_POP", ISTAT_PROVIDER_POP, false, false, false, "ISTAT - Population and housing census 2011", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("ISTAT_CENSUS_AGR", ISTAT_PROVIDER_AGR, false, false, false, "ISTAT - Agricultural census 2010", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("ISTAT_CENSUS_IND", ISTAT_PROVIDER_IND, false, false, false, "ISTAT - Industry and services census 2011", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("INSEE", INSEE_PROVIDER, false, false, true, "National Institute of Statistics and Economic Studies", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("UNDATA", UNDATA_PROVIDER, false, false, false, "Data access system to UN databases", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("WITS", WITS_PROVIDER, false, false, false, "World Integrated Trade Solutions", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("ILO", ILO_PROVIDER, false, false, false, "International Labour Organization", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("ABS", ABS_PROVIDER, false, false, false, "Australian Bureau of Statistics - SDMX 2.1", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("UNICEF", UNICEF_PROVIDER, false, false, true, "UNICEF", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("BIS_PUBLIC", BIS_PROVIDER, false, false, true, "Bank for International Settlements", false, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("ISTAT", null, false, false, false, "Italian National Institute of Statistics ", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("OECD", null, false, false, false, "The Organisation for Economic Co-operation and Development", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("StatsEE", null, false, false, false, "Statistics Estonia (BETA)", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("OECD_RESTR", null, true, false, false, "The Organisation for Economic Co-operation and Development, RESTRICTED ACCESS", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("IMF2", null, false, false, false, "New International Monetary Fund endpoint", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("NBB", null, false, false, false, "National Bank Belgium", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("WB", null, false, false, false, "World Bank - World Development Indicators", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("INEGI", null, false, false, false, "Instituto Nacional de Estadistica y Geografia", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("EUROSTAT", null, false, false, false, "Eurostat", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("EUROSTAT_COMEXT", null, false, false, false, "Eurostat - COMEXT", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("EUROSTAT_GROW", null, false, false, false, "Eurostat - DG GROW", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("EUROSTAT_COMP", null, false, false, false, "Eurostat - DG COMP", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("EUROSTAT_EMPL", null, false, false, false, "Eurostat - DG EMPL", true, SDMX_V2);
        SDMXClientFactory.addBuiltInProvider("BBK", null, false, false, false, "Deutsche Bundesbank", true, SDMX_V2);
    }

    private static void initExternalProviders() throws SdmxException {
        String string = Configuration.getExternalProviders();
        if (string != null && !string.isEmpty()) {
            String[] stringArray = string.trim().split("\\s*,\\s*");
            for (int i = 0; i < stringArray.length; ++i) {
                SDMXClientFactory.addExternalProvider(stringArray[i]);
            }
        }
    }

    public static void addProvider(String string, URI uRI, boolean bl, boolean bl2, boolean bl3, String string2, boolean bl4, String string3) throws SdmxException {
        Provider provider = new Provider(string, uRI, null, bl, bl2, bl3, string2, bl4, string3);
        providers.put(string, provider);
    }

    public static void addProvider(String string, URI uRI, boolean bl, boolean bl2, boolean bl3, String string2, boolean bl4) throws SdmxException {
        Provider provider = new Provider(string, uRI, null, bl, bl2, bl3, string2, bl4, SDMX_V2);
        providers.put(string, provider);
    }

    public static void addProvider(String string, URI uRI, KeyStore keyStore, boolean bl, boolean bl2, boolean bl3, String string2, boolean bl4, String string3) throws SdmxException {
        Provider provider = new Provider(string, uRI, keyStore, bl, bl2, bl3, string2, bl4, string3);
        providers.put(string, provider);
    }

    public static void addProvider(String string, URI uRI, KeyStore keyStore, boolean bl, boolean bl2, boolean bl3, String string2, boolean bl4) throws SdmxException {
        Provider provider = new Provider(string, uRI, keyStore, bl, bl2, bl3, string2, bl4, SDMX_V2);
        providers.put(string, provider);
    }

    private static void addBuiltInProvider(String string, String string2, Boolean bl, Boolean bl2, Boolean bl3, String string3, boolean bl4, String string4) throws SdmxException {
        try {
            String string5 = Configuration.getConfiguration().getProperty("providers." + string + ".name", string);
            String string6 = Configuration.getConfiguration().getProperty("providers." + string + ".endpoint", string2);
            URI uRI = null != string6 ? new URI(string6) : null;
            boolean bl5 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".needsCredentials", bl.toString()));
            boolean bl6 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".needsURLEncoding", bl2.toString()));
            boolean bl7 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".supportsCompression", bl3.toString()));
            String string7 = Configuration.getConfiguration().getProperty("providers." + string + ".description", string3);
            String string8 = Configuration.getConfiguration().getProperty("providers." + string + ".sdmxversion", string4.toString());
            SDMXClientFactory.addProvider(string5, uRI, null, bl5, bl6, bl7, string7, bl4, string8);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.log(Level.SEVERE, "Exception. Class: {0} .Message: {1}", new Object[]{uRISyntaxException.getClass().getName(), uRISyntaxException.getMessage()});
            logger.log(Level.FINER, "", uRISyntaxException);
        }
    }

    private static void addExternalProvider(String string) throws SdmxException {
        try {
            KeyStore keyStore;
            String string2;
            String string3;
            boolean bl;
            boolean bl2;
            boolean bl3;
            URI uRI;
            String string4 = Configuration.getConfiguration().getProperty("providers." + string + ".name", string);
            String string5 = Configuration.getConfiguration().getProperty("providers." + string + ".endpoint");
            if (string5 != null && !string5.isEmpty()) {
                uRI = new URI(string5);
                bl3 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".needsCredentials", "false"));
                bl2 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".needsURLEncoding", "false"));
                bl = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".supportsCompression", "false"));
                string3 = Configuration.getConfiguration().getProperty("providers." + string + ".description", string);
                string2 = Configuration.getConfiguration().getProperty("providers." + string + ".sdmxversion", SDMX_V2);
                String string6 = Configuration.getConfiguration().getProperty("providers." + string + ".trustStore", "");
                keyStore = null;
                if (!"".equals(string6)) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(new File(string6));
                        keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore.load(fileInputStream, "changeit".toCharArray());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        logger.warning("Cannot open trust store at " + string6);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        generalSecurityException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        throw SdmxExceptionFactory.wrap(iOException);
                    }
                    finally {
                        keyStore = null;
                    }
                }
            } else {
                logger.warning("No URL has been configured for the external provider: '" + string + "'. It will be skipped.");
                return;
            }
            SDMXClientFactory.addProvider(string4, uRI, keyStore, bl3, bl2, bl, string3, false, string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.log(Level.SEVERE, "Exception. Class: {0} .Message: {1}", new Object[]{uRISyntaxException.getClass().getName(), uRISyntaxException.getMessage()});
            logger.log(Level.FINER, "", uRISyntaxException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenericSDMXClient createClient(String string) throws SdmxException {
        Object object;
        logger.entering(sourceClass, "createClient");
        logger.fine("Create an SDMX client for '" + string + "'");
        GenericSDMXClient genericSDMXClient = null;
        Provider provider = (Provider)providers.get(string);
        if (provider == null) {
            throw new SdmxInvalidParameterException("The provider '" + string + "' is not available in this configuration.");
        }
        String string2 = null;
        if (provider != null && !provider.isCustom()) {
            string2 = provider.getEndpoint().getHost();
            if (!provider.getEndpoint().getScheme().toLowerCase().startsWith("http")) throw new SdmxInvalidParameterException("The protocol '" + provider.getEndpoint().getScheme() + "' is not supported.");
            if (provider.getSdmxVersion().trim().equalsIgnoreCase(SDMX_V2)) {
                genericSDMXClient = new RestSdmxClient(provider.getName(), provider.getEndpoint(), provider.getSSLSocketFactory(), provider.isNeedsCredentials(), provider.isNeedsURLEncoding(), provider.isSupportsCompression());
            } else {
                if (!provider.getSdmxVersion().trim().equalsIgnoreCase(SDMX_V3)) throw new SdmxInvalidParameterException("The sdmx version '" + provider.getSdmxVersion() + "' is not supported.");
                genericSDMXClient = new RestSdmx30Client(provider.getName(), provider.getEndpoint(), provider.getSSLSocketFactory(), provider.isNeedsCredentials(), provider.isNeedsURLEncoding(), provider.isSupportsCompression());
            }
        } else {
            try {
                object = Class.forName("it.bancaditalia.oss.sdmx.client.custom." + string);
                genericSDMXClient = (GenericSDMXClient)((Class)object).newInstance();
                if (provider.getEndpoint() != null) {
                    genericSDMXClient.setEndpoint(provider.getEndpoint());
                }
                if (genericSDMXClient.getEndpoint() != null) {
                    string2 = genericSDMXClient.getEndpoint().getHost();
                }
                genericSDMXClient.setName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.severe("The provider '" + string + "' is not available in this configuration.");
                throw new SdmxUnknownProviderException(string, classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.severe("The provider implementation it.bancaditalia.oss.sdmx.client.custom." + string + " does not define a default constructor.");
                throw new SdmxUnknownProviderException(string, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                logger.severe("Could not instantiate provider implementation it.bancaditalia.oss.sdmx.client.custom." + string);
                throw new SdmxUnknownProviderException(string, instantiationException);
            }
        }
        object = ProxySelector.getDefault();
        if (string2 != null && object != null && object instanceof SdmxProxySelector) {
            ((SdmxProxySelector)object).addToDefaultProxy(string2);
        }
        logger.exiting(sourceClass, "createClient");
        return genericSDMXClient;
    }

    public static NavigableMap<String, Provider> getProviders() {
        return providers;
    }

    static {
        providers = new TreeMap<String, Provider>();
        logger = Configuration.getSdmxLogger();
        try {
            SDMXClientFactory.initBuiltInProviders();
            SDMXClientFactory.initExternalProviders();
        }
        catch (SdmxException sdmxException) {
            sdmxException.printStackTrace();
        }
        sourceClass = SDMXClientFactory.class.getSimpleName();
    }
}

