/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.IOException;
import java.io.Serializable;
import javax.realtime.MemoryArea;
import javolution.JavolutionError;
import javolution.lang.Reusable;
import javolution.lang.Text;
import javolution.lang.TypeFormat;
import javolution.realtime.Realtime;
import javolution.realtime.RealtimeObject;

public class TextBuilder
extends RealtimeObject
implements Appendable,
CharSequence,
Reusable,
Serializable {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new TextBuilder();
        }

        public void cleanup(Object object) {
            ((TextBuilder)object).reset();
        }
    };
    private static final int D0 = 5;
    private static final int M0 = 31;
    private static final int C0 = 32;
    private static final int D1 = 7;
    private static final int R1 = 5;
    private static final int M1 = 127;
    private static final int C1 = 4096;
    private static final int D2 = 9;
    private static final int R2 = 12;
    private static final int M2 = 511;
    private static final int C2 = 0x200000;
    private static final int D3 = 11;
    private static final int R3 = 21;
    private final char[] _chars0 = new char[32];
    private char[][] _chars1;
    private char[][][] _chars2;
    private char[][][][] _chars3;
    private int _capacity = 32;
    private int _length;

    public TextBuilder() {
    }

    public TextBuilder(CharSequence charSequence) {
        this.append(charSequence);
    }

    public TextBuilder(int n) {
        while (n > this._capacity) {
            this.increaseCapacity();
        }
    }

    public static TextBuilder newInstance() {
        return (TextBuilder)FACTORY.object();
    }

    public final int length() {
        return this._length;
    }

    public final char charAt(int n) {
        if (n < 0 || n >= this._length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        if (n < 32) {
            return this._chars0[n];
        }
        if (n < 4096) {
            return this._chars1[n >> 5][n & 0x1F];
        }
        if (n < 0x200000) {
            return this._chars2[n >> 12][n >> 5 & 0x7F][n & 0x1F];
        }
        return this._chars3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F];
    }

    public final void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n3 < 0 || n > n2 || n2 > this.length() || n3 + n2 - n > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n;
        int n5 = n3;
        while (n4 < n2) {
            cArray[n5++] = this.charAt(n4++);
        }
    }

    public final void setCharAt(int n, char c) {
        if (n < 0 || n >= this._length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        if (n < 32) {
            this._chars0[n] = c;
        } else if (n < 4096) {
            this._chars1[n >> 5][n & 0x1F] = c;
        } else if (n < 0x200000) {
            this._chars2[n >> 12][n >> 5 & 0x7F][n & 0x1F] = c;
        } else {
            this._chars3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F] = c;
        }
    }

    public final void setLength(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= this._length) {
            this._length = n;
        } else {
            int n2 = this._length;
            while (n2++ < n) {
                this.append('\u0000');
            }
        }
    }

    public final CharSequence subSequence(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > this._length) {
            throw new IndexOutOfBoundsException();
        }
        return Text.valueOf(this, n, n2);
    }

    public final TextBuilder append(char c) {
        int n;
        if (this._length >= this._capacity) {
            this.increaseCapacity();
        }
        if ((n = this._length++) < 32) {
            this._chars0[n] = c;
        } else if (n < 4096) {
            this._chars1[n >> 5][n & 0x1F] = c;
        } else if (n < 0x200000) {
            this._chars2[n >> 12][n >> 5 & 0x7F][n & 0x1F] = c;
        } else {
            this._chars3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F] = c;
        }
        return this;
    }

    public final TextBuilder append(CharSequence charSequence) {
        return charSequence == null ? this.append("null") : this.append(charSequence, 0, charSequence.length());
    }

    public final TextBuilder append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return this.append("null");
        }
        if (n < 0 || n2 < 0 || n > n2 || n2 > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n2) {
            this.append(charSequence.charAt(n3++));
        }
        return this;
    }

    public final TextBuilder append(Object object) {
        if (object instanceof String) {
            return this.append((String)object);
        }
        if (object instanceof CharSequence) {
            return this.append((CharSequence)object);
        }
        if (object instanceof Realtime) {
            return this.append(((Realtime)object).toText());
        }
        if (object != null) {
            return this.append(object.toString());
        }
        return this.append("null");
    }

    public final TextBuilder append(String string) {
        if (string == null) {
            return this.append("null");
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.append(string.charAt(n2++));
        }
        return this;
    }

    public final TextBuilder append(String string, int n, int n2) {
        if (string == null) {
            return this.append("null");
        }
        if (n < 0 || n2 < 0 || n > n2 || n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n2) {
            this.append(string.charAt(n3++));
        }
        return this;
    }

    public TextBuilder append(Text text) {
        if (text == null) {
            return this.append("null");
        }
        int n = text.length();
        int n2 = 0;
        while (n2 < n) {
            this.append(text.charAt(n2++));
        }
        return this;
    }

    public final TextBuilder append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public final TextBuilder append(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.append(cArray[n4++]);
        }
        return this;
    }

    public final TextBuilder append(boolean bl) {
        try {
            TypeFormat.format(bl, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final TextBuilder append(int n) {
        try {
            TypeFormat.format(n, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final TextBuilder append(int n, int n2) {
        try {
            TypeFormat.format(n, n2, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final TextBuilder append(long l) {
        try {
            TypeFormat.format(l, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final TextBuilder append(long l, int n) {
        try {
            TypeFormat.format(l, n, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final TextBuilder append(float f) {
        try {
            TypeFormat.format(f, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final TextBuilder append(double d) {
        try {
            TypeFormat.format(d, (Appendable)this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final TextBuilder append(double d, int n, boolean bl, boolean bl2) {
        try {
            TypeFormat.format(d, n, bl, bl2, this);
            return this;
        }
        catch (IOException iOException) {
            throw new JavolutionError(iOException);
        }
    }

    public final TextBuilder insert(int n, CharSequence charSequence) {
        if (n < 0 || n > this._length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = charSequence.length();
        this._length += n2;
        while (this._length >= this._capacity) {
            this.increaseCapacity();
        }
        int n3 = this._length - n2;
        while (--n3 >= n) {
            this.setCharAt(n3 + n2, this.charAt(n3));
        }
        n3 = charSequence.length();
        while (--n3 >= 0) {
            this.setCharAt(n + n3, charSequence.charAt(n3));
        }
        return this;
    }

    public final TextBuilder delete(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2;
        int n4 = n;
        while (n3 < this._length) {
            this.setCharAt(n4++, this.charAt(n3++));
        }
        this._length -= n2 - n;
        return this;
    }

    public final TextBuilder reverse() {
        int n = this._length - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            char c = this.charAt(n2);
            this.setCharAt(n2, this.charAt(n - n2));
            this.setCharAt(n - n2--, c);
        }
        return this;
    }

    public final Text toText() {
        return Text.valueOf(this, 0, this.length());
    }

    public final void reset() {
        this.setLength(0);
    }

    public final int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._length) {
            n = 31 * n + this.charAt(n2++);
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextBuilder)) {
            return false;
        }
        TextBuilder textBuilder = (TextBuilder)object;
        if (this._length != textBuilder._length) {
            return false;
        }
        int n = 0;
        while (n < this._length) {
            if (this.charAt(n) == textBuilder.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int n = TextBuilder.this._capacity;
                TextBuilder.this._capacity += 32;
                if (n < 4096) {
                    if (TextBuilder.this._chars1 == null) {
                        TextBuilder.access$102(TextBuilder.this, new char[128][]);
                    }
                    ((TextBuilder)TextBuilder.this)._chars1[n >> 5] = new char[32];
                } else if (n < 0x200000) {
                    if (TextBuilder.this._chars2 == null) {
                        TextBuilder.access$202(TextBuilder.this, new char[512][][]);
                    }
                    if (TextBuilder.this._chars2[n >> 12] == null) {
                        ((TextBuilder)TextBuilder.this)._chars2[n >> 12] = new char[128][];
                    }
                    ((TextBuilder)TextBuilder.this)._chars2[n >> 12][n >> 5 & 0x7F] = new char[32];
                } else {
                    if (TextBuilder.this._chars3 == null) {
                        TextBuilder.access$302(TextBuilder.this, new char[2048][][][]);
                    }
                    if (TextBuilder.this._chars3[n >> 21] == null) {
                        ((TextBuilder)TextBuilder.this)._chars3[n >> 21] = new char[512][][];
                    }
                    if (TextBuilder.this._chars3[n >> 21][n >> 12 & 0x1FF] == null) {
                        ((TextBuilder)TextBuilder.this)._chars3[n >> 21][n >> 12 & 0x1FF] = new char[128][];
                    }
                    ((TextBuilder)TextBuilder.this)._chars3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F] = new char[32];
                }
            }
        });
    }

    static /* synthetic */ char[][] access$102(TextBuilder textBuilder, char[][] cArray) {
        textBuilder._chars1 = cArray;
        return cArray;
    }

    static /* synthetic */ char[][][] access$202(TextBuilder textBuilder, char[][][] cArray) {
        textBuilder._chars2 = cArray;
        return cArray;
    }

    static /* synthetic */ char[][][][] access$302(TextBuilder textBuilder, char[][][][] cArray) {
        textBuilder._chars3 = cArray;
        return cArray;
    }
}

