/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Random_Sets.FSS98;

import keel.Algorithms.Fuzzy_Rule_Learning.Random_Sets.FSS98.Cluster;
import keel.Algorithms.Fuzzy_Rule_Learning.Random_Sets.FSS98.MatrixCalcs;
import org.core.Randomize;

public class RSFSS {
    double[][] X;
    double[] Y;
    double[] meanY;
    double[][][] Covar;
    double[][][] centres;
    double[][][] A;
    double[] w;

    private double[] clone(double[] x) {
        double[] res = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            res[i] = x[i];
        }
        return res;
    }

    private double[] truncate(double[] x) {
        double[] res = new double[x.length - 1];
        for (int i = 0; i < res.length; ++i) {
            res[i] = x[i];
        }
        return res;
    }

    private double[][] clone(double[][] x) {
        double[][] res = new double[x.length][];
        for (int i = 0; i < x.length; ++i) {
            res[i] = this.clone(x[i]);
        }
        return res;
    }

    private double[][] truncateColumn(double[][] x) {
        double[][] res = new double[x.length - 1][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.truncate(x[i]);
        }
        return res;
    }

    private double[][] truncateRow(double[][] x) {
        double[][] res = new double[x.length - 1][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.clone(x[i]);
        }
        return res;
    }

    private double[] insertRow(double[] x, double y) {
        double[] res = new double[x.length + 1];
        for (int i = 0; i < x.length; ++i) {
            res[i] = x[i];
        }
        res[res.length - 1] = y;
        return res;
    }

    Cluster groupTwoClusters(Cluster l, Cluster r) throws MatrixCalcs.DimensionError, MatrixCalcs.SingularError {
        Cluster result = new Cluster();
        double p = 1.0 * (double)l.n / (double)(l.n + r.n);
        result.n = l.n + r.n;
        result.m = MatrixCalcs.matSum(MatrixCalcs.matMul(l.m, p), MatrixCalcs.matMul(r.m, 1.0 - p));
        double[][] tmpl = MatrixCalcs.matMul(l.C, p);
        double[][] tmpr = MatrixCalcs.matMul(r.C, 1.0 - p);
        double[][] mresta = MatrixCalcs.matDif(l.m, r.m);
        double[][] tmpm = MatrixCalcs.matMul(mresta, MatrixCalcs.tr(mresta));
        tmpm = MatrixCalcs.matMul(tmpm, p * (1.0 - p));
        result.C = MatrixCalcs.matSum(tmpl, MatrixCalcs.matSum(tmpr, tmpm));
        result.e = Math.log(MatrixCalcs.determinant(result.C));
        result.leftHandStree = l;
        result.rightHandStree = r;
        result.ord = -1;
        return result;
    }

    void setLabel(int[] c, Cluster cl, int val) {
        if (cl.ord >= 0) {
            c[cl.ord] = val;
        } else {
            this.setLabel(c, cl.leftHandStree, val);
            this.setLabel(c, cl.rightHandStree, val);
        }
    }

    public RSFSS(double[][] pX, double[] pY) {
        System.out.println("Generating an RSFSS");
        this.X = pX;
        this.Y = pY;
    }

    public void RSFSSX3(int NC, Randomize r, double sigma) {
        double[][] C0 = MatrixCalcs.matMul(MatrixCalcs.I(this.X[0].length + 1), sigma);
        Cluster[] dendogram = new Cluster[this.X.length];
        boolean[] unmarked = new boolean[this.X.length];
        try {
            int numclusters = this.X.length;
            for (int i = 0; i < this.X.length; ++i) {
                dendogram[i] = new Cluster();
                dendogram[i].m = MatrixCalcs.oneColumnMatrix(this.insertRow(this.X[i], this.Y[i]));
                dendogram[i].C = this.clone(C0);
                dendogram[i].n = 1;
                dendogram[i].e = Math.log(MatrixCalcs.determinant(dendogram[i].C));
                dendogram[i].leftHandStree = null;
                dendogram[i].rightHandStree = null;
                dendogram[i].ord = i;
            }
            do {
                double minEnergy = 0.0;
                int mini = 0;
                int minj = 0;
                boolean isTheFirst = true;
                for (int i = 0; i < this.X.length; ++i) {
                    if (unmarked[i]) continue;
                    for (int j = i + 1; j < this.X.length; ++j) {
                        if (unmarked[j]) continue;
                        Cluster tmp = this.groupTwoClusters(dendogram[i], dendogram[j]);
                        if (!(tmp.e < minEnergy) && !isTheFirst) continue;
                        isTheFirst = false;
                        minEnergy = tmp.e;
                        mini = i;
                        minj = j;
                    }
                }
                dendogram[mini] = this.groupTwoClusters(dendogram[mini], dendogram[minj]);
                unmarked[minj] = true;
                dendogram[minj].n = 0;
            } while (--numclusters != NC);
            this.A = new double[NC][][];
            this.Covar = new double[NC][][];
            int[] c = new int[this.X.length];
            this.centres = new double[NC][][];
            int[] num = new int[NC];
            this.meanY = new double[NC];
            this.w = new double[NC];
            int theRule = 0;
            for (int example = 0; example < this.X.length; ++example) {
                if (unmarked[example]) continue;
                System.out.println("Cluster labelling " + theRule);
                this.Covar[theRule] = MatrixCalcs.inv(this.truncateColumn(dendogram[example].C));
                this.setLabel(c, dendogram[example], theRule);
                this.centres[theRule] = this.truncateRow(dendogram[example].m);
                this.meanY[theRule] = dendogram[example].m[dendogram[example].m.length - 1][0];
                num[theRule] = dendogram[example].n;
                this.w[theRule] = 1.0 * (double)num[theRule] / (double)this.X.length * MatrixCalcs.determinant(this.Covar[theRule]);
                System.out.println("Cluster associated examples " + theRule + " = " + num[theRule]);
                ++theRule;
            }
            double[] theWeights = new double[c.length];
            for (theRule = 0; theRule < NC; ++theRule) {
                int i;
                System.out.println("Consequent processing " + theRule);
                double[][] Xm = new double[num[theRule]][this.X[0].length];
                double[][] Ym = new double[num[theRule]][1];
                int example = 0;
                for (i = 0; i < this.X.length; ++i) {
                    if (c[i] != theRule) continue;
                    for (int j = 0; j < Xm[example].length; ++j) {
                        Xm[example][j] = this.X[i][j] - this.centres[theRule][j][0];
                    }
                    Ym[example][0] = this.Y[i] - this.meanY[c[i]];
                    ++example;
                }
                this.A[theRule] = MatrixCalcs.matMul(MatrixCalcs.matMul(MatrixCalcs.inv(MatrixCalcs.matMul(MatrixCalcs.tr(Xm), Xm)), MatrixCalcs.tr(Xm)), Ym);
                System.out.print("Rule coefficient " + theRule + " ");
                for (i = 0; i < this.A[theRule].length; ++i) {
                    System.out.print(this.A[theRule][i][0] + " ");
                }
                System.out.print(" Y=" + this.meanY[theRule] + " centres=");
                for (i = 0; i < this.centres[theRule].length; ++i) {
                    System.out.print(this.centres[theRule][i][0] + " ");
                }
                System.out.println();
            }
        }
        catch (MatrixCalcs.SingularError e) {
            System.err.println("Singular Matrix: " + e);
        }
        catch (MatrixCalcs.DimensionError e) {
            System.err.println("Internal Error: " + e);
        }
    }

    double evaluateMembership(double[] x, double[][] c, double[][] C) throws MatrixCalcs.DimensionError {
        double[][] xc = MatrixCalcs.matDif(MatrixCalcs.oneRowMatrix(x), MatrixCalcs.tr(c));
        double[][] tmp = MatrixCalcs.matMul(xc, C);
        tmp = MatrixCalcs.matMul(tmp, MatrixCalcs.tr(xc));
        return Math.exp(-0.5 * tmp[0][0]);
    }

    double predy(double[] x, double[][] c, double[][] A, double my) {
        double suma = 0.0;
        for (int i = 0; i < x.length; ++i) {
            suma += (x[i] - c[i][0]) * A[i][0];
        }
        return my + suma;
    }

    public double[] getOutput(double[] x) {
        double num = 0.0;
        double den = 0.0;
        try {
            for (int i = 0; i < this.Covar.length; ++i) {
                double mu = this.evaluateMembership(x, this.centres[i], this.Covar[i]);
                double sal = this.predy(x, this.centres[i], this.A[i], this.meanY[i]);
                num += this.w[i] * mu * sal;
                den += this.w[i] * mu;
            }
        }
        catch (MatrixCalcs.DimensionError e) {
            System.err.println("Internal Error");
        }
        double[] res = new double[1];
        if (den > 0.0) {
            res[0] = num / den;
        }
        return res;
    }

    public void RSFSSX2(int NC, Randomize r, double sigma) {
        double[][] C0 = MatrixCalcs.matMul(MatrixCalcs.I(this.X[0].length), sigma);
        Cluster[] dendogram = new Cluster[this.X.length];
        boolean[] unmarked = new boolean[this.X.length];
        try {
            int numclusters = this.X.length;
            for (int i = 0; i < this.X.length; ++i) {
                dendogram[i] = new Cluster();
                dendogram[i].m = this.clone(MatrixCalcs.oneColumnMatrix(this.X[i]));
                dendogram[i].C = this.clone(C0);
                dendogram[i].n = 1;
                dendogram[i].e = Math.log(MatrixCalcs.determinant(dendogram[i].C));
                dendogram[i].leftHandStree = null;
                dendogram[i].rightHandStree = null;
                dendogram[i].ord = i;
            }
            do {
                double minEnergy = 0.0;
                int mini = 0;
                int minj = 0;
                boolean theFirst = true;
                for (int i = 0; i < this.X.length; ++i) {
                    if (unmarked[i]) continue;
                    for (int j = i + 1; j < this.X.length; ++j) {
                        if (unmarked[j]) continue;
                        Cluster tmp = this.groupTwoClusters(dendogram[i], dendogram[j]);
                        if (!(tmp.e < minEnergy) && !theFirst) continue;
                        theFirst = false;
                        minEnergy = tmp.e;
                        mini = i;
                        minj = j;
                    }
                }
                dendogram[mini] = this.groupTwoClusters(dendogram[mini], dendogram[minj]);
                unmarked[minj] = true;
                dendogram[minj].n = 0;
            } while (--numclusters != NC);
            this.A = new double[NC][][];
            this.Covar = new double[NC][][];
            int[] c = new int[this.X.length];
            this.centres = new double[NC][][];
            this.w = new double[NC];
            int theRule = 0;
            for (int example = 0; example < this.X.length; ++example) {
                if (unmarked[example]) continue;
                System.out.println("Cluster labelling " + theRule);
                this.Covar[theRule] = MatrixCalcs.inv(dendogram[example].C);
                this.setLabel(c, dendogram[example], theRule);
                this.centres[theRule] = this.clone(dendogram[example].m);
                ++theRule;
            }
            int[] num = new int[NC];
            this.meanY = new double[NC];
            for (int example = 0; example < this.X.length; ++example) {
                int n = c[example];
                this.meanY[n] = this.meanY[n] + this.Y[example];
                int n2 = c[example];
                num[n2] = num[n2] + 1;
            }
            for (theRule = 0; theRule < NC; ++theRule) {
                System.out.println("Cluster association examples " + theRule + " = " + num[theRule]);
                int n = theRule;
                this.meanY[n] = this.meanY[n] / (double)num[theRule];
                this.w[theRule] = 1.0 * (double)num[theRule] / (double)this.X.length * MatrixCalcs.determinant(this.Covar[theRule]);
            }
            double[] theWeights = new double[c.length];
            for (theRule = 0; theRule < NC; ++theRule) {
                int i;
                System.out.println("Consequent processing " + theRule);
                double[][] Xm = new double[num[theRule]][this.X[0].length];
                double[][] Ym = new double[num[theRule]][1];
                int example = 0;
                for (int i2 = 0; i2 < this.X.length; ++i2) {
                    if (c[i2] != theRule) continue;
                    for (int j = 0; j < Xm[example].length; ++j) {
                        Xm[example][j] = this.X[i2][j] - this.centres[theRule][j][0];
                    }
                    Ym[example][0] = this.Y[i2] - this.meanY[c[i2]];
                    ++example;
                }
                try {
                    this.A[theRule] = MatrixCalcs.matMul(MatrixCalcs.matMul(MatrixCalcs.inv(MatrixCalcs.matMul(MatrixCalcs.tr(Xm), Xm)), MatrixCalcs.tr(Xm)), Ym);
                }
                catch (MatrixCalcs.SingularError e) {
                    System.err.println("Quite few examples for theRule " + theRule + " : " + e + " : ");
                    this.A[theRule] = new double[this.X[0].length][1];
                }
                System.out.print("Rule Coefficients " + theRule + " ");
                for (i = 0; i < this.A[theRule].length; ++i) {
                    System.out.print(this.A[theRule][i][0] + " ");
                }
                System.out.print(" Y=" + this.meanY[theRule] + " entres=");
                for (i = 0; i < this.centres[theRule].length; ++i) {
                    System.out.print(this.centres[theRule][i][0] + " ");
                }
                System.out.println();
            }
        }
        catch (MatrixCalcs.SingularError e) {
            System.err.println("Internal Error:" + e);
        }
        catch (MatrixCalcs.DimensionError e) {
            System.err.println("Internal Error: " + e);
        }
    }
}

