/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.DSM;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.LVQ.LVQ1;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class DSMGenerator
extends LVQ1 {
    public DSMGenerator(PrototypeSet tDataSet, int nIter, int nProt, double alpha_0) {
        super(tDataSet, nIter, nProt, alpha_0);
        this.algorithmName = "DSM";
    }

    public DSMGenerator(PrototypeSet tDataSet, int nIter, double percSize, double alpha_0) {
        super(tDataSet, nIter, percSize, alpha_0);
        this.algorithmName = "DSM";
    }

    public DSMGenerator(PrototypeSet tDataSet, Parameters param) {
        super(tDataSet, param);
        this.algorithmName = "DSM";
    }

    @Override
    protected void reward(Prototype m, Prototype x) {
        m.set(m.add(x.subMul(m, this.alpha_0)));
    }

    @Override
    protected void penalize(Prototype m, Prototype x) {
        m.set(m.sub(x.subMul(m, this.alpha_0)));
    }

    @Override
    protected void correct(Prototype i, PrototypeSet tData) {
        double nearestLabel;
        Prototype nearest = KNN._1nn(i, tData);
        double iLabel = i.label();
        if (iLabel != (nearestLabel = nearest.label())) {
            Prototype nearestSameLabel = KNN.getNearestWithSameClassAs(i, tData);
            this.penalize(nearest, i);
            if (nearestSameLabel != null) {
                this.reward(nearestSameLabel, i);
            }
        }
    }

    public static void main(String[] args) {
        Parameters.setUse("DSM", "<number of iterations> <seed> <number of iterations> <% of prototypes> <alpha_0>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        int iter = Parameters.assertExtendedArgAsInt(args, 3, "number of iterations", 1.0, 2.147483647E9);
        double percNProt = Parameters.assertExtendedArgAsInt(args, 4, "reduction size respect training size", 1.0, 100.0);
        double alpha = Parameters.assertExtendedArgAsDouble(args, 5, "alpha_0", 0.0, 1.0);
        DSMGenerator.setSeed(seed);
        DSMGenerator generator = new DSMGenerator(training, iter, percNProt, alpha);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

