/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes;

import java.util.Vector;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes.Genotype;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.Node;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeAnd;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeAssert;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeConsequent;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeIs;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeLabel;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeOr;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeRule;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeRuleBase;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeVariable;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.Fuzzy;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyPartition;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import org.core.Randomize;

public class GenotypeFuzzyGP
extends Genotype {
    static int MAXH;
    Node rootNode;
    Vector theNodes;
    Vector theParents;
    Vector theDepthAtEachNode;
    static FuzzyPartition[] A;
    static FuzzyPartition B;

    public GenotypeFuzzyGP(FuzzyPartition[] a, FuzzyPartition b, int mh, Randomize r) {
        super(r);
        this.theNodes = new Vector();
        this.theParents = new Vector();
        this.theDepthAtEachNode = new Vector();
        this.rootNode = new NodeRuleBase(new NodeRule[0]);
        A = a;
        B = b;
        MAXH = mh;
    }

    public GenotypeFuzzyGP(GenotypeFuzzyGP p) {
        super(rand);
        this.rootNode = p.rootNode.clone();
        this.buildNodeLists();
    }

    public void setTree(GenotypeFuzzyGP p) {
        this.rootNode = p.rootNode.clone();
        this.buildNodeLists();
    }

    @Override
    public Genotype clone() {
        return new GenotypeFuzzyGP(this);
    }

    @Override
    public boolean isRelated(Genotype g) {
        GenotypeFuzzyGP p = (GenotypeFuzzyGP)g;
        return this.rootNode.compatible(p.rootNode);
    }

    public void rebuild(Genotype g) {
    }

    @Override
    public void mutation(double alpha, int mutationID) throws invalidMutation {
        Node tmp;
        int typeOfValue;
        if (mutationID != 2) {
            throw new invalidMutation();
        }
        int mutationPoint = 0;
        while ((typeOfValue = (tmp = (Node)this.theNodes.elementAt(mutationPoint = (int)(rand.Rand() * (double)(this.theNodes.size() - 1)) + 1)).type()) == 0 || typeOfValue == 2 || typeOfValue == 6) {
        }
        int nh = -1;
        tmp = (Node)this.theParents.elementAt(mutationPoint);
        for (int i = 0; i < tmp.nChildren(); ++i) {
            Node tmp1 = (Node)this.theParents.elementAt(mutationPoint);
            Node tmp2 = (Node)this.theNodes.elementAt(mutationPoint);
            if (tmp1.child(i) != tmp2) continue;
            nh = i;
            break;
        }
        tmp = (Node)this.theNodes.elementAt(mutationPoint);
        int T = tmp.type();
        int TN = 1;
        int par = 0;
        int val = 0;
        switch (T) {
            case 0: {
                NodeVariable tmp1 = (NodeVariable)this.theNodes.elementAt(mutationPoint);
                TN = 0;
                par = tmp1.getN();
                break;
            }
            case 1: {
                Node tmpr = (Node)this.theParents.elementAt(mutationPoint);
                NodeVariable tmp1 = (NodeVariable)tmpr.child(0);
                TN = 1;
                par = tmp1.getN();
                break;
            }
            case 2: {
                TN = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                val = (int)(rand.Rand() * 3.0);
                if (val == 0) {
                    TN = 3;
                    break;
                }
                if (val == 1) {
                    TN = 4;
                    break;
                }
                if (val != 2) break;
                TN = 5;
                break;
            }
            case 6: {
                TN = 6;
                break;
            }
            case 7: {
                TN = 7;
            }
        }
        tmp = (Node)this.theParents.elementAt(mutationPoint);
        Integer itmp = (Integer)this.theDepthAtEachNode.elementAt(mutationPoint);
        tmp.changeChild(this.RandomTree(TN, MAXH - itmp, par), nh);
        this.buildNodeLists();
    }

    @Override
    public void crossover(Genotype p2, Genotype p3, Genotype p4, int crossoverID) throws invalidCrossover {
        Node tmp;
        int typeOfValue;
        if (crossoverID != 1) {
            throw new invalidCrossover();
        }
        GenotypeFuzzyGP f3 = (GenotypeFuzzyGP)p3;
        GenotypeFuzzyGP f4 = (GenotypeFuzzyGP)p4;
        f3.setTree(this);
        f4.setTree((GenotypeFuzzyGP)p2);
        int firstCrossPoint = 0;
        while ((typeOfValue = (tmp = (Node)f3.theNodes.elementAt(firstCrossPoint = (int)(rand.Rand() * (double)(f3.theNodes.size() - 1)) + 1)).type()) == 0 || typeOfValue == 2 || typeOfValue == 6) {
        }
        GenotypeFuzzyGP f2 = (GenotypeFuzzyGP)p2;
        tmp = (Node)f3.theNodes.elementAt(firstCrossPoint);
        int T1 = tmp.type();
        Vector<Integer> ableToCrossNodes = new Vector<Integer>();
        switch (T1) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                Integer itmp;
                int i;
                for (i = 0; i < f4.theNodes.size(); ++i) {
                    tmp = (Node)f4.theNodes.elementAt(i);
                    itmp = (Integer)this.theDepthAtEachNode.elementAt(firstCrossPoint);
                    if (tmp.type() != T1 || MAXH - itmp < this.getHeight(tmp)) continue;
                    ableToCrossNodes.addElement(new Integer(i));
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Integer itmp;
                int i;
                for (i = 0; i < f4.theNodes.size(); ++i) {
                    tmp = (Node)f4.theNodes.elementAt(i);
                    typeOfValue = tmp.type();
                    itmp = (Integer)this.theDepthAtEachNode.elementAt(firstCrossPoint);
                    if (typeOfValue != 3 && typeOfValue != 4 && typeOfValue != 5 || MAXH - itmp < this.getHeight(tmp)) continue;
                    ableToCrossNodes.addElement(new Integer(i));
                }
                break;
            }
        }
        if (ableToCrossNodes.size() != 0) {
            int secondCrossPoint = (int)(rand.Rand() * (double)ableToCrossNodes.size());
            int nh = -1;
            tmp = (Node)f3.theParents.elementAt(firstCrossPoint);
            Node tmp1 = (Node)f3.theNodes.elementAt(firstCrossPoint);
            for (int i = 0; i < tmp.nChildren(); ++i) {
                if (tmp.child(i) != tmp1) continue;
                nh = i;
                break;
            }
            int nh1 = -1;
            Integer itmp = (Integer)ableToCrossNodes.elementAt(secondCrossPoint);
            tmp = (Node)f4.theParents.elementAt(itmp);
            tmp1 = (Node)f4.theNodes.elementAt(itmp);
            for (int i = 0; i < tmp.nChildren(); ++i) {
                if (tmp.child(i) != tmp1) continue;
                nh1 = i;
                break;
            }
            tmp = (Node)f3.theParents.elementAt(firstCrossPoint);
            itmp = (Integer)ableToCrossNodes.elementAt(secondCrossPoint);
            tmp1 = (Node)f4.theParents.elementAt(itmp);
            Node tmpswap = tmp.child(nh);
            tmp.changeChild(tmp1.child(nh1), nh);
            tmp1.changeChild(tmpswap, nh1);
            f3.buildNodeLists();
            f4.buildNodeLists();
        }
    }

    @Override
    public void Random() {
        this.rootNode = (NodeRuleBase)this.RandomTree(7, MAXH, 0);
        this.buildNodeLists();
    }

    @Override
    public void debug() {
        this.rootNode.debug();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    private int getNumConsequents() {
        return B.size();
    }

    private int getNumInputs() {
        return A.length;
    }

    private Fuzzy getLabel(int nv, int nlabel) {
        return A[nv].getComponent(nlabel);
    }

    int getNumLabels(int nv) {
        return A[nv].size();
    }

    private int getHeight(Node n) {
        int mh = 0;
        for (int i = 0; i < n.nChildren(); ++i) {
            int h = this.getHeight(n.child(i));
            if (h <= mh) continue;
            mh = h;
        }
        return 1 + mh;
    }

    private void insertNode(Node n, Node parent, int p) {
        this.theNodes.addElement(n);
        this.theParents.addElement(parent);
        this.theDepthAtEachNode.addElement(new Integer(p));
        for (int i = 0; i < n.nChildren(); ++i) {
            this.insertNode(n.child(i), n, p + 1);
        }
    }

    private void buildNodeLists() {
        this.theNodes = new Vector();
        this.theParents = new Vector();
        this.theDepthAtEachNode = new Vector();
        this.insertNode(this.rootNode, null, 0);
    }

    Node RandomTree(int t, int maxh, int par) {
        switch (t) {
            case 0: {
                return new NodeVariable(par);
            }
            case 1: {
                int nlabel = (int)(rand.Rand() * (double)this.getNumLabels(par));
                return new NodeLabel(this.getLabel(par, nlabel));
            }
            case 2: {
                return new NodeConsequent(par);
            }
            case 3: {
                int[] tr = new int[2];
                for (int i = 0; i < 2; ++i) {
                    if (maxh <= 2) {
                        tr[i] = 5;
                        continue;
                    }
                    int tipoaserto = (int)(rand.Rand() * 3.0);
                    if (tipoaserto == 0) {
                        tr[i] = 3;
                        continue;
                    }
                    if (tipoaserto == 1) {
                        tr[i] = 4;
                        continue;
                    }
                    if (tipoaserto != 2) continue;
                    tr[i] = 5;
                }
                NodeAssert na1 = (NodeAssert)this.RandomTree(tr[0], maxh - 1, 0);
                NodeAssert na2 = (NodeAssert)this.RandomTree(tr[1], maxh - 1, 0);
                NodeAnd result = new NodeAnd(na1, na2);
                return result;
            }
            case 4: {
                int[] tr = new int[2];
                for (int i = 0; i < 2; ++i) {
                    if (maxh <= 2) {
                        tr[i] = 5;
                        continue;
                    }
                    int tipoaserto = (int)(rand.Rand() * 3.0);
                    if (tipoaserto == 0) {
                        tr[i] = 3;
                        continue;
                    }
                    if (tipoaserto == 1) {
                        tr[i] = 4;
                        continue;
                    }
                    if (tipoaserto != 2) continue;
                    tr[i] = 5;
                }
                NodeAssert na1 = (NodeAssert)this.RandomTree(tr[0], maxh - 1, 0);
                NodeAssert na2 = (NodeAssert)this.RandomTree(tr[1], maxh - 1, 0);
                NodeOr result = new NodeOr(na1, na2);
                return result;
            }
            case 5: {
                int nv = (int)(rand.Rand() * (double)this.getNumInputs());
                NodeVariable nvar = (NodeVariable)this.RandomTree(0, maxh - 1, nv);
                NodeLabel nval = (NodeLabel)this.RandomTree(1, maxh - 1, nv);
                NodeIs result = new NodeIs(nvar, nval);
                return result;
            }
            case 6: {
                int tipoaserto = (int)(rand.Rand() * 3.0);
                int tr = 3;
                if (tipoaserto == 0) {
                    tr = 3;
                } else if (tipoaserto == 1) {
                    tr = 4;
                } else if (tipoaserto == 2) {
                    tr = 5;
                }
                NodeAssert na = (NodeAssert)this.RandomTree(tr, maxh - 1, 0);
                int ncons = (int)(rand.Rand() * (double)this.getNumConsequents());
                NodeConsequent nc = (NodeConsequent)this.RandomTree(2, maxh - 1, par);
                NodeRule result = new NodeRule(na, nc, 1.0);
                return result;
            }
            case 7: {
                NodeRule[] praiz = new NodeRule[this.getNumConsequents()];
                for (int i = 0; i < praiz.length; ++i) {
                    praiz[i] = (NodeRule)this.RandomTree(6, maxh - 1, i);
                }
                NodeRuleBase result = new NodeRuleBase(praiz);
                return result;
            }
        }
        return new NodeVariable(par);
    }
}

