/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.lang.descr.ImportDescr;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class DialectCompiletimeRegistry {
    private final Map<String, Dialect> map = new HashMap<String, Dialect>();

    public void addDialect(String name, Dialect dialect) {
        this.map.put(name, dialect);
    }

    public Dialect getDialect(String name) {
        return this.map.get(name);
    }

    public void compileAll() {
        for (Dialect dialect : this.map.values()) {
            dialect.compileAll();
        }
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public List<KnowledgeBuilderResult> addResults(List<KnowledgeBuilderResult> list) {
        if (list == null) {
            list = new ArrayList<KnowledgeBuilderResult>();
        }
        for (Dialect dialect : this.map.values()) {
            List<KnowledgeBuilderResult> results = dialect.getResults();
            if (results == null) continue;
            for (KnowledgeBuilderResult result : results) {
                if (list.contains(result)) continue;
                list.add(result);
            }
            dialect.clearResults();
        }
        return list;
    }

    public void addImport(ImportDescr importDescr) {
        for (Dialect dialect : this.map.values()) {
            dialect.addImport(importDescr);
        }
    }

    public void addStaticImport(ImportDescr importDescr) {
        for (Dialect dialect : this.map.values()) {
            dialect.addStaticImport(importDescr);
        }
    }
}

