/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.evomodel.antigenic.AntigenicTraitLikelihood;
import dr.evomodel.antigenic.MultidimensionalScalingLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.util.DataTable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@Deprecated
public class DiscreteAntigenicTraitLikelihood
extends AntigenicTraitLikelihood
implements Citable {
    public static final String DISCRETE_ANTIGENIC_TRAIT_LIKELIHOOD = "discreteAntigenicTraitLikelihood";
    private static final int CLUSTER_COUNT = -1;
    private CompoundParameter tipTraitParameter;
    private int[] tipIndices;
    private int maxClusterCount;
    private final Parameter clusterIndexParameter;
    private final int[] clusterSizes;
    private int clusterCount;
    private boolean clusterMaskKnown;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String FILE_NAME = "fileName";
        public static final String VIRUS_MAP_FILE_NAME = "virusMapFile";
        public static final String ASSAY_MAP_FILE_NAME = "assayMapFile";
        public static final String CLUSTER_INDICES = "clusterIndices";
        public static final String TIP_TRAIT = "tipTrait";
        public static final String LOCATIONS = "locations";
        public static final String MDS_DIMENSION = "mdsDimension";
        public static final String MDS_PRECISION = "mdsPrecision";
        public static final String VIRUS_LOCATIONS = "virusLocations";
        public static final String LOG_2_TRANSFORM = "log2Transform";
        public static final String TITRATION_THRESHOLD = "titrationThreshold";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("fileName", false, "The name of the file containing the assay table"), AttributeRule.newStringRule("virusMapFile", true, "The name of the file containing the virus to serum map"), AttributeRule.newStringRule("assayMapFile", true, "The name of the file containing the assay to serum map"), AttributeRule.newIntegerRule("mdsDimension", false, "The dimension of the space for MDS"), AttributeRule.newBooleanRule("log2Transform", true, "Whether to log2 transform the data"), AttributeRule.newStringArrayRule("virusLocations", true, "A list of virus names to create location statistics for"), new ElementRule("clusterIndices", Parameter.class, "The parameter of cluster indices for each virus/serum"), new ElementRule("tipTrait", CompoundParameter.class, "The parameter of tip locations from the tree", true), new ElementRule("locations", MatrixParameter.class), new ElementRule("mdsPrecision", Parameter.class)};

        @Override
        public String getParserName() {
            return DiscreteAntigenicTraitLikelihood.DISCRETE_ANTIGENIC_TRAIT_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DataTable<String[]> dataTable;
            String string = xMLObject.getStringAttribute(FILE_NAME);
            try {
                dataTable = DataTable.Text.parse(new FileReader(string));
            }
            catch (IOException iOException) {
                throw new XMLParseException("Unable to read assay data from file: " + iOException.getMessage());
            }
            Map<String, String> map = null;
            if (xMLObject.hasAttribute(VIRUS_MAP_FILE_NAME)) {
                try {
                    map = this.readMap(xMLObject.getStringAttribute(VIRUS_MAP_FILE_NAME));
                }
                catch (IOException iOException) {
                    throw new XMLParseException("Virus map file not found: " + xMLObject.getStringAttribute(VIRUS_MAP_FILE_NAME));
                }
            }
            Map<String, String> map2 = null;
            if (xMLObject.hasAttribute(ASSAY_MAP_FILE_NAME)) {
                try {
                    map2 = this.readMap(xMLObject.getStringAttribute(ASSAY_MAP_FILE_NAME));
                }
                catch (IOException iOException) {
                    throw new XMLParseException("Assay map file not found: " + xMLObject.getStringAttribute(ASSAY_MAP_FILE_NAME));
                }
            }
            int n = xMLObject.getIntegerAttribute(MDS_DIMENSION);
            boolean bl = false;
            if (xMLObject.hasAttribute(LOG_2_TRANSFORM)) {
                bl = xMLObject.getBooleanAttribute(LOG_2_TRANSFORM);
            }
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(CLUSTER_INDICES);
            List<String> list = null;
            String[] stringArray = xMLObject.getStringArrayAttribute(VIRUS_LOCATIONS);
            if (stringArray != null) {
                list = Arrays.asList(stringArray);
            }
            CompoundParameter compoundParameter = null;
            if (xMLObject.hasChildNamed(TIP_TRAIT)) {
                compoundParameter = (CompoundParameter)xMLObject.getElementFirstChild(TIP_TRAIT);
            }
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(LOCATIONS);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(MDS_PRECISION);
            DiscreteAntigenicTraitLikelihood discreteAntigenicTraitLikelihood = new DiscreteAntigenicTraitLikelihood(n, parameter2, parameter, matrixParameter, compoundParameter, dataTable, map, map2, list, bl);
            Logger.getLogger("dr.evomodel").info("Using Discrete Evolutionary Cartography model. Please cite:\n" + Citable.Utils.getCitationString(discreteAntigenicTraitLikelihood));
            return discreteAntigenicTraitLikelihood;
        }

        private Map<String, String> readMap(String string) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray;
                if (string2.trim().length() > 0 && (stringArray = string2.split("\t")).length > 1) {
                    hashMap.put(stringArray[0], stringArray[1]);
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            return hashMap;
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of immunological assay data such as Hemagglutinin inhibition (HI) given vectors of coordinatesfor viruses and sera/antisera in some multidimensional 'antigenic' space. This is a discrete classifier form of the modelwhich assigns viruses to discrete antigenic classes.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return DiscreteAntigenicTraitLikelihood.class;
        }
    };

    /*
     * WARNING - void declaration
     */
    public DiscreteAntigenicTraitLikelihood(int n, Parameter parameter, Parameter parameter2, MatrixParameter matrixParameter, CompoundParameter compoundParameter, DataTable<String[]> dataTable, Map<String, String> map, Map<String, String> map2, List<String> list, boolean bl) {
        super(DISCRETE_ANTIGENIC_TRAIT_LIKELIHOOD);
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        void nArray3;
        String[] stringArray2 = dataTable.getRowLabels();
        String[] stringArray3 = dataTable.getColumnLabels();
        int n7 = dataTable.getRowCount();
        int n8 = dataTable.getColumnCount();
        int[] nArray = new int[stringArray3.length];
        double[][] dArray = new double[n7][n8];
        MultidimensionalScalingLikelihood.ObservationType[][] observationTypeArray = new MultidimensionalScalingLikelihood.ObservationType[n7][n8];
        this.initalizeTable(dataTable, dArray, observationTypeArray, bl);
        ArrayList<String> arrayList = null;
        if (compoundParameter != null) {
            arrayList = new ArrayList<String>();
            int n9 = compoundParameter.getParameterCount();
            for (int i = 0; i < n9; ++i) {
                String string = compoundParameter.getParameter(i).getParameterName();
                if (string.endsWith(".antigenic")) {
                    string = string.substring(0, string.indexOf(".antigenic"));
                }
                arrayList.add(string);
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int[] nArray2 = new int[n7];
        int n10 = 0;
        for (String stringArray4 : stringArray2) {
            void var26_33;
            void var26_36;
            Object var26_34 = null;
            if (map != null) {
                String string = map.get(stringArray4);
            }
            if (var26_36 == null) {
                String string = stringArray4;
            }
            nArray2[n10] = arrayList2.size();
            arrayList2.add(var26_33);
            ++n10;
        }
        ArrayList arrayList3 = new ArrayList();
        n10 = 0;
        String[] stringArray7 = stringArray3;
        int n12 = stringArray7.length;
        boolean bl2 = false;
        while (nArray3 < n12) {
            int n9;
            String string = stringArray7[nArray3];
            String string2 = null;
            if (map2 != null) {
                string2 = map2.get(string);
            }
            if (string2 == null) {
                string2 = string;
            }
            if ((n9 = arrayList3.indexOf(string2)) == -1) {
                n9 = arrayList3.size();
                arrayList3.add(string2);
            }
            nArray[n10] = n9;
            ++n10;
            ++nArray3;
        }
        stringArray7 = new String[arrayList3.size()];
        arrayList3.toArray(stringArray7);
        n12 = stringArray7.length;
        int[] nArray4 = new int[n12];
        n10 = 0;
        for (String string : stringArray7) {
            int n11 = arrayList2.indexOf(string);
            if (n11 == -1) {
                n11 = arrayList2.size();
                arrayList2.add(string);
            }
            nArray4[n10] = n11;
            ++n10;
        }
        String[] stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        int n13 = stringArray.length;
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        ArrayList<MultidimensionalScalingLikelihood.ObservationType> arrayList5 = new ArrayList<MultidimensionalScalingLikelihood.ObservationType>();
        int[] nArray5 = new int[n7];
        int[] nArray6 = new int[n12];
        ArrayList<Pair> arrayList6 = new ArrayList<Pair>();
        for (n6 = 0; n6 < n7; ++n6) {
            if (nArray2[n6] == -1) continue;
            for (n5 = 0; n5 < n8; ++n5) {
                n4 = nArray[n5];
                Double d = dArray[n6][n5];
                MultidimensionalScalingLikelihood.ObservationType observationType = observationTypeArray[n6][n5];
                if (observationType == MultidimensionalScalingLikelihood.ObservationType.MISSING) continue;
                arrayList4.add(d);
                arrayList5.add(observationType);
                arrayList6.add(new Pair(nArray2[n6], nArray4[n4]));
                int n14 = n6;
                nArray5[n14] = nArray5[n14] + 1;
                int n15 = n4;
                nArray6[n15] = nArray6[n15] + 1;
            }
        }
        for (n6 = 0; n6 < n7; ++n6) {
            if (nArray2[n6] == -1 || nArray5[n6] != 0) continue;
            System.err.println("WARNING: Virus " + stringArray2[n6] + " has 0 observations");
        }
        for (n6 = 0; n6 < n12; ++n6) {
            if (nArray6[n6] != 0) continue;
            System.err.println("WARNING: Antisera " + stringArray7[n6] + " has 0 observations");
        }
        double[] dArray2 = new double[arrayList4.size()];
        for (n5 = 0; n5 < arrayList4.size(); ++n5) {
            dArray2[n5] = (Double)arrayList4.get(n5);
        }
        int[] nArray7 = new int[arrayList6.size()];
        for (n4 = 0; n4 < nArray7.length; ++n4) {
            nArray7[n4] = ((Pair)arrayList6.get((int)n4)).location1;
        }
        int[] nArray8 = new int[arrayList6.size()];
        for (int i = 0; i < nArray8.length; ++i) {
            nArray8[i] = ((Pair)arrayList6.get((int)i)).location2;
        }
        MultidimensionalScalingLikelihood.ObservationType[] observationTypeArray2 = new MultidimensionalScalingLikelihood.ObservationType[arrayList5.size()];
        arrayList5.toArray(observationTypeArray2);
        int n16 = 0;
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            n16 += observationTypeArray2[n3] != MultidimensionalScalingLikelihood.ObservationType.POINT ? 1 : 0;
        }
        if (compoundParameter != null) {
            this.tipIndices = new int[n13];
            for (n3 = 0; n3 < n13; ++n3) {
                this.tipIndices[n3] = arrayList.indexOf(stringArray[n3]);
            }
            for (String string : arrayList) {
                if (arrayList2.contains(string)) continue;
                System.err.println("Tip, " + string + ", not found in location list");
            }
        } else {
            this.tipIndices = null;
        }
        this.tipTraitParameter = compoundParameter;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\tDiscreteAntigenicTraitLikelihood:\n");
        stringBuilder.append("\t\t" + stringArray2.length + " viruses\n");
        stringBuilder.append("\t\t" + stringArray3.length + " assays\n");
        stringBuilder.append("\t\t" + stringArray7.length + " antisera\n");
        stringBuilder.append("\t\t" + stringArray.length + " locations\n");
        stringBuilder.append("\t\t" + arrayList6.size() + " distances\n");
        stringBuilder.append("\t\t" + dArray2.length + " observations\n");
        stringBuilder.append("\t\t" + n16 + " threshold observations\n");
        Logger.getLogger("dr.evomodel").info(stringBuilder.toString());
        this.initialize(n, false, parameter, matrixParameter, stringArray, dArray2, observationTypeArray2, nArray7, nArray8);
        for (int i = 0; i < matrixParameter.getParameterCount(); ++i) {
            for (n2 = 0; n2 < n; ++n2) {
                double d = 0.0;
                d = n2 == 0 ? (double)i * 0.05 : MathUtils.nextGaussian();
                matrixParameter.getParameter(i).setParameterValueQuietly(n2, d);
            }
        }
        this.maxClusterCount = this.getLocationCount();
        this.clusterIndexParameter = parameter2;
        parameter2.setDimension(this.getLocationCount());
        this.clusterSizes = new int[this.maxClusterCount];
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(this.maxClusterCount - 1, 0.0, this.getLocationCount());
        parameter2.addBounds(defaultBounds);
        for (n2 = 0; n2 < this.getLocationCount(); ++n2) {
            int n17 = n2;
            parameter2.setParameterValue(n2, n17);
            for (int i = 0; i < n; ++i) {
                compoundParameter.setParameterValue(this.tipIndices[n17] * n + i, matrixParameter.getParameterValue(n17 * n + i));
            }
        }
        this.updateClusterSizes();
        this.addVariable(parameter2);
        this.addStatistic(new ClusterMask());
        this.addStatistic(new ClusterIndices());
        this.addStatistic(new ClusterCount());
        this.addStatistic(new ClusterSizes());
        this.addStatistic(new ClusteredLocations());
        n2 = 0;
        for (String string : stringArray2) {
            if (list.contains(string)) {
                this.addStatistic(new VirusLocation(string + ".location", n2));
            }
            ++n2;
        }
    }

    @Override
    protected void setupLocationsParameter(MatrixParameter matrixParameter) {
        matrixParameter.setColumnDimension(this.getMDSDimension());
        int n = -1;
        if (n < 1) {
            n = this.getLocationCount();
        }
        matrixParameter.setRowDimension(n);
        for (int i = 0; i < n; ++i) {
            matrixParameter.getParameter(i).setId("cluster_" + (i + 1));
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.clusterIndexParameter) {
            for (int i = 0; i < this.distanceUpdated.length; ++i) {
                this.distanceUpdated[i] = true;
            }
            this.residualsKnown = false;
            this.thresholdsKnown = false;
            this.clusterMaskKnown = false;
        }
        if (this.tipTraitParameter != null) {
            MatrixParameter matrixParameter = this.getLocationsParameter();
            int n2 = this.getMDSDimension();
            if (variable == matrixParameter) {
                int n3 = n / n2;
                int n4 = n % n2;
                for (int i = 0; i < this.clusterIndexParameter.getDimension(); ++i) {
                    if ((int)this.clusterIndexParameter.getParameterValue(i) != n3 || this.tipIndices[i] == -1) continue;
                    this.tipTraitParameter.setParameterValue(this.tipIndices[i] * n2 + n4, matrixParameter.getParameterValue(n));
                }
            } else if (variable == this.clusterIndexParameter && this.tipIndices[n] != -1) {
                int n5 = (int)this.clusterIndexParameter.getParameterValue(n);
                for (int i = 0; i < n2; ++i) {
                    this.tipTraitParameter.setParameterValue(this.tipIndices[n] * n2 + i, matrixParameter.getParameterValue(n5 * n2 + i));
                }
            }
        }
        super.handleVariableChangedEvent(variable, n, changeType);
    }

    public CompoundParameter getTipTraitParameter() {
        return this.tipTraitParameter;
    }

    public int[] getTipIndices() {
        return this.tipIndices;
    }

    @Override
    public void makeDirty() {
        super.makeDirty();
        this.clusterMaskKnown = false;
    }

    @Override
    protected void storeState() {
        super.storeState();
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        this.clusterMaskKnown = false;
    }

    @Override
    protected int getLocationIndex(int n) {
        return (int)this.clusterIndexParameter.getParameterValue(n);
    }

    private void updateClusterSizes() {
        int n;
        for (n = 0; n < this.maxClusterCount; ++n) {
            this.clusterSizes[n] = 0;
        }
        for (n = 0; n < this.getLocationCount(); ++n) {
            int n2;
            int n3 = n2 = (int)this.clusterIndexParameter.getParameterValue(n);
            this.clusterSizes[n3] = this.clusterSizes[n3] + 1;
        }
        this.clusterCount = 0;
        for (n = 0; n < this.maxClusterCount; ++n) {
            if (this.clusterSizes[n] <= 0) continue;
            ++this.clusterCount;
        }
        this.clusterMaskKnown = true;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Bayesian Antigenic Cartography framework";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(CommonCitations.BEDFORD_2015_INTEGRATING);
    }

    private class Pair {
        int location1;
        int location2;

        Pair(int n, int n2) {
            if (n < n2) {
                this.location1 = n;
                this.location2 = n2;
            } else {
                this.location1 = n2;
                this.location2 = n;
            }
        }

        public boolean equals(Object object) {
            return ((Pair)object).location1 == this.location1 && ((Pair)object).location2 == this.location2;
        }

        public String toString() {
            return "" + this.location1 + ", " + this.location2;
        }
    }

    public class VirusLocation
    extends Statistic.Abstract {
        private final int virusIndex;

        public VirusLocation(String string, int n) {
            super(string);
            this.virusIndex = n;
        }

        @Override
        public String getDimensionName(int n) {
            if (DiscreteAntigenicTraitLikelihood.this.getMDSDimension() == 2) {
                return this.getStatisticName() + "_" + (n == 0 ? "X" : "Y");
            }
            return this.getStatisticName() + "_" + (n + 1);
        }

        @Override
        public int getDimension() {
            return DiscreteAntigenicTraitLikelihood.this.getMDSDimension();
        }

        @Override
        public double getStatisticValue(int n) {
            int n2 = (int)DiscreteAntigenicTraitLikelihood.this.clusterIndexParameter.getParameterValue(this.virusIndex);
            Parameter parameter = DiscreteAntigenicTraitLikelihood.this.getLocationsParameter().getParameter(n2);
            return parameter.getParameterValue(n);
        }
    }

    public class ClusteredLocations
    extends Statistic.Abstract {
        public ClusteredLocations() {
            super("clusteredLocations");
        }

        @Override
        public String getDimensionName(int n) {
            int n2 = n / DiscreteAntigenicTraitLikelihood.this.getMDSDimension();
            int n3 = n % DiscreteAntigenicTraitLikelihood.this.getMDSDimension();
            String string = DiscreteAntigenicTraitLikelihood.this.getLocationLabels()[n2];
            if (DiscreteAntigenicTraitLikelihood.this.getMDSDimension() == 2) {
                return string + "_" + (n3 == 0 ? "X" : "Y");
            }
            return string + "_" + (n3 + 1);
        }

        @Override
        public int getDimension() {
            return DiscreteAntigenicTraitLikelihood.this.getLocationCount() * DiscreteAntigenicTraitLikelihood.this.getMDSDimension();
        }

        @Override
        public double getStatisticValue(int n) {
            int n2 = n / DiscreteAntigenicTraitLikelihood.this.getMDSDimension();
            int n3 = n % DiscreteAntigenicTraitLikelihood.this.getMDSDimension();
            int n4 = (int)DiscreteAntigenicTraitLikelihood.this.clusterIndexParameter.getParameterValue(n2);
            Parameter parameter = DiscreteAntigenicTraitLikelihood.this.getLocationsParameter().getParameter(n4);
            return parameter.getParameterValue(n3);
        }
    }

    public class ClusterSizes
    extends Statistic.Abstract {
        public ClusterSizes() {
            super("clusterSizes");
        }

        @Override
        public int getDimension() {
            return DiscreteAntigenicTraitLikelihood.this.maxClusterCount;
        }

        @Override
        public double getStatisticValue(int n) {
            if (!DiscreteAntigenicTraitLikelihood.this.clusterMaskKnown) {
                DiscreteAntigenicTraitLikelihood.this.updateClusterSizes();
            }
            return DiscreteAntigenicTraitLikelihood.this.clusterSizes[n];
        }
    }

    public class ClusterCount
    extends Statistic.Abstract {
        public ClusterCount() {
            super("clusterCount");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            if (!DiscreteAntigenicTraitLikelihood.this.clusterMaskKnown) {
                DiscreteAntigenicTraitLikelihood.this.updateClusterSizes();
            }
            return DiscreteAntigenicTraitLikelihood.this.clusterCount;
        }
    }

    public class ClusterIndices
    extends Statistic.Abstract {
        public ClusterIndices() {
            super("clusterIndices");
        }

        @Override
        public int getDimension() {
            return DiscreteAntigenicTraitLikelihood.this.clusterIndexParameter.getDimension();
        }

        @Override
        public String getDimensionName(int n) {
            return DiscreteAntigenicTraitLikelihood.this.getLocationLabels()[n];
        }

        @Override
        public double getStatisticValue(int n) {
            return DiscreteAntigenicTraitLikelihood.this.clusterIndexParameter.getParameterValue(n);
        }
    }

    public class ClusterMask
    extends Statistic.Abstract {
        public ClusterMask() {
            super("clusterMask");
        }

        @Override
        public int getDimension() {
            return DiscreteAntigenicTraitLikelihood.this.maxClusterCount;
        }

        @Override
        public double getStatisticValue(int n) {
            if (!DiscreteAntigenicTraitLikelihood.this.clusterMaskKnown) {
                DiscreteAntigenicTraitLikelihood.this.updateClusterSizes();
            }
            return DiscreteAntigenicTraitLikelihood.this.clusterSizes[n] > 0 ? 1.0 : 0.0;
        }
    }
}

