/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc.obsolete;

import dr.evolution.tree.NodeRef;
import dr.evomodel.antigenic.phyloclustering.misc.obsolete.AGLikelihoodTreeCluster;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;

public class TreeClusterSequentialSampling
extends SimpleMCMCOperator
implements GibbsOperator {
    Parameter virusOffsetsParameter;
    private double sigmaSq = 1.0;
    private int numdata = 0;
    private MatrixParameter mu = null;
    private Parameter clusterLabels = null;
    private Parameter K = null;
    private MatrixParameter virusLocations = null;
    private int maxLabel = 0;
    private int[] muLabels = null;
    private int[] groupSize;
    private double numAcceptMoveMu = 0.0;
    private double numProposeMoveMu = 0.0;
    private double numAcceptMoveC = 0.0;
    private double numProposeMoveC = 0.0;
    private int isMoveMu = -1;
    private double[] old_vLoc0;
    private double[] old_vLoc1;
    private Parameter clusterOffsetsParameter;
    private AGLikelihoodTreeCluster clusterLikelihood = null;
    private int groupSelectedChange = -1;
    private int virusIndexChange = -1;
    private double originalValueChange = -1.0;
    private int dimSelectChange = -1;
    private double[] mu0_offset;
    private Parameter breakPoints = null;
    private int binSize = 20;
    private Parameter status;
    private TreeModel treeModel;
    int[] membershipToClusterLabelIndexes = null;
    private int numNodes;
    public static final String TREE_CLUSTERSEQUENTIAL_OPERATOR = "TreeClusterSequentialSampling";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String VIRUSLOCATIONS = "virusLocations";
        public static final String MU = "mu";
        public static final String CLUSTERLABELS = "clusterLabels";
        public static final String K = "k";
        public static final String OFFSETS = "offsets";
        public static final String CLUSTER_OFFSETS = "clusterOffsetsParameter";
        public static final String INDICATORS = "indicators";
        public static final String EXCISION_POINTS = "excisionPoints";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("virusLocations", Parameter.class), new ElementRule("mu", Parameter.class), new ElementRule("clusterLabels", Parameter.class), new ElementRule("k", Parameter.class), new ElementRule("offsets", Parameter.class), new ElementRule("clusterOffsetsParameter", Parameter.class, "Parameter of cluster offsets of all virus"), new ElementRule("indicators", Parameter.class), new ElementRule("excisionPoints", Parameter.class), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return TreeClusterSequentialSampling.TREE_CLUSTERSEQUENTIAL_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            XMLObject xMLObject2 = xMLObject.getChild(VIRUSLOCATIONS);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(CLUSTERLABELS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(K);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(OFFSETS);
            Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
            Parameter parameter4 = null;
            if (xMLObject.hasChildNamed(CLUSTER_OFFSETS)) {
                parameter4 = (Parameter)xMLObject.getElementFirstChild(CLUSTER_OFFSETS);
            }
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter5 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(EXCISION_POINTS);
            Parameter parameter6 = (Parameter)xMLObject2.getChild(Parameter.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            AGLikelihoodTreeCluster aGLikelihoodTreeCluster = (AGLikelihoodTreeCluster)xMLObject.getChild(AGLikelihoodTreeCluster.class);
            return new TreeClusterSequentialSampling(matrixParameter, matrixParameter2, parameter, parameter2, d, parameter3, parameter4, parameter5, parameter6, treeModel, aGLikelihoodTreeCluster);
        }

        @Override
        public String getParserDescription() {
            return "An operator that picks a new allocation of an item to a cluster under the Dirichlet process.";
        }

        @Override
        public Class getReturnType() {
            return TreeClusterSequentialSampling.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TreeClusterSequentialSampling(MatrixParameter matrixParameter, MatrixParameter matrixParameter2, Parameter parameter, Parameter parameter2, double d, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, TreeModel treeModel, AGLikelihoodTreeCluster aGLikelihoodTreeCluster) {
        int n;
        int n2;
        System.out.println("Loading the constructor for Sequential sampler");
        this.clusterLikelihood = aGLikelihoodTreeCluster;
        this.treeModel = treeModel;
        this.mu = matrixParameter2;
        this.K = parameter2;
        this.clusterLabels = parameter;
        this.virusLocations = matrixParameter;
        this.virusOffsetsParameter = parameter3;
        this.clusterOffsetsParameter = parameter4;
        this.breakPoints = parameter5;
        this.status = parameter6;
        this.numdata = parameter3.getSize();
        System.out.println("numdata=" + this.numdata);
        int n3 = (int)parameter2.getParameterValue(0);
        System.out.println("K_int=" + n3);
        this.groupSize = new int[this.binSize];
        for (n2 = 0; n2 < this.binSize; ++n2) {
            this.groupSize[n2] = 0;
        }
        for (n2 = 0; n2 < this.numdata; ++n2) {
            int n4 = n = (int)parameter.getParameterValue(n2);
            this.groupSize[n4] = this.groupSize[n4] + 1;
        }
        for (n2 = 0; n2 < this.numdata; ++n2) {
            if (this.maxLabel >= (int)parameter.getParameterValue(n2)) continue;
            this.maxLabel = (int)parameter.getParameterValue(n2);
        }
        this.muLabels = new int[this.binSize];
        for (n2 = 0; n2 < this.maxLabel; ++n2) {
            n = 0;
            if (this.groupSize[n2] <= 0) continue;
            this.muLabels[n] = n2;
            ++n;
        }
        this.setWeight(d);
        System.out.println("Finished loading the constructor for ClusterAlgorithmOperator");
    }

    @Override
    public final double doOperation() {
        int n;
        int n2;
        System.out.println("do operation of sequential sampling");
        this.setMembershipToClusterLabelIndexes();
        this.numNodes = this.treeModel.getNodeCount();
        this.updateK();
        int n3 = (int)this.K.getParameterValue(0);
        int[] nArray = new int[n3];
        int[] nArray2 = new int[this.numNodes];
        int[] nArray3 = null;
        int[] nArray4 = new int[n3];
        int n4 = 0;
        for (n2 = 0; n2 < this.binSize; ++n2) {
            if ((int)this.status.getParameterValue(n2) != 1) continue;
            nArray4[n4] = n2;
            ++n4;
        }
        nArray = new int[]{785};
        nArray4 = new int[]{0};
        this.resetStatusAndBreakpointsGivenCutNodes(nArray, nArray4);
        nArray3 = this.setClusterLabelsByTestCutNodeByNodeOrder(nArray);
        this.relabelClusterLabels(nArray3, nArray2);
        for (n2 = 0; n2 < this.numdata; ++n2) {
            this.clusterLabels.setParameterValue(n2, nArray3[n2]);
        }
        this.setVirusLocationAutoCorrelatedModel();
        double d = this.clusterLikelihood.getLogLikelihood();
        System.out.println(d);
        nArray = new int[2];
        nArray[0] = 785;
        nArray4 = new int[]{0, 1};
        double[] dArray = new double[this.numNodes];
        for (int i = 0; i < this.numNodes; ++i) {
            int n5 = this.checkSiteHasBeenAddedToOnIndicators(i);
            if (n5 == 0) {
                nArray = new int[]{785, i};
                this.resetStatusAndBreakpointsGivenCutNodes(nArray, nArray4);
                nArray3 = this.setClusterLabelsByTestCutNodeByNodeOrder(nArray);
                this.relabelClusterLabels(nArray3, nArray2);
                for (int j = 0; j < this.numdata; ++j) {
                    this.clusterLabels.setParameterValue(j, nArray3[j]);
                }
                this.setVirusLocationAutoCorrelatedModel();
                int n6 = i;
                dArray[n6] = dArray[n6] + this.clusterLikelihood.getLogLikelihood();
                continue;
            }
            dArray[i] = Double.NEGATIVE_INFINITY;
            System.out.println("Don't calculate for node" + nArray[0]);
        }
        double d2 = this.verifyAssumption(d, dArray);
        System.out.println("the ratio is " + d2);
        System.exit(0);
        double d3 = this.mu.getParameter(nArray4[7] + 1).getParameterValue(0);
        double d4 = this.mu.getParameter(nArray4[7] + 1).getParameterValue(1);
        this.mu.getParameter(nArray4[7] + 1).setParameterValue(0, this.mu.getParameter(nArray4[8] + 1).getParameterValue(0));
        this.mu.getParameter(nArray4[7] + 1).setParameterValue(1, this.mu.getParameter(nArray4[8] + 1).getParameterValue(1));
        this.mu.getParameter(nArray4[8] + 1).setParameterValue(0, d3);
        this.mu.getParameter(nArray4[8] + 1).setParameterValue(1, d4);
        for (n = 8; n < n3; ++n) {
            int n7;
            int[] nArray5;
            int n8;
            nArray[0] = 785;
            nArray[1] = 775;
            nArray[2] = 763;
            nArray[3] = 697;
            nArray[4] = 747;
            nArray[5] = 679;
            nArray[6] = 662;
            nArray[7] = 638;
            double[] dArray2 = new double[this.numNodes];
            for (int i = 0; i < this.numNodes; ++i) {
                n8 = this.checkSiteHasBeenAddedToOnIndicators(i);
                if (n8 == 0) {
                    nArray5 = new int[n + 1];
                    for (n7 = 0; n7 < n; ++n7) {
                        nArray5[n7] = nArray[n7];
                    }
                    nArray5[n] = i;
                    this.resetStatusAndBreakpointsGivenCutNodes(nArray5, nArray4);
                    nArray3 = this.setClusterLabelsByTestCutNodeByNodeOrder(nArray5);
                    this.relabelClusterLabels(nArray3, nArray2);
                    for (n7 = 0; n7 < this.numdata; ++n7) {
                        this.clusterLabels.setParameterValue(n7, nArray3[n7]);
                    }
                    this.setVirusLocationAutoCorrelatedModel();
                    if (n == 0 && i == 0) {
                        for (n7 = 0; n7 < this.numdata; ++n7) {
                            Parameter parameter = this.virusLocations.getParameter(n7);
                        }
                    }
                    dArray2[i] = this.clusterLikelihood.getLogLikelihood();
                    continue;
                }
                dArray2[i] = Double.NEGATIVE_INFINITY;
            }
            double[] dArray3 = this.calculateConditionalProbabilityGivenLogNumeratorProb(dArray2);
            for (n8 = 0; n8 < this.numNodes; ++n8) {
                System.out.println("node " + n8 + " p=" + dArray3[n8]);
            }
            System.out.println("===============================");
            n8 = MathUtils.randomChoicePDF(dArray3);
            nArray5 = new int[n + 1];
            for (n7 = 0; n7 < n; ++n7) {
                nArray5[n7] = nArray[n7];
            }
            nArray5[n] = n8;
            nArray = nArray5;
            nArray3 = this.setClusterLabelsByTestCutNodeByNodeOrder(nArray5);
            this.relabelClusterLabels(nArray3, nArray2);
            nArray2 = nArray3;
        }
        this.printCutNode(nArray);
        this.resetStatusAndBreakpointsGivenCutNodes(nArray, nArray4);
        nArray3 = this.setClusterLabelsByTestCutNodeByNodeOrder(nArray);
        this.relabelClusterLabels(nArray3, nArray2);
        for (n = 0; n < this.numdata; ++n) {
            this.clusterLabels.setParameterValue(n, nArray3[n]);
        }
        this.setVirusLocationAutoCorrelatedModel();
        System.out.println(this.clusterLikelihood.getLogLikelihood());
        nArray[0] = 785;
        nArray[1] = 775;
        nArray[2] = 763;
        nArray[3] = 697;
        nArray[4] = 747;
        nArray[5] = 679;
        nArray[6] = 662;
        nArray[7] = 638;
        nArray[8] = 521;
        this.resetStatusAndBreakpointsGivenCutNodes(nArray, nArray4);
        nArray3 = this.setClusterLabelsByTestCutNodeByNodeOrder(nArray);
        this.relabelClusterLabels(nArray3, nArray2);
        for (n = 0; n < this.numdata; ++n) {
            this.clusterLabels.setParameterValue(n, nArray3[n]);
        }
        this.setVirusLocationAutoCorrelatedModel();
        System.out.println(this.clusterLikelihood.getLogLikelihood());
        System.exit(0);
        return Double.POSITIVE_INFINITY;
    }

    private void resetStatusAndBreakpointsGivenCutNodes(int[] nArray, int[] nArray2) {
        int n;
        for (n = 0; n < this.binSize; ++n) {
            this.status.setParameterValue(n, 0.0);
            this.breakPoints.setParameterValue(n, -1.0);
        }
        n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < this.binSize; ++i) {
            if (n2 >= n) continue;
            this.status.setParameterValue(nArray2[n2], 1.0);
            this.breakPoints.setParameterValue(nArray2[n2], nArray[n2]);
            ++n2;
        }
    }

    private void updateK() {
        int n = 0;
        for (int i = 0; i < this.binSize; ++i) {
            n += (int)this.status.getParameterValue(i);
        }
        this.K.setParameterValue(0, n);
    }

    private void printCutNode(int[] nArray) {
        System.out.print("sampled:\t[");
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print(nArray[i] + ",");
        }
        System.out.println("]");
    }

    private double[] calculateConditionalProbabilityGivenLogNumeratorProb(double[] dArray) {
        int n = dArray.length;
        double d = dArray[0];
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == Double.NEGATIVE_INFINITY) continue;
            d2 += Math.exp(dArray[i] - d);
        }
        d2 = Math.log(d2) + d;
        double d3 = 0.0;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.exp(dArray[i] - d2);
            d3 += dArray2[i];
            if (!(dArray2[i] > 0.01)) continue;
        }
        return dArray2;
    }

    private double verifyAssumption(double d, double[] dArray) {
        int n;
        for (n = 0; n < this.numNodes; ++n) {
            System.out.println(dArray[n]);
        }
        n = dArray.length;
        double d2 = dArray[0];
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] > d2)) continue;
            d2 = dArray[i];
        }
        System.out.println("maxLogProb = " + d2);
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == Double.NEGATIVE_INFINITY) continue;
            d3 += Math.exp(dArray[i] - d2);
        }
        System.out.println("tmp sum = " + d3);
        d3 = Math.log(d3) + d2;
        System.out.println("topLogMarginal = " + d);
        System.out.println("sumLogDenominator = " + d3);
        double d4 = Math.exp(Math.log(n - 1) + d - d3);
        return d4;
    }

    private int checkSiteHasBeenAddedToOnIndicators(int n) {
        int n2 = 0;
        for (int i = 0; i < this.binSize; ++i) {
            if ((int)this.status.getParameterValue(i) != 1 || (int)this.breakPoints.getParameterValue(i) != n) continue;
            n2 = 1;
            break;
        }
        return n2;
    }

    private void setVirusLocationAndOffsets() {
        int n;
        int n2;
        double[] dArray = new double[this.binSize];
        double[] dArray2 = new double[this.binSize];
        for (n2 = 0; n2 < this.numdata; ++n2) {
            n = (int)this.clusterLabels.getParameterValue(n2);
            double d = 0.0;
            if (this.virusOffsetsParameter != null) {
                d = this.virusOffsetsParameter.getParameterValue(n2);
            } else {
                System.out.println("virus Offeset Parameter NOT present. We expect one though. Something is wrong.");
            }
            dArray[n] = dArray[n] + d;
            dArray2[n] = dArray2[n] + 1.0;
        }
        for (n2 = 0; n2 < this.binSize; ++n2) {
            if (!(dArray2[n2] > 0.0)) continue;
            dArray[n2] = dArray[n2] / dArray2[n2];
        }
        this.mu0_offset = new double[this.binSize];
        for (n2 = 0; n2 < this.binSize; ++n2) {
            this.mu0_offset[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < this.numdata; ++n2) {
            n = (int)this.clusterLabels.getParameterValue(n2);
            Parameter parameter = this.virusLocations.getParameter(n2);
            double d = this.mu.getParameter(n).getParameterValue(0);
            parameter.setParameterValue(0, d);
            double d2 = this.mu.getParameter(n).getParameterValue(1);
            parameter.setParameterValue(1, d2);
        }
        for (n2 = 0; n2 < this.numdata; ++n2) {
            n = (int)this.clusterLabels.getParameterValue(n2);
            if (this.clusterOffsetsParameter == null) continue;
            this.clusterOffsetsParameter.setParameterValue(n2, this.mu0_offset[n]);
        }
    }

    private void setVirusLocationAutoCorrelatedModel() {
        Serializable serializable;
        int n;
        int n2;
        int n3 = this.treeModel.getNodeCount();
        double[][] dArray = new double[n3][2];
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = -1;
        }
        for (n2 = 0; n2 < this.binSize; ++n2) {
            if ((int)this.status.getParameterValue(n2) != 1) continue;
            nArray[(int)this.breakPoints.getParameterValue((int)n2)] = n2;
        }
        NodeRef nodeRef = this.treeModel.getRoot();
        LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
        linkedList.add(nodeRef);
        int n4 = 0;
        while (linkedList.size() > 0) {
            ++n4;
            if (this.treeModel.getParent(nodeRef) == null) {
                Parameter parameter = this.mu.getParameter(0);
                dArray[nodeRef.getNumber()][0] = parameter.getParameterValue(0);
                dArray[nodeRef.getNumber()][1] = parameter.getParameterValue(1);
            } else {
                dArray[nodeRef.getNumber()][0] = dArray[this.treeModel.getParent(nodeRef).getNumber()][0];
                dArray[nodeRef.getNumber()][1] = dArray[this.treeModel.getParent(nodeRef).getNumber()][1];
                if (nArray[nodeRef.getNumber()] != -1) {
                    Parameter parameter = this.mu.getParameter(nArray[nodeRef.getNumber()] + 1);
                    double[] dArray2 = dArray[nodeRef.getNumber()];
                    dArray2[0] = dArray2[0] + parameter.getParameterValue(0);
                    double[] dArray3 = dArray[nodeRef.getNumber()];
                    dArray3[1] = dArray3[1] + parameter.getParameterValue(1);
                }
            }
            for (n = 0; n < this.treeModel.getChildCount(nodeRef); ++n) {
                serializable = this.treeModel.getChild(nodeRef, n);
                linkedList.add(serializable);
            }
            linkedList.pop();
            if (linkedList.size() <= 0) continue;
            nodeRef = (NodeRef)linkedList.getFirst();
        }
        for (n = 0; n < this.numdata; ++n) {
            serializable = this.virusLocations.getParameter(n);
            serializable.setParameterValue(0, dArray[this.membershipToClusterLabelIndexes[n]][0]);
            serializable.setParameterValue(1, dArray[this.membershipToClusterLabelIndexes[n]][1]);
        }
    }

    private void relabelClusterLabels(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (n >= nArray2[i]) continue;
            n = nArray2[i];
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (hashMap.get(new Integer(nArray[i])) == null) {
                if (nArray3[nArray2[i]] == 0) {
                    hashMap.put(new Integer(nArray[i]), new Integer(nArray2[i]));
                    nArray3[nArray2[i]] = 1;
                } else {
                    hashMap.put(new Integer(nArray[i]), new Integer(++n));
                }
            }
            nArray[i] = (Integer)hashMap.get(new Integer(nArray[i]));
        }
    }

    private int[] setClusterLabelsByTestCutNodeByNodeOrder(int[] nArray) {
        int[] nArray2 = TreeClusterSequentialSampling.determine_membershipByNodeOrder(this.treeModel, nArray, nArray.length);
        int[] nArray3 = new int[this.numdata];
        for (int i = 0; i < this.numdata; ++i) {
            nArray3[i] = nArray2[this.membershipToClusterLabelIndexes[i]];
        }
        return nArray3;
    }

    private void setMembershipToClusterLabelIndexes() {
        int n = this.treeModel.getNodeCount();
        this.membershipToClusterLabelIndexes = new int[this.numdata];
        for (int i = 0; i < this.numdata; ++i) {
            Parameter parameter = this.virusLocations.getParameter(i);
            String string = parameter.getParameterName();
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                String string2 = this.treeModel.getTaxonId(j);
                if (!string.equals(string2)) continue;
                this.membershipToClusterLabelIndexes[i] = j;
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("not found. Exit now.");
            System.exit(0);
        }
    }

    private int[] setClusterLabelsByTestCutNode(int[] nArray) {
        int[] nArray2 = TreeClusterSequentialSampling.determine_membership(this.treeModel, nArray, nArray.length);
        int[] nArray3 = new int[this.numdata];
        for (int i = 0; i < this.numdata; ++i) {
            nArray3[i] = nArray2[this.membershipToClusterLabelIndexes[i]];
        }
        return nArray3;
    }

    private void setClusterLabels(int n) {
        Parameter parameter;
        int n2;
        int n3 = this.treeModel.getNodeCount();
        int[] nArray = new int[n];
        int n4 = 0;
        String string = "";
        for (int i = 0; i < this.binSize; ++i) {
            if ((int)this.status.getParameterValue(i) != 1) continue;
            nArray[n4] = (int)this.breakPoints.getParameterValue(i);
            string = string + (int)this.breakPoints.getParameterValue(i) + ",";
            ++n4;
        }
        if (n4 != n) {
            System.out.println("cutNum != K_int. we got a problem");
        }
        int[] nArray2 = TreeClusterSequentialSampling.determine_membership(this.treeModel, nArray, n);
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            d += (double)(nArray2[i] * i);
        }
        int[] nArray3 = new int[this.numdata];
        for (n2 = 0; n2 < this.numdata; ++n2) {
            parameter = this.virusLocations.getParameter(n2);
            String string2 = parameter.getParameterName();
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                String string3 = this.treeModel.getTaxonId(i);
                if (!string2.equals(string3)) continue;
                nArray3[n2] = i;
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("not found. Exit now.");
            System.exit(0);
        }
        for (n2 = 0; n2 < this.numdata; ++n2) {
            parameter = this.virusLocations.getParameter(n2);
            this.clusterLabels.setParameterValue(n2, nArray2[nArray3[n2]]);
        }
    }

    private static boolean isCutNode(int n, int[] nArray, int n2) {
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    static int[] determine_membership(TreeModel treeModel, int[] nArray, int n) {
        NodeRef nodeRef = treeModel.getRoot();
        int n2 = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                nArray2[nodeRef2.getNumber()] = TreeClusterSequentialSampling.isCutNode(nodeRef2.getNumber(), nArray, n) ? ++n2 - 1 : nArray2[treeModel.getParent(nodeRef2).getNumber()];
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray2;
    }

    static int[] determine_membershipByNodeOrder(TreeModel treeModel, int[] nArray, int n) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(new Integer(nArray[i]), new Integer(i + 1));
        }
        NodeRef nodeRef = treeModel.getRoot();
        boolean bl = true;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                nArray2[nodeRef2.getNumber()] = TreeClusterSequentialSampling.isCutNode(nodeRef2.getNumber(), nArray, n) ? (Integer)hashMap.get(new Integer(nodeRef2.getNumber())) : nArray2[treeModel.getParent(nodeRef2).getNumber()];
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray2;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
    }

    @Override
    public void reject() {
        super.reject();
        System.out.println("        \t*      Rejected!");
    }

    @Override
    public final String getOperatorName() {
        return TREE_CLUSTERSEQUENTIAL_OPERATOR;
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public int getStepCount() {
        return 1;
    }
}

