/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.inference.model.Likelihood;
import dr.inference.operators.EllipticalSliceOperator;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ConstrainedGaussianProcessRandomGenerator
implements GaussianProcessRandomGenerator {
    private final GaussianProcessRandomGenerator generator;
    private final boolean translationInvariant;
    private final boolean rotationInvariant;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String CONSTAINED_GAUSSIAN_PROCESS = "constrainedGaussianProcess";
        public static final String TRANSLATION_INVARIANT = "translationInvariant";
        public static final String ROTATION_INVARIANT = "rotationInvariant";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(GaussianProcessRandomGenerator.class), AttributeRule.newBooleanRule("translationInvariant", true), AttributeRule.newBooleanRule("rotationInvariant", true)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.getAttribute(TRANSLATION_INVARIANT, false);
            boolean bl2 = xMLObject.getAttribute(ROTATION_INVARIANT, false);
            GaussianProcessRandomGenerator gaussianProcessRandomGenerator = (GaussianProcessRandomGenerator)xMLObject.getChild(GaussianProcessRandomGenerator.class);
            return new ConstrainedGaussianProcessRandomGenerator(gaussianProcessRandomGenerator, bl, bl2);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Returns a random draw of traits given a trait model and a prior";
        }

        @Override
        public Class getReturnType() {
            return ConstrainedGaussianProcessRandomGenerator.class;
        }

        @Override
        public String getParserName() {
            return CONSTAINED_GAUSSIAN_PROCESS;
        }
    };

    public ConstrainedGaussianProcessRandomGenerator(GaussianProcessRandomGenerator gaussianProcessRandomGenerator, boolean bl, boolean bl2) {
        this.generator = gaussianProcessRandomGenerator;
        this.translationInvariant = bl;
        this.rotationInvariant = bl2;
    }

    @Override
    public Likelihood getLikelihood() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getDimension() {
        return this.generator.getDimension();
    }

    @Override
    public double[][] getPrecisionMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Object nextRandom() {
        double[] dArray = (double[])this.generator.nextRandom();
        EllipticalSliceOperator.transformPoint(dArray, this.translationInvariant, this.rotationInvariant, 2);
        return dArray;
    }

    @Override
    public double logPdf(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean isTranslationInvariant() {
        return this.translationInvariant;
    }
}

