/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.NormalNormalMeanGibbsOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.DataModel;
import org.ohdsi.metaAnalysis.HalfNormalOnStdDevPrior;
import org.ohdsi.metaAnalysis.LocationHyperPrior;
import org.ohdsi.metaAnalysis.ScalePrior;
import org.ohdsi.metaAnalysis.SkewNormalDataModel;

public class MetaAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final Parameter theta;
    private final Parameter mu;
    private final Parameter tau;
    private final OperatorSchedule schedule;

    public MetaAnalysis(DataModel dataModel, ScalePrior scalePrior, double d) {
        this(dataModel, scalePrior, new LocationHyperPrior(d));
    }

    public MetaAnalysis(DataModel dataModel, ScalePrior scalePrior, LocationHyperPrior locationHyperPrior) {
        Likelihood likelihood = dataModel.getLikelihood();
        this.theta = dataModel.getCompoundParameter();
        this.mu = new Parameter.Default("mu", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.tau = scalePrior.getParameter();
        boolean bl = scalePrior.isPrecision();
        DistributionLikelihood distributionLikelihood = new DistributionLikelihood(this.getMuDistribution(this.mu, this.tau, bl, locationHyperPrior));
        distributionLikelihood.addData((Attribute)this.theta);
        int n = 0;
        this.likelihood = new CompoundLikelihood(n, Arrays.asList(likelihood, distributionLikelihood));
        DistributionLikelihood distributionLikelihood2 = new DistributionLikelihood((Distribution)new NormalDistribution(0.0, locationHyperPrior.getSd()));
        distributionLikelihood2.addData((Attribute)this.mu);
        Likelihood likelihood2 = scalePrior.getPrior();
        this.prior = new CompoundLikelihood(Arrays.asList(distributionLikelihood2, likelihood2));
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double d = 1.0;
        this.schedule.addOperator(this.getMuOperator(this.mu, distributionLikelihood, distributionLikelihood2.getDistribution(), d));
        AdaptationMode adaptationMode = AdaptationMode.ADAPTATION_ON;
        this.schedule.addOperator(scalePrior.getOperator(distributionLikelihood, d, adaptationMode));
        RandomWalkOperator.BoundaryCondition boundaryCondition = RandomWalkOperator.BoundaryCondition.reflecting;
        for (Parameter parameter : dataModel.getIndividualParameters()) {
            this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(parameter, null, 0.75, boundaryCondition, d, adaptationMode));
        }
    }

    protected MCMCOperator getMuOperator(Parameter parameter, DistributionLikelihood distributionLikelihood, Distribution distribution, double d) {
        return new NormalNormalMeanGibbsOperator(distributionLikelihood, distribution, d);
    }

    protected ParametricDistributionModel getMuDistribution(Parameter parameter, Parameter parameter2, boolean bl, LocationHyperPrior locationHyperPrior) {
        return new NormalDistributionModel(parameter, parameter2, bl);
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        ArrayList<Loggable> arrayList = new ArrayList<Loggable>();
        arrayList.add((Loggable)this.likelihood);
        arrayList.add((Loggable)this.prior);
        arrayList.add((Loggable)this.mu);
        arrayList.add((Loggable)this.tau);
        if (this.theta != null) {
            arrayList.add((Loggable)this.theta);
        }
        return arrayList;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    public static void main(String[] stringArray) {
        int n = 1100000;
        int n2 = 100000;
        int n3 = 1000;
        MetaAnalysis metaAnalysis = new MetaAnalysis((DataModel)new SkewNormalDataModel("c:/temp/skewnormal_example_3.csv"), (ScalePrior)new HalfNormalOnStdDevPrior(0.0, 2.0), 1000.0);
        Runner runner = new Runner(metaAnalysis, n, n2, n3, 666.0);
        runner.run();
        runner.processSamples();
    }
}

