/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleChebyshev
extends AbstractDoubleIterativeSolver {
    private double eigmin;
    private double eigmax;
    private DoubleMatrix1D p;
    private DoubleMatrix1D z;
    private DoubleMatrix1D r;
    private DoubleMatrix1D q;

    public DoubleChebyshev(DoubleMatrix1D doubleMatrix1D, double d, double d2) {
        this.p = doubleMatrix1D.copy();
        this.z = doubleMatrix1D.copy();
        this.r = doubleMatrix1D.copy();
        this.q = doubleMatrix1D.copy();
        this.setEigenvalues(d, d2);
    }

    public void setEigenvalues(double d, double d2) {
        this.eigmin = d;
        this.eigmax = d2;
        if (d <= 0.0) {
            throw new IllegalArgumentException("eigmin <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("eigmax <= 0");
        }
        if (d > d2) {
            throw new IllegalArgumentException("eigmin > eigmax");
        }
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        doubleMatrix2D.zMult(doubleMatrix1D2, this.r.assign(doubleMatrix1D), -1.0, 1.0, false);
        d3 = (this.eigmax - this.eigmin) / 2.0;
        d4 = (this.eigmax + this.eigmin) / 2.0;
        this.iter.setFirst();
        while (!this.iter.converged(this.r, doubleMatrix1D2)) {
            this.M.apply(this.r, this.z);
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
                d = 2.0 / d4;
            } else {
                d2 = d * d3 / 2.0;
                d2 *= d2;
                d = 1.0 / (d4 - d2);
                this.p.assign(this.z, DoubleFunctions.plusMultFirst(d2));
            }
            doubleMatrix2D.zMult(this.p, this.q);
            doubleMatrix1D2.assign(this.p, DoubleFunctions.plusMultSecond(d));
            this.r.assign(this.q, DoubleFunctions.plusMultSecond(-d));
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

