/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.hashset;

import com.sosnoski.util.hashset.PrimitiveSetBase;

public class DoubleHashSet
extends PrimitiveSetBase {
    protected double[] m_keyTable;

    public DoubleHashSet(int n, double d) {
        super(n, d, Double.TYPE);
    }

    public DoubleHashSet(int n) {
        this(n, 0.3);
    }

    public DoubleHashSet() {
        this(0, 0.3);
    }

    public DoubleHashSet(DoubleHashSet doubleHashSet) {
        super(doubleHashSet);
    }

    protected Object getKeyArray() {
        return this.m_keyTable;
    }

    protected void setKeyArray(Object object) {
        this.m_keyTable = (double[])object;
    }

    protected final boolean reinsert(int n) {
        this.m_flagTable[n] = false;
        return this.assignSlot(this.m_keyTable[n]) != n;
    }

    protected void restructure(boolean[] blArray, Object object) {
        double[] dArray = (double[])object;
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n]) {
                this.assignSlot(dArray[n]);
            }
            ++n;
        }
    }

    protected final int computeSlot(double d) {
        long l = Double.doubleToRawLongBits(d);
        int n = (int)(l >> 48) + (int)(l >> 24) + (int)l;
        return (n * 517 & Integer.MAX_VALUE) % this.m_flagTable.length;
    }

    protected int assignSlot(double d) {
        int n = this.freeSlot(this.computeSlot(d));
        this.m_flagTable[n] = true;
        this.m_keyTable[n] = d;
        return n;
    }

    public boolean add(double d) {
        this.ensureCapacity(this.m_entryCount + 1);
        int n = -this.internalFind(d) - 1;
        if (n >= 0) {
            ++this.m_entryCount;
            this.m_flagTable[n] = true;
            this.m_keyTable[n] = d;
            return true;
        }
        return false;
    }

    protected final int internalFind(double d) {
        int n = this.computeSlot(d);
        while (this.m_flagTable[n]) {
            if (d == this.m_keyTable[n]) {
                return n;
            }
            n = this.stepSlot(n);
        }
        return -n - 1;
    }

    public boolean contains(double d) {
        return this.internalFind(d) >= 0;
    }

    public boolean remove(double d) {
        int n = this.internalFind(d);
        if (n >= 0) {
            this.m_flagTable[n] = false;
            --this.m_entryCount;
            while (this.m_flagTable[n = this.stepSlot(n)]) {
                this.reinsert(n);
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        return new DoubleHashSet(this);
    }
}

