/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.QualityFunction;

public class CohesivenessFunction
implements QualityFunction {
    double penalty = 0.0;

    public CohesivenessFunction() {
        this(0.0);
    }

    public CohesivenessFunction(double penalty) {
        this.penalty = penalty;
    }

    public double calculate(NodeSet nodeSet) {
        double num = nodeSet.totalInternalEdgeWeight;
        double den = nodeSet.totalInternalEdgeWeight + nodeSet.totalBoundaryEdgeWeight + (double)nodeSet.size() * this.penalty;
        return num / den;
    }

    public double getAdditionAffinity(MutableNodeSet nodeSet, int index) {
        double num = nodeSet.totalInternalEdgeWeight + nodeSet.inWeights[index];
        double den = nodeSet.totalInternalEdgeWeight + nodeSet.totalBoundaryEdgeWeight + nodeSet.outWeights[index] + (double)(nodeSet.size() + 1) * this.penalty;
        return num / den;
    }

    public double getRemovalAffinity(MutableNodeSet nodeSet, int index) {
        double num = nodeSet.totalInternalEdgeWeight - nodeSet.inWeights[index];
        double den = nodeSet.totalInternalEdgeWeight + nodeSet.totalBoundaryEdgeWeight - nodeSet.outWeights[index] + (double)(nodeSet.size() - 1) * this.penalty;
        return num / den;
    }
}

