/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cmdline;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import uk.ac.rhul.cs.cl1.ClusterONE;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.ClusterONEException;
import uk.ac.rhul.cs.cl1.io.CSVClusteringWriter;
import uk.ac.rhul.cs.cl1.io.ClusteringWriter;
import uk.ac.rhul.cs.cl1.io.ClusteringWriterFactory;
import uk.ac.rhul.cs.cl1.io.GraphReader;
import uk.ac.rhul.cs.cl1.io.GraphReaderFactory;
import uk.ac.rhul.cs.cl1.ui.ConsoleTaskMonitor;
import uk.ac.rhul.cs.graph.Graph;

public class CommandLineApplication {
    protected Options options = null;
    protected boolean debugMode = false;

    public CommandLineApplication() {
        this.initOptions();
    }

    public int run(String[] args) {
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        ClusterONEAlgorithmParameters params = new ClusterONEAlgorithmParameters();
        String inputFormatSpec = null;
        String outputFormatSpec = null;
        GraphReaderFactory.Format inputFormat = null;
        ClusteringWriterFactory.Format outputFormat = null;
        ClusteringWriter outputWriter = null;
        try {
            cmd = parser.parse(this.options, args);
            if (cmd.hasOption("version")) {
                this.showVersion();
                return 0;
            }
            if (cmd.hasOption("debug")) {
                this.debugMode = true;
            }
            if (cmd.hasOption("fluff")) {
                params.setFluffClusters(true);
            }
            if (cmd.hasOption("haircut")) {
                params.setHaircutThreshold(Double.parseDouble(cmd.getOptionValue("haircut")));
            }
            if (cmd.hasOption("k-core")) {
                params.setKCoreThreshold(Integer.parseInt(cmd.getOptionValue("k-core")));
            }
            if (cmd.hasOption("input-format")) {
                inputFormatSpec = cmd.getOptionValue("input-format");
            }
            if (cmd.hasOption("max-overlap")) {
                params.setOverlapThreshold(Double.parseDouble(cmd.getOptionValue("max-overlap")));
            }
            if (cmd.hasOption("merge-method")) {
                params.setMergingMethodName(cmd.getOptionValue("merge-method").toString());
            }
            if (cmd.hasOption("min-density")) {
                String value = cmd.getOptionValue("min-density");
                if (value == null || value.equalsIgnoreCase("auto")) {
                    params.setMinDensity(null);
                } else {
                    params.setMinDensity(Double.parseDouble(value));
                }
            }
            if (cmd.hasOption("min-size")) {
                params.setMinSize(Integer.parseInt(cmd.getOptionValue("min-size")));
            }
            if (cmd.hasOption("no-fluff")) {
                params.setFluffClusters(false);
            }
            if (cmd.hasOption("no-merge")) {
                params.setMergingMethodName("none");
            }
            if (cmd.hasOption("output-format")) {
                outputFormatSpec = cmd.getOptionValue("output-format");
            }
            if (cmd.hasOption("penalty")) {
                params.setNodePenalty(Double.parseDouble(cmd.getOptionValue("penalty")));
            }
            if (cmd.hasOption("seed-method")) {
                params.setSeedGenerator(cmd.getOptionValue("seed-method").toString());
            }
            if (cmd.hasOption("similarity")) {
                params.setSimilarityFunction(cmd.getOptionValue("similarity").toString());
            }
        }
        catch (ParseException ex) {
            System.err.println("Failed to parse command line options. Reason: " + ex.getMessage());
            return 1;
        }
        catch (InstantiationException ex) {
            System.err.println("Failed to interpret string: " + cmd.getOptionValue("seed-method").toString());
            ex.printStackTrace();
            return 1;
        }
        if (cmd.getArgList().size() == 0 || cmd.hasOption('h')) {
            this.showUsage();
            return 0;
        }
        if (cmd.getArgList().size() > 1) {
            System.err.println("Only a single input file is supported");
            return 1;
        }
        if (inputFormatSpec != null) {
            try {
                inputFormat = GraphReaderFactory.Format.valueOf(inputFormatSpec.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Unknown input file format: " + inputFormatSpec);
                return 1;
            }
        }
        if (outputFormatSpec != null) {
            try {
                outputFormat = ClusteringWriterFactory.Format.valueOf(outputFormatSpec.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Unknown output file format: " + outputFormatSpec);
                return 1;
            }
        } else {
            outputFormat = ClusteringWriterFactory.Format.PLAIN;
        }
        outputWriter = ClusteringWriterFactory.fromFormat(outputFormat);
        if (outputFormat == ClusteringWriterFactory.Format.CSV) {
            ((CSVClusteringWriter)outputWriter).setQualityFunction(params.getQualityFunction());
        }
        Graph graph = null;
        try {
            graph = this.loadGraph(cmd.getArgs()[0], inputFormat);
        }
        catch (IOException ex) {
            System.err.println("IO error while reading input file: " + ex.getMessage());
            return 1;
        }
        System.err.println("Loaded graph with " + graph.getNodeCount() + " nodes and " + graph.getEdgeCount() + " edges");
        ClusterONE algorithm = new ClusterONE(params);
        algorithm.setDebugMode(this.debugMode);
        algorithm.setTaskMonitor(new ConsoleTaskMonitor());
        try {
            algorithm.runOnGraph(graph);
        }
        catch (ClusterONEException ex) {
            System.err.println("Error while executing the clustering algorithm: ");
            System.err.println(ex.getMessage());
            return 1;
        }
        System.err.println("Detected " + algorithm.getResults().size() + " complexes");
        try {
            outputWriter.writeClustering(algorithm.getResults(), System.out);
        }
        catch (IOException ex) {
            System.err.println("IO error while printing the results: ");
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }

    protected void initOptions() {
        this.options = new Options();
        this.options.addOption("h", "help", false, "shows this help message");
        this.options.addOption("v", "version", false, "shows the version number");
        OptionBuilder.withLongOpt("input-format");
        OptionBuilder.withDescription("specifies the format of the input file (sif or edge_list)");
        OptionBuilder.withType(String.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create("f"));
        OptionBuilder.withLongOpt("output-format");
        OptionBuilder.withDescription("specifies the format of the output file (plain, genepro or csv)");
        OptionBuilder.withType(String.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create("F"));
        OptionBuilder.withLongOpt("min-size");
        OptionBuilder.withDescription("specifies the minimum size of clusters");
        OptionBuilder.withType(Integer.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create("s"));
        OptionBuilder.withLongOpt("min-density");
        OptionBuilder.withDescription("specifies the minimum density of clusters (default: auto)");
        OptionBuilder.withType(Float.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("max-overlap");
        OptionBuilder.withDescription("specifies the maximum allowed overlap between two clusters");
        OptionBuilder.withType(Float.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("haircut");
        OptionBuilder.withDescription("specifies the haircut threshold for clusters");
        OptionBuilder.withType(Float.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("penalty");
        OptionBuilder.withDescription("set the node penalty value");
        OptionBuilder.withType(Float.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("k-core");
        OptionBuilder.withDescription("specifies the minimum k-core index of clusters");
        OptionBuilder.withType(Integer.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create());
        OptionGroup fluffGroup = new OptionGroup();
        OptionBuilder.withLongOpt("fluff");
        OptionBuilder.withDescription("fluffs the clusters");
        OptionBuilder.withType(Boolean.class);
        fluffGroup.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("no-fluff");
        OptionBuilder.withDescription("don't fluff the clusters (default)");
        OptionBuilder.withType(Boolean.class);
        fluffGroup.addOption(OptionBuilder.create());
        this.options.addOptionGroup(fluffGroup);
        OptionBuilder.withLongOpt("merge-method");
        OptionBuilder.withDescription("specifies the cluster merging method to use (single or multi)");
        OptionBuilder.withType(String.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("seed-method");
        OptionBuilder.withDescription("specifies the seed generation method to use");
        OptionBuilder.withType(String.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("similarity");
        OptionBuilder.withDescription("specifies the similarity function to use (match, simpson, jaccard or dice)");
        OptionBuilder.withType(String.class);
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("debug");
        OptionBuilder.withDescription("turns on the debug mode");
        OptionBuilder.withType(Boolean.class);
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("no-merge");
        OptionBuilder.withDescription("don't merge highly overlapping clusters");
        this.options.addOption(OptionBuilder.create());
    }

    public void showUsage() {
        HelpFormatter formatter = new HelpFormatter();
        this.showVersion();
        System.out.println("");
        formatter.printHelp("cl1", this.options, true);
    }

    public void showVersion() {
        System.out.println("ClusterONE 1.0");
    }

    public Graph loadGraph(String filename, GraphReaderFactory.Format format) throws IOException {
        GraphReader reader = format == null ? ("-".equals(filename) ? GraphReaderFactory.fromFormat(GraphReaderFactory.Format.EDGE_LIST) : GraphReaderFactory.fromFilename(filename)) : GraphReaderFactory.fromFormat(format);
        InputStream stream = "-".equals(filename) ? System.in : new FileInputStream(filename);
        return reader.readGraph(new InputStreamReader(stream, "utf-8"));
    }

    public static void main(String[] args) {
        CommandLineApplication app = new CommandLineApplication();
        System.exit(app.run(args));
    }
}

