/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.intlincomb;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.IntLinComb;
import choco.cp.solver.constraints.integer.bool.BoolIntLinComb;
import choco.cp.solver.constraints.integer.bool.sum.EqBoolSum;
import choco.cp.solver.constraints.integer.bool.sum.GeqBoolSum;
import choco.cp.solver.constraints.integer.bool.sum.LeqBoolSum;
import choco.cp.solver.constraints.integer.bool.sum.NeqBoolSum;
import choco.cp.solver.variables.integer.IntTerm;
import choco.kernel.common.Constant;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;

public final class IntLinCombFactory {
    private static int countNonNullCoeffs(int[] lcoeffs) {
        int nbNonNull = 0;
        for (int lcoeff : lcoeffs) {
            if (lcoeff == 0) continue;
            ++nbNonNull;
        }
        return nbNonNull;
    }

    private static SConstraint eq(int cste) {
        return cste == 0 ? Constant.TRUE : Constant.FALSE;
    }

    private static SConstraint geq(int cste) {
        return cste <= 0 ? Constant.TRUE : Constant.FALSE;
    }

    private static SConstraint neq(int cste) {
        return cste != 0 ? Constant.TRUE : Constant.FALSE;
    }

    public static SConstraint makeIntLinComb(IntTerm t, int c, int linOperator, CPSolver solver) {
        IntVar[] lvars = t.getVariables();
        int[] lcoeffs = t.getCoefficients();
        int nbNonNullCoeffs = IntLinCombFactory.countNonNullCoeffs(lcoeffs);
        if (nbNonNullCoeffs == 0) {
            switch (linOperator) {
                case 0: {
                    return IntLinCombFactory.eq(c);
                }
                case 1: {
                    return IntLinCombFactory.geq(c);
                }
                case 2: {
                    return IntLinCombFactory.neq(c);
                }
            }
            return Constant.FALSE;
        }
        int posIdx = 0;
        int negIdx = nbNonNullCoeffs - 1;
        int[] sortedCoeffs = new int[nbNonNullCoeffs];
        IntDomainVar[] sortedVars = new IntDomainVar[nbNonNullCoeffs];
        for (int i = 0; i < lvars.length; ++i) {
            if (lcoeffs[i] > 0) {
                sortedVars[posIdx] = (IntDomainVar)lvars[i];
                sortedCoeffs[posIdx] = lcoeffs[i];
                ++posIdx;
                continue;
            }
            if (lcoeffs[i] >= 0) continue;
            sortedVars[negIdx] = (IntDomainVar)lvars[i];
            sortedCoeffs[negIdx] = lcoeffs[i];
            --negIdx;
        }
        return IntLinCombFactory.createIntLinComb(sortedVars, sortedCoeffs, posIdx, c, linOperator, solver);
    }

    private static SConstraint createIntLinComb(IntDomainVar[] sortedVars, int[] sortedCoeffs, int nbPositiveCoeffs, int c, int linOperator, CPSolver solver) {
        if (IntLinCombFactory.isBoolLinComb(sortedVars) && linOperator != 2) {
            return IntLinCombFactory.createBoolLinComb(sortedVars, sortedCoeffs, c, linOperator, solver);
        }
        return new IntLinComb(sortedVars, sortedCoeffs, nbPositiveCoeffs, c, linOperator);
    }

    public static boolean isBoolLinComb(IntDomainVar[] lvars) {
        if (lvars.length <= 1) {
            return false;
        }
        int nbEnum = 0;
        for (IntDomainVar lvar : lvars) {
            if (!lvar.hasBooleanDomain()) {
                ++nbEnum;
            }
            if (nbEnum <= 1) continue;
            return false;
        }
        return true;
    }

    public static SConstraint createBoolLinComb(IntVar[] vars, int[] lcoeffs, int c, int linOperator, CPSolver solver) {
        IntDomainVar[] lvars = new IntDomainVar[vars.length];
        System.arraycopy(vars, 0, lvars, 0, vars.length);
        int idxSingleEnum = -1;
        int coefSingleEnum = Integer.MIN_VALUE;
        for (int i = 0; i < lvars.length; ++i) {
            if (lvars[i].hasBooleanDomain()) continue;
            idxSingleEnum = i;
            coefSingleEnum = -lcoeffs[i];
        }
        int nbVar = idxSingleEnum == -1 ? lvars.length : lvars.length - 1;
        IntDomainVar[] vs = new IntDomainVar[nbVar];
        int[] coefs = new int[nbVar];
        int cpt = 0;
        for (int i = 0; i < lvars.length; ++i) {
            if (i == idxSingleEnum) continue;
            vs[cpt] = lvars[i];
            coefs[cpt] = lcoeffs[i];
            ++cpt;
        }
        if (idxSingleEnum == -1) {
            return IntLinCombFactory.createBoolLinComb(vs, coefs, null, Integer.MAX_VALUE, c, linOperator, solver);
        }
        return IntLinCombFactory.createBoolLinComb(vs, coefs, lvars[idxSingleEnum], coefSingleEnum, c, linOperator, solver);
    }

    private static SConstraint createBoolLinComb(IntDomainVar[] vs, int[] coefs, IntDomainVar obj, int objcoef, int c, int linOperator, CPSolver solver) {
        VariableUtils.quicksort(coefs, vs, 0, coefs.length - 1);
        if (obj == null) {
            boolean isAsum = true;
            for (int i = 0; i < vs.length && isAsum; ++i) {
                if (coefs[i] == 1) continue;
                isAsum = false;
                break;
            }
            if (isAsum) {
                switch (linOperator) {
                    case 0: {
                        return new EqBoolSum(solver.getEnvironment(), vs, -c);
                    }
                    case 2: {
                        return new NeqBoolSum(solver.getEnvironment(), vs, -c);
                    }
                    case 3: {
                        return new LeqBoolSum(solver.getEnvironment(), vs, -c);
                    }
                    case 1: {
                        return new GeqBoolSum(solver.getEnvironment(), vs, -c);
                    }
                }
                throw new SolverException("Unknown operator for BoolSum");
            }
            IntDomainVar dummyObj = solver.makeConstantIntVar(-c);
            return new BoolIntLinComb(solver.getEnvironment(), vs, coefs, dummyObj, 1, 0, linOperator);
        }
        int newLinOp = linOperator;
        if (objcoef < 0) {
            if (linOperator != 2) {
                objcoef = -objcoef;
                c = -c;
                VariableUtils.reverse(coefs, vs);
                ArrayUtils.inverseSign(coefs);
            }
            if (linOperator == 1) {
                newLinOp = 3;
            } else if (linOperator == 3) {
                newLinOp = 1;
            }
        }
        return new BoolIntLinComb(solver.getEnvironment(), vs, coefs, obj, objcoef, c, newLinOp);
    }
}

